<?php

class ScenariosWizard
{
	var $gateway 	= 'Gateway'	;
	var $pbx 	= 'Pbx'		;
	var $provider	= 'Provider'	;

	var $radio	= array('name' => 'scenario', 'checkPost' => 'select');

	var $array_scenarios = array( 	'Provider' => array( 'id' => 'provider'	, 'img' => 'voip-provider-wizard.png'	, 'title' => WIZARD_VOIP_PROVIDER_DIS	, 'value' => '3'),
					'Gateway'  => array( 'id' => 'gateway'	, 'img' => 'voip-gateway-wizard.png'	, 'title' => WIZARD_GATEWAY_DIS 	, 'value' => '1'), 
					'Pbx'  	   => array( 'id' => 'pbx'	, 'img' => 'voip-pbx-wizard.png'	, 'title' => WIZARD_VOIP_PBX_DIS	, 'value' => '2'));

	function __construct ($init = true)
	{
		if ($init)
		{
			// check if an ISDN module is plugged
			$is_isdn_plugged = false;

			require_once('./includes/Helper/Helper.php');
			$lif = Helper::getLif();

			foreach ($lif as $if)
			{
				if (preg_match('#S0|E1|t1e1#', $if))
				{
					$is_isdn_plugged = true;
					break;
				}
			}

			if (!($is_isdn_plugged))
			{
				unset($this -> array_scenarios[$this -> provider]);
			}
		}
	}

	// Private 
	function _display_image_scenario ($id_div, $for_label, $title, $img = '', $id_input = '', $value_input = '', $checked = '')
	{
		$input = '';
		if (strlen($id_input) > 0)
		{
			$input = "<input type='radio' name='{$this->radio['name']}' value='$value_input' id='$id_input' $checked/>\n";
		}

		$file_path = "./includes/images/$img";
		if (file_exists($file_path) && strlen($img) > 0)
		{
			$img = "\t\t\t\t\t<img style='margin-left: 25px;' src=\"$file_path\"/>\n";
		}
		else
		{
			$img = '';
		}

		ob_start();
?>
			<div class='form-group' id='<?php echo  $id_div; ?>'>
				<label for='<?php echo $for_label; ?>' class='col-sm-5 control-label'><?php echo $title; ?></label>
				<div class='col-sm-4'>
					<?php	echo 	  $input
							. $img;    ?>
				</div>
			</div>
<?php
		return ob_get_clean();
	}

	function get_content_modal ($scenario_cfg)
	{
		$html_str = '';
		foreach ($this -> array_scenarios as $scenario => $parameter_scenario)
		{
			$id 	= $parameter_scenario['id'];
			$img 	= $parameter_scenario['img'];
			$value	= $parameter_scenario['value'];
			$title 	= $parameter_scenario['title'];

			$checked = '';
			if (isset($scenario_cfg['scenario']))
			{
				if(strcmp($scenario_cfg['scenario'], $value) == 0)
				{
					$checked = ' checked';
				}
			}
			else
			{
				if (strcmp($this -> array_scenarios['Gateway']['value'], $value) == 0)
				{
					$checked = ' checked';
				}
			}

			$html_str .= $this -> _display_image_scenario("form_$id", "for_$id", $title, $img, "id_$id", $value, $checked);
		}

		return $html_str;
	}

	function get_summary_settings ($scenario)
	{
		$title 	 = "\t\t\t<p class='text-center h4'>". WIZARD_SCENARIOS_SETTINGS_DIS ."</p>\n";
	
		// gateway scenario
		$settings = $this -> array_scenarios[$this -> gateway];

		// pbx scenario
		if ($scenario == 2)
		{	
			$settings = $this -> array_scenarios[$this -> pbx];
		}
		// provider scenario
		else if ($scenario == 3)
		{
			$settings = $this -> array_scenarios[$this -> provider];
		}

		$img = $this -> _display_image_scenario("form_{$settings['id']}" , $settings['id'], $settings['title'], $settings['img']);

		return $title . $img;
	}

	function get_post_conditions_list()
	{
		$list_select = array();
		foreach ($this -> array_scenarios as $scenario) 
		{
			$list_select[] = $scenario['value'];
		}

		return array('post' => array($this -> radio['name'] => $this -> radio['checkPost']), 'options' => array($this -> radio['name'] => $list_select));
	}
}

?>
