#!/bin/bash

APPS_HOME=/home/admin
APPS_ROOT=/apps

PKG_NAME=${1}
PKG_UPDT=${2}

PKG_ROOT=${APPS_ROOT}/${PKG_NAME}

PREFIX="[userapp_postinstall]"

if [ -z ${PKG_NAME} ]; then
	echo "${PREFIX} no package name given, leaving."
	exit 1
fi

echo "${PREFIX} running for ${PKG_NAME} (${PKG_ROOT}):"

if [ -d ${PKG_ROOT}/www ]; then
	echo "${PREFIX} creating www-symlink for ${PKG_NAME}."
	ln -s ${PKG_ROOT}/www /home/admin/www/${PKG_NAME}
fi

if [ ! -d /usr/conf/userapp/${PKG_NAME} ]; then
	echo "${PREFIX} creating configuration directory for ${PKG_NAME}."
	mkdir -p /usr/conf/userapp/${PKG_NAME}
fi

if [ ! -d ${PKG_ROOT}/etc ]; then
	echo "${PREFIX} creating etc-symlink for ${PKG_NAME}."
	ln -s /usr/conf/userapp/${PKG_NAME} ${PKG_ROOT}/etc
fi

if [ ! -d ${PKG_ROOT}/var ]; then
	echo "${PREFIX} creating var-symlink for ${PKG_NAME}."
	ln -s /tmp/userapp ${PKG_ROOT}/var
fi

if [ -x ${PKG_ROOT}/setup/post_install.sh ]; then
	echo "${PREFIX} running ${PKG_NAME}s post_install."
	${PKG_ROOT}/setup/post_install.sh
fi

if [ -f ${PKG_ROOT}/../VERSION ]; then
	mv ${PKG_ROOT}/../VERSION ${PKG_ROOT}
fi

if [ -f ${PKG_ROOT}/../content.txt ]; then
	mv ${PKG_ROOT}/../content.txt ${PKG_ROOT}
fi

