#!/usr/bin/php -q
<?php

function getTdmDelay ($type = null) {

	switch ($type) {
	case 'bf2S0':
	case 'bf4S0':
		return(array('xmit' => 14, 'recv' => 14));
	case 'bf1E1':
	case 'bf2E1':
		return(array('xmit' => 15, 'recv' => 14));
	case 'bf1FXS':
	case 'bf2FXS':
	case 'bf4FXS':
	case 'bf8FXS':
	case 'bf2FXO':
	case 'bf4FXO':
		return(array('xmit' => 13, 'recv' => 13));
	case 'bf2S02FXS':
		return(array('xmit' => 15, 'recv' => 15));
	case 'bf1GSM':
	case 'bf2GSM':
	case 'bf2LTE':
		return(array('xmit' => 0, 'recv' => 1));
	case 'bf1t1e1':
	case 'bf2t1e1':
	case 'bf4t1e1':
		return(array('xmit' => 35, 'recv' => 35));
//		return(array('xmit' => 31, 'recv' => 31));
	}

	return(array('xmit' => 14, 'recv' => 14));
}

function getTdmClock ($type = null) {

	switch ($type) {
	case 'bf1GSM':
	case 'bf2GSM':
	case 'bf2LTE':
	case 'bf1t1e1':
	case 'bf2t1e1':
	case 'bf4t1e1':
		return(array('xmit' => 'single_clock', 'recv' => 'single_clock'));
	}

	return(array('xmit' => 'double_clock', 'recv' => 'double_clock'));
}

function getTdmFrameEdge ($type = null) {

	switch ($type) {
	case 'bf1GSM':
	case 'bf2GSM':
	case 'bf2LTE':
		return('on_rising');
	}

	return('on_falling');
}

function getTdmReceiveClock ($type = null) {

	switch ($type) {
	case 'bf1t1e1':
	case 'bf2t1e1':
	case 'bf4t1e1':
		return('on_falling');
	}

	return('on_rising');
}

function evaluateModuleType ($section, &$portCount, &$chanCount, &$skipChan) {

	switch ($section['type']) {
	case 'bf1S0':
	case 'bf2S0':
	case 'bf4S0':
		$portCount = str_replace('bf', '', str_replace('S0', '', $section['type']));
		$chanCount = 2;
		$skipChan = 0;
		return('isdn');
	case 'bf1E1':
	case 'bf2E1':
		$portCount = str_replace('bf', '', str_replace('E1', '', $section['type']));
		$chanCount = 30;
		$skipChan = 0;
		return('isdn');
	case 'bf1FXS':
	case 'bf2FXS':
	case 'bf4FXS':
	case 'bf8FXS':
		$portCount = str_replace('bf', '', str_replace('FXS', '', $section['type']));
		$chanCount = 1;
		$skipChan = 0;
		return('analog');
	case 'bf1FXO':
	case 'bf2FXO':
	case 'bf4FXO':
		$portCount = str_replace('bf', '', str_replace('FXO', '', $section['type']));
		$chanCount = 1;
		$skipChan = 0;
		return('analog');
	case 'bf1GSM':
	case 'bf2GSM':
	case 'bf2LTE':
		$portCount = str_replace('bf', '', str_replace('GSM', '', $section['type']));
		$chanCount = 1;
		$skipChan = 0;
		return('gsm');
	case 'bf1t1e1':
	case 'bf2t1e1':
	case 'bf4t1e1':
		return('t1e1');
	case 'bf2S02FXS':
		return('2s02fxs');
	}

	return('none');
}

function getTdmTimeSlot2S02Fxs (&$portIndex) {

	$tsIndex = 0;
	// isdn-part
	$ts[$portIndex['isdn']][] = array('portIndex' => $portIndex['isdn'], 'chanIndex' => 1, 'tsIndex' => $tsIndex++);
	$ts[$portIndex['isdn']][] = array('portIndex' => $portIndex['isdn'], 'chanIndex' => 2, 'tsIndex' => $tsIndex++);
	$portIndex['isdn']++;

	$ts[$portIndex['isdn']][] = array('portIndex' => $portIndex['isdn'], 'chanIndex' => 1, 'tsIndex' => $tsIndex++);
	$ts[$portIndex['isdn']][] = array('portIndex' => $portIndex['isdn'], 'chanIndex' => 2, 'tsIndex' => $tsIndex++);
	$portIndex['isdn']++;

	// analog-part
	$ts[$portIndex['analog']][] = array('portIndex' => $portIndex['analog'], 'chanIndex' => 1, 'tsIndex' => $tsIndex++);
	$portIndex['analog']++;
	$ts[$portIndex['analog']][] = array('portIndex' => $portIndex['analog'], 'chanIndex' => 1, 'tsIndex' => $tsIndex++);
	$portIndex['analog']++;

	return($ts);
}

function getTdmTimeSlotT1E1 ($section, &$portIndex) {

	$ifaceType = explode(',', $section['interface_type']);
	$ifaceProt = explode(',', $section['protocol']);

	$i = 0;
	foreach ($ifaceType as $iface) {
		switch($iface) {
		case 'hdlc':
			$portType	= 'isdn';
			$portDelim	= 2;
			$skipPort	= 0;
			$chanDelim	= (($ifaceProt[$i] == 'e1') ? 32 : 24);
			$skipChan	= (($ifaceProt[$i] == 'e1') ? 16 : 24);
			break;
		case 'cas':
			$portType	= 'cas';
			$portDelim	= (($ifaceProt[$i] == 'e1') ? 32 : 24);
			$skipPort	= (($ifaceProt[$i] == 'e1') ? 16 : 24);
			$chanDelim	= 2;
			$skipChan	= 0;
			break;
		}

		$tsIndex = $i;
		for ($j = 1; $j < $portDelim; $j++) {
			if ($j == $skipPort) {
				$portIndex[$portType]++;
				continue;
			}

			for ($k = 1; $k < $chanDelim; $k++) {
				if ($k == $skipChan && ($ifaceProt[$i] == 'e1')) {
					$tsIndex += 4;
				}
				$ts[$portIndex[$portType]][] = array('portIndex' => $portIndex[$portType], 'chanIndex' => $k, 'tsIndex' => $tsIndex);
				$tsIndex += 4;
			}
			$portIndex[$portType]++;
		}
		$i++;
	}

	return($ts);
}

function getTdmTimeSlot ($section, &$portIndex) {

	$portType = 'none';
	$portCount = 0;
	$chanCount = 0;
	$skipChan = 0;

	$portType = evaluateModuleType($section, $portCount, $chanCount, $skipChan);

	// special treatment for special cards
	switch ($portType) {
	case '2s02fxs':
		return(getTdmTimeSlot2S02Fxs($portIndex));
	case 't1e1':
		return(getTdmTimeSlotT1E1($section, $portIndex));
	}

	// all 'normal' modules
	$tsIndex = 0;
	for ($i = 0; $i < $portCount; $i++) {
		for ($j = 1; $j <= $chanCount; $j++) {
			if ($j == $skipChan) {
				continue;
			}

			$ts[$portIndex[$portType]][] = array('portIndex' => $portIndex[$portType], 'chanIndex' => $j, 'tsIndex' => $tsIndex);
			$tsIndex++;
		}
		$portIndex[$portType]++;
	}

	return($ts);
}

function tdmWriteConfig ($tdmConfig) {

	$data[] = '; isgw.tdm: autogenerated on ' . date('c') .' by /usr/local/php/makeIsgwTdmConfig.php';

	// write tdm delay
	$data[] = '';
	$data[] = '; tdm_delay: bus clocks_delay_transmitter clocks_delay_receiver';
	if (!empty($tdmConfig)) {
		foreach ($tdmConfig as $index => $config) {
			$data[] = 'tdm_delay ' . ($index + 1) . ' ' . $config['tdm_delay']['xmit'] . ' ' . $config['tdm_delay']['recv'];
		}
	}

	// write clock mode
	$data[] = '';
	$data[] = '; clock_mode: bus mode_transmitter mode_receiver (single_clock/double_clock)';
	if (!empty($tdmConfig)) {
		foreach ($tdmConfig as $index => $config) {
			$data[] = 'clock_mode ' . ($index + 1) . ' ' . $config['clock_mode']['xmit'] . ' ' . $config['clock_mode']['recv'];
		}
	}

	// write frame edge
	$data[] = '';
	$data[] = '; frame_edge: bus frame_edge_detect (on_rising/on_falling)';
	if (!empty($tdmConfig)) {
		foreach ($tdmConfig as $index => $config) {
			$data[] = 'frame_edge ' . ($index + 1) . ' ' . $config['frame_edge'];
		}
	}

	// write receive clock edge
	$data[] = '';
	$data[] = '; receive_clock_edge: bus frame_edge_detect (on_rising/on_falling)';
	if (!empty($tdmConfig)) {
		foreach ($tdmConfig as $index => $config) {
			$data[] = 'receive_clock_edge ' . ($index + 1) . ' ' . $config['clock_edge'];
		}
	}

	// write timeslot configuration
	if (!empty($tdmConfig)) {
		foreach ($tdmConfig as $index => $config) {
			if (empty($config['timeslot'])) {
				//skip empty slots
				continue;
			}
			$data[] = '';
			$data[] = '; lineinterface ' . $index;
			$data[] = '; timeslot: bus port channel timeslot';
			foreach ($config['timeslot'] as $port => $timeslots) {
				foreach ($timeslots as $timeslot) {
					$data[] = 'timeslot ' . ($index + 1) . ' ' . $timeslot['portIndex'] . ' ' . $timeslot['chanIndex'] . ' ' . $timeslot['tsIndex'];
				}
			}
		}
	}

	unset($lines);
	foreach ($data as $line) {
		$lines .= $line . "\n";
	}

	file_put_contents('/usr/conf/isgw.tdm', $lines);
}

/* main-program */
$portIndex = array('isdn' => 1, 'analog' => 101, 'gsm' => 201, 'tport' => 301, 'cas' => 1001);

// get contents of hardware.conf
if (!file_exists('/usr/conf/hardware.conf')) {
	exit(1);
}
$hardwareConf = parse_ini_file('/usr/conf/hardware.conf', true);

foreach ($hardwareConf as $name => $section) {
	if ($name == 'pcm') {
		continue;
	}

	$index = str_replace('lif', '', $name);
	$tdmConfig[$index]['tdm_delay'] = getTdmDelay($section['type']);
	$tdmConfig[$index]['clock_mode'] = getTdmClock($section['type']);
	$tdmConfig[$index]['frame_edge'] = getTdmFrameEdge($section['type']);
	$tdmConfig[$index]['clock_edge'] = getTdmReceiveClock($section['type']);

	if (($name == 'none') || ($name == '0')) {
		continue;
	}
	//add timeslots only for real modules
	$tdmConfig[$index]['timeslot'] = getTdmTimeSlot($section, $portIndex);
}

tdmWriteConfig($tdmConfig);

?>
