<?php
$BEROGUI_PATH = '/usr/local/www/berogui';

/* [LOAD LANG] */
require_once("$BEROGUI_PATH/misc/database.php");
$ba = new beroAri();
include_once("$BEROGUI_PATH/includes/lang.php");

/* [CHECK POST] */
unset($_GET);

$exec_ajax = 1;
$invalid = array();

require_once("$BEROGUI_PATH/includes/Helper/Helper.php");
$parameters = require("$BEROGUI_PATH/modules/Provisioning/provisioning_parameters.php");
Helper::setDataValidator($parameters[3], $list_data, $options_data);

$data = Helper::sanitizePost($_POST, $list_data, $exec_ajax, $invalid, $options_data);
unset($_POST);

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
	die(Helper::jsonEncode(array('#ajaxResult' => "<div style='color:red;'>". PROVISIONING_AJAX_INVALIDDATA_DIS .': '. Helper::displayErrorMessage($invalid['request'], $invalid['checkor']) ."</div>\n")));
}

require_once('/usr/fallback/beroConf.php');
$bc = new beroConf('root');

// store cURL variable
foreach (array('verifyhost', 'verifypeer', 'debug') as $key) {
	$bc->set('root', $parameters[3][$key]['db-key'], $data[$key]);
}

require_once("/usr/php/include/provisioningTool.class.php");
require_once("/usr/php/include/Curl.class.php");
$ch = new Curl($bc, Helper::tlsGetCertificate());
$ch->log_file = '/tmp/provisioning.ajax.log';

$info = array();
$ch->sendRequest(provisioningTool::replaceUrl($data['url'], $bc), array(), $data, $info);

// manage error
$flag = 'red';
$result = '';
if ($ch->hasError()) {
	$error = $ch->getError();
	$result = PROVISIONING_AJAX_CURLERROR_DIS .'<br/>'. $error['msg'];
}
else {
	switch (true) {
	case in_array($info['http_code'], range(200, 299)):
		$flag = 'green';
		$result = PROVISIONING_AJAX_SUCCESSFUL_DIS;
		break;
	case in_array($info['http_code'], range(300,399)):
		$result = PROVISIONING_AJAX_REDIRECTION_DIS;
		break;
	case in_array($info['http_code'], range(400, 499)):
		$result = PROVISIONING_AJAX_CLIENTERROR_DIS;
		break;
	case in_array($info['http_code'], range(500, 599)):
		$result = PROVISIONING_AJAX_SERVERERROR_DIS;
		break;
	default:
		$result = PROVISIONING_AJAX_COULDNOTCONNECT_DIS;
		break;
	}
}

$result = "<div style='color:$flag;'>$result</div>\n";

// manage debug output
if ($data['debug']) {
	// parsing the file content leads to some error
	//// we could use javascript to read the file
	//// but we prefer to base64 encode / decode
	$log = PROVISIONING_AJAX_MISSINGLOG_DIS;
	if (file_exists('/tmp/curl.log')) {
		$log = base64_encode(nl2br(@file_get_contents('/tmp/curl.log')));
		rootHelper::unlink(0, '/tmp/curl.log');
	}
	die(Helper::jsonEncode(array('#ajaxResult' => $result, '#logTest' => $log)));
}
die(Helper::jsonEncode(array('#ajaxResult' => $result)));
?>
