<?php
require_once("/usr/local/www/berogui/includes/Helper/HelperHtml.php");

class Vpn {
	/* [ATTRIBUTS] */
	private $_m;

	private	$_isRequestRejected	= false,
					$_reasonRejected		= null;

	private $_data 				= [],
					$_parameters 	= [];

	private $_tabs = [
						1 => [
							'function' 	=> '_displayServerSettingsTab',
							'title' 		=> 'VPN_SERVERS_SETTINGS_TAB',
						],
						2 => [
							'function'	=> '_displayClientSettingsTab',
							'title' 		=> 'VPN_CLIENTS_SETTINGS_TAB',
						],
						3 => [
							'function'	=> '_displayDownloadClientConfTab', 
							'title' 		=> 'VPN_CLIENT_CONF_DOWNLOAD_TAB',
						],
					];

	/* [CONSTRUCTOR] */
	function __construct($m, $get = [], $post = [], $session = []) {
		$this->_m = $m;

		// load beroAri / beroConf classes -> should be avoided and given as argument of the construct method
		$bc = new beroConf('root');

		require_once("/usr/local/www/berogui/misc/database.php");
		$ba = new beroAri();

		// get data
		require_once("/usr/local/www/berogui/modules/Vpn/vpn_helper.php");
		$this->_parameters = require("/usr/local/www/berogui/modules/Vpn/vpn_parameters.php");
		$this->_parameters = $this->_parameters['load']($bc, $this->_parameters);

		$this->_data = VpnHelper::getData($ba, $this->_parameters);

		// manage tabs
		if (empty($this->_data['clients'])) {
			unset($this->_tabs[2]);
		}
		if (!($bc->get('root', 'is-vpn-running'))) {
			unset($this->_tabs[3]);
		}

		// set error
		if (isset($get['error'])) {
			$this->_isRequestRejected = true;
			switch ($get['error']) {
				case 1:
					$this->_reasonRejected = Helper::displayErrorMessage($get['request'], $get['checkor'], $get['key']);
					break;
				case 2:
					$this->_reasonRejected = Helper::displayErrorMessage("beroNode error: {$get['reason']}");
					break;
				case 3:
					$this->_reasonRejected = Helper::displayErrorMessage("Error downloading file: {$get['reason']}");
					break;
				default:
					$this->_reasonRejected = "Unknown error";
					break;
			}
		}
	}

	/* [PUBLIC METHODS] */
	public function display() {
		$name = "VPN_TITLE_DIS";
		include('./includes/header.php');

		// tabs
		$menu = '';
		$content = '';
		foreach ($this->_tabs as $id => $tab) {
			$menu .= "\t\t\t<li><a href='#tabs-$id'>". constant($tab['title']) ."</a></li>\n";

			$function = $tab['function'];
			$content .= $this->$function($id);
		}

		// errors
		if ($this->_isRequestRejected) {
			$ret .= $this->_reasonRejected;
		}

		$msg = "<div id='vpn_error' class='text-center' style='color:red;font-size:15;margin-top:20px; margin-bottom:-20px;'></div>\n";
		$ret .= HelperHtml::buildTabs('tabs', $msg, $menu, $content);

		return $ret;
	}

	/* [PRIVATE METHODS] */
	private function _displayDownloadClientConfTab($tab) {
		ob_start();
		?>
		<!-- Download Client Conf Tab --!>
		<div id='tabs-<?php echo $tab; ?>'>
			<div class="panel panel-default" style="max-width:600px; margin:auto; margin-top: 20px;">
				<div class="panel-heading text-center lead">
					<?php echo VPN_CLIENT_CONF_DOWNLOAD_DIS ."\n"; ?>
				</div>
				<div class="panel-body text-center">
					<input type='button' class='btn btn-default' value='<?php echo VPN_CLIENT_CONF_DOWNLOAD_BUTTON ?>'
						onclick="window.location.href='misc/files_download.php?option=vpn-client-conf-dl'">
				</div>
			</div>
		</div>
		<?php
		return ob_get_clean() ."\n";
	}

	private function _displayClientSettingsTab($tab) {
		$client = $this->_parameters['client'];
		// build content
		$content['main-form'] = '';
		foreach ($client['data'] as $key => $values) {
			$function = $values['display'];
			$content['main-form'] .= HelperHtml::$function($key, $this->_data['clients'][0][$key], $values, "\t\t\t");
		}
		foreach ($client['btns'] as $key => $btns) {
			$function = $btns['display'];
			$content['main-form'] .= HelperHtml::$function($key, $btns['value'], $btns, "\t\t\t");
		}	
		// build tab
		$form = [
			'action'			=> 'kill-client',
			'has-required'=> false,
			'id' 					=> 'vpn-client',
			'name'				=> 'vpn_client',
			'uri'					=> 'Vpn/vpn_submit.php',
		];
		return HelperHtml::tab($tab, $form, null, $content, null, "\t\t");
	}

	private function _displayServerSettingsTab($tab) {
		$server = $this->_parameters['server'];
		// build content
		$content['main-form'] = "\t\t\t\t<input type='hidden' name='idkey' value='0'>\n"
													.	"\t\t\t\t<input type='hidden' name='isMainVpnExist' value='". (isset($this->_data['servers'][0]) ? '1' : '0') ."'>\n";
		foreach ($server['data'] as $key => $params) {
			$function = $params['display'];
			$content['main-form'] .= HelperHtml::$function($key, $this->_data['servers'][0][$key], $params, "\t\t\t\t");
		}
		foreach ($server['btns'] as $key => $btns) {
			$function = $btns['display'];
			$content['main-form'] .= HelperHtml::$function($key, $btns['value'], $btns, "\t\t\t\t");
		}	
		// build tab
		$form = [
			'action'			=> 'action',
			'has-required'=> true,
			'id'					=> 'vpn-server',
			'name'				=> 'vpn_server',
			'uri'					=> 'Vpn/vpn_submit.php',
		];	
		$javascript =	HelperHtml::validateJavascript($form, array_intersect_key($server['data'], array_flip(array('iprange', 'ipnetmask', 'port'))))
								.	$this->_javascriptServerSettingsTab($tab, $form['id'], $server['msgs']);
		return HelperHtml::tab($tab, $form, $javascript, $content, null, "\t\t");
	}

	/* [JAVASCRIPT CODE] */
	private function _javascriptServerSettingsTab($tab, $idform, $msgs) {
		ob_start();
		?>
		<!-- Settings Tab --!>
		<script type="text/javascript">
			$(document).ready(function () {
				$('.btn.btn-default.action').click(function(evt) {
					var action = $(evt.target).attr('value2');
					if (action == 'delete' && !confirm('<?php echo constant($msgs['confirmDelete']); ?>')) {
						evt.preventDefault();
						return;
					}
					$('#id-action-<?php echo $tab; ?>').val(action);
				});
			});
		</script>
		<?php
		return ob_get_clean();
	}
}
?>
