<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/fallback/beroConf.php');
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/www/berogui/includes/password_func.php');

class GatewaySetPassword extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		if (!isset($this->_parameters['OldPassword']) || empty($this->_parameters['OldPassword'])) {
			$this->_execResultString = 'error:parameter_OldPassword_missing;';
			$this->_execResult = false;
			$this->_execResponseCode = 406;
			return($this->_execResult);
		}

		if (!isset($this->_parameters['NewPassword']) || empty($this->_parameters['NewPassword'])) {
			$this->_execResultString = 'error:parameter_NewPassword_missing;';
			$this->_execResult = false;
			$this->_execResponseCode = 406;
			return($this->_execResult);
		}

		// validate old password against current gui-password
		$ba = new beroAri('/usr/conf/ari.db');
		$res = $ba->select('SELECT password FROM users WHERE user = \'admin\';');
		$oldDbPassword = $ba->fetch_array($res);
		unset($res);

		if (!tep_validate_password($this->_parameters['OldPassword'], $oldDbPassword['password'])) {
			$this->_execResultString = 'error:parameter_OldPassword_does_not_match;';
			$this->_execResult = false;
			$this->_execResponseCode = 406;
			return($this->_execResult);
		}

		// update gui-password
		$ba->update('UPDATE users SET password = \'' . tep_encrypt_password($this->_parameters['NewPassword']) . '\' WHERE user = \'admin\'');

		// update api-password
		$apiUsers = file_get_contents('/usr/conf/apiusers.conf');

		// preserve line of user provisioning
		preg_match('/(.*provisioning:[0-9a-zA-Z\/]*)/', $apiUsers, $matches);
		$provisioningLine = $matches[1];
		unset($matches);

		// create new password for user admin
		$newPasswordEnc = crypt($this->_parameters['NewPassword'], base64_encode($this->_parameters['NewPassword']));

		// write new apiusers.conf
		$apiUsersNew = 'admin:' . $newPasswordEnc . "\n" . $provisioningLine . "\n";
		file_put_contents('/usr/conf/apiusers.conf', $apiUsersNew);

		// update ssh-password
		exec('/usr/local/sbin/pwchange.sh admin ' . $this->_parameters['NewPassword']);

		// if ssh-user was disabled, disable him again
		$bc = new beroConf('root');
		if ($bc->get('root', 'ssh_admin_enable') != '1') {
			exec('/bin/mount -oremount,rw /; /usr/bin/passwd -l admin; sync; /bin/mount -oremount,ro /');
		}

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? 'success' : $this->_execResultString));
	}

}?>