<?php
require_once ("/usr/local/php/include/apiCall.class.php");
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');
include_once("/usr/local/www/berogui/includes/Helper/Helper.php");

class NetworkSetConfiguration extends apiCall {

	function __construct ($get = null, $post = null, $files = null) {
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {
		//sanitisation
		$this->_allowedParameters += array(
			'Dhcp'      	 => 'match',
			'IpAddress'      => 'ip4',
			'NetMask' 		 => 'netmask',
			'GateWay'        => 'ip4',
			'NameServer'     => 'ip4',
			'MtuSize'   	 => 'match',
			'wanDhcp'		 => 'match',
			'wanIpaddr'		 => 'ip4',
			'wanNetmask'	 => 'netmask',
			'wanGateway'	 => 'ip4',
			'lan-mode'		 => 'match',
		);
		$this->_sanitizeOptions = array(
			'MtuSize'	=> "^none$|^(15[0-9]|1[6-9][0-9]|[2-9][0-9]{2}|1[0-4][0-9]{2}|1500)$",
			'Dhcp'		=> "^off$|^on$",
			'wanDhcp'	=> "^off$|^on$",
			'lan-mode'	=> "^lan-wan$|^single$|bonding$"

		);
		if ($this->sanitizeInputs() == false)return $this->_execResult;

		//missing lan manual parameters
		if (!$this->_parameters['Dhcp']||($this->_parameters['Dhcp'] == 'off') && (!isset($this->_parameters['IpAddress']) || !isset($this->_parameters['NetMask']) || !isset($this->_parameters['GateWay']))) {
			$this->_execResultString = 'error:missing_lan_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return ($this->_execResult);
		}
		//wan missing manual parameters
		if ($this->_parameters['wanDhcp'] == "off" && (!isset($this->_parameters['wanIpaddr']) || !isset($this->_parameters['wanNetmask']) || !isset($this->_parameters['wanGateway']))) {
			$this->_execResultString = 'error:missing_wan_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return ($this->_execResult);
		} 

		$bc = new beroConf('root');
		//basic preparation
		foreach (array('lan-dhcp', 'lan-ipaddr', 'lan-netmask', 'lan-gateway', 'lan-mtu', 'lan-nameserver', 'gateway-mode', 'gateway-manual', 'nameserver-mode') as $lanSetting) {
			$bc->delete('root', $lanSetting);
		}
		//set lan mode if set, default single
		if (isset($this->_parameters['lan-mode'])) {
			$bc->set('root', 'lan-mode', sqlite_escape_string($this->_parameters['lan-mode']));
		}
		else $bc->set('root', 'lan-mode','single');


		//configure optional WAN settings
		if (isset($this->_parameters['wanDhcp'])) {

			//wan dhcp on
			if ($this->_parameters['wanDhcp'] == 'on') {
				$bc->set('root', 'wan-dhcp', '1');

			//wan manual
			} else if ($this->_parameters['wanDhcp'] == 'off') {
				$bc->set('root', 'wan-dhcp', '0');
				$bc->set('root', 'wan-ipaddr', sqlite_escape_string($this->_parameters['wanIpaddr']));
				$bc->set('root', 'wan-netmask', sqlite_escape_string($this->_parameters['wanNetmask']));
				$bc->set('root', 'wan-gateway', sqlite_escape_string($this->_parameters['wanGateway']));		
			}
		}
		// configure optional parameter NameServer
		if (isset($this->_parameters['NameServer'])) {
			$bc->set('root', 'lan-nameserver', sqlite_escape_string($this->_parameters['NameServer']));
		}

		// configure optional parameter MtuSize
		if (isset($this->_parameters['MtuSize'])) {
			$bc->set('root', 'lan-mtu', sqlite_escape_string($this->_parameters['MtuSize']));
		}

		// dhcp will be set to on
		if ($this->_parameters['Dhcp'] == 'on') {
			$bc->set('root', 'lan-dhcp', '1');
			$bc->set('root', 'gateway-mode', 'eth0.10');
			$bc->set('root', 'nameserver-mode', 'eth0.10');
			return($this->_execResult);
		}

		// configure network manually
		if(!isset($this->_parameters['Dhcp']) || $this->_parameters['Dhcp'] =='off'){
			$bc->set('root', 'lan-dhcp', '0');
			$bc->set('root', 'lan-ipaddr', sqlite_escape_string($this->_parameters['IpAddress']));
			$bc->set('root', 'lan-netmask', sqlite_escape_string($this->_parameters['NetMask']));
			$bc->set('root', 'lan-gateway', sqlite_escape_string($this->_parameters['GateWay']));
			$bc->set('root', 'gateway-mode', 'manual');
			$bc->set('root', 'nameserver-mode', 'manual');
		}

		return($this->_execResult);
	}

	function display () {

		// reboot to apply changes
		if ($this->_execResult == true) {
			exec('/sbin/reboot');
		}

		return($this->_name . ':' . $this->_execResultString);
	}
}?>
