<?PHP
$m = 'Provisioning';
$berogui_path = "/usr/local/www/berogui";

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include($berogui_path .'/includes/session.php');
unset($newTarget);

/* [INCLUDE] */
include('/usr/fallback/beroConf.php');
include('/usr/php/include/rootHelper.class.php');
include($berogui_path ."/includes/Helper/Helper.php");

$exec = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET);

/* [CHECKING POST REQUEST] */
unset($_POST['m'], $_POST['a'], $_POST['save'], $_POST['submit']);

$list_post = array(
	// general
	'action' => 'select',
	// tab0
	'provisioning_manual' => 'bool',
	'provisioning_mode' => 'select',
	'provisioning_url' => 'url',
	'polling_interval' => 'int>=0',
	'provisioning_useragent' => 'config-option',
	// tab1
);

$list_options = array( 
	'action' => array('delete', 'deleteMd5', 'upload', 'save'),
	'provisioning_mode' => array('off', 'once', 'always'),
);

$_POST = Helper::sanitizePost($_POST, $list_post, $exec, $invalid, $list_options);

/* [EXECUTING SUBMIT] */
if (!$exec) {
	echo "<script>window.location='../../index.php?m=$m&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

$bc = new beroConf('root');

$needActivate = false;
switch ($_POST['action']) {
case 'delete':
	foreach (array('cacert.pem', 'client.crt', 'client.key') as $file) {
		rootHelper::unlink(0, "/usr/conf/tls/$file");
	}
	break;
case 'deleteMd5':
	$bc->delete('root', 'provisioning_config_md5');
	break;
case 'save':
	$needActivate = true;
	$_POST['provisioning_manual'] = 1;
	foreach(array_keys($_POST) as $key) {
		$bc->set('root', $key, sqlite_escape_string($_POST[$key]));
	}
	break;
case 'upload':
	$types = array(
		'upload_ca'  => array('application/x-x509-ca-cert', 'application/x-x509-user-cert', 'application/pkix-cert', 'application/octet-stream', 'application/x-pem-file'),
		'upload_crt' => array('application/x-x509-ca-cert', 'application/x-x509-user-cert', 'application/pkix-cert', 'application/octet-stream'),
		'upload_key' => array('application/x-iwork-keynote-sffkey', 'application/pkcs8', 'application/octet-stream'),
	);
	// upload management
	foreach (array('upload_ca' => 'cacert.pem', 'upload_crt' => 'client.crt', 'upload_key' => 'client.key') as $file => $name) {
		// check file uploaded (error = 4 => file not uploaded. not relevant)
		if (!file_exists($_FILES[$file]['tmp_name']) || $_FILES[$file]['size'] === 0 || $_FILES[$file]['error'] === 4) {
			continue;
		}
		// check file upload error 
		else if ($_FILES[$file]['error'] > 0) {
			echo "<script>window.location='../../index.php?m=$m&error=2&code={$_FILES[$file]['error']}'</script>";
			exit(2);
		}
		// check the file type
		else if (!in_array($_FILES[$file]['type'], $types[$file])) {
			echo "<script>window.location='../../index.php?m=$m&error=3&type=". implode(',', $types[$file]) ."'</script>";
			exit(3);
		}
		rootHelper::copy(0, $_FILES[$file]['tmp_name'], "/usr/conf/tls/$name");
	}
	// check KEY and CRT share same md5
	if (!rootHelper::tlsCheckCertificate()) {
		echo "<script>window.location='../../index.php?m=$m&error=4'</script>";
		exit(4);
	}
	break;
default:
	echo "<script>window.location='../../index.php?m=$m&error=5'</script>";
	exit(5);
}

if ($needActivate) {
	Helper::activate(1, true, $m, ACTIVATE);
}
echo "<script>window.location='../../index.php?m=$m'</script>";
exit(1);
?>
