<?php

include_once("/usr/www/include/SQLite2ToSQLite3.php");
include('/usr/fallback/beroConf.php');
include('/home/admin/lib/php/beroGui.class.php');

function get_userappfs_version () {

	if (file_exists('/pkginfo/VERSION.userappfs')) {
		foreach(file('/pkginfo/VERSION.userappfs') as $line) {
			if (preg_match('/VERSION=([0-9]*)/', $line, $res)) {
				return($res[1]);
			}
		}
	}

	return('unknown');
}

function get_fstab_mount_mode ($mountpoint) {

	foreach (file('/etc/fstab') as $line) {
		if (preg_match('/' . str_replace('/', '\/', $mountpoint) . '/', $line)) {
			if (strstr($line, 'ro,defaults') != false) {
				return(0);
			} else if (strstr($line, 'rw,defaults') != false) {
				return(1);
			}
		}
	}
}

function set_fstab_mount_mode ($mountpoint, $mode) {

	$write = false;

	foreach (file('/etc/fstab') as $line) {
		if (preg_match('/' . str_replace('/', '\/', $mountpoint) . '/', $line)) {
			switch ($mode) {
			default:
			case 'ro':
				if (strstr($line, 'rw,defaults,') != false) {
					$fstab_out .= str_replace('rw,defaults,', 'ro,defaults,', $line);
					$write = true;
				}
				break;
			case 'rw':
				if (strstr($line, 'ro,defaults,') != false) {
					$fstab_out .= str_replace('ro,defaults,', 'rw,defaults,', $line);
					$write = true;
				}
				break;
			}
		} else {
			$fstab_out .= $line;
		}
	}

	if ($write == true) {
		exec('/bin/mount -oremount,rw /');
		$fp = fopen('/etc/fstab', 'w');
		fwrite($fp, $fstab_out);
		fclose($fp);
		exec('/bin/mount -oremount,ro /');
	}
}

function display_developer_options() {

	$ret =  "<br />\n<h2>Developer Options</h2>\n" .
		"<form class=\"extensions_form\" action=\"index.php\" name=\"app_mount_mode\" method=\"POST\">\n" .
		"\t<div style=\"float: right; width: 125px;\">\n" .
		"\t\t<input type=\"hidden\" name=\"app_mount_rw\" value=\"1\" />\n" .
		"\t\t<input type=\"submit\" value=\"Apply\" />\n" .
		"\t</div>\n" .
		"\t<div style=\"margin-left: 5px;float: left; width: 200px; font-weight: bold;\">Mount UserAppFS R/W:</div>\n" .
		"\t<input type=\"checkbox\" name=\"app_mount_rw_perm\" value=\"1\"" . (get_fstab_mount_mode('/home/admin') ? ' checked="checked"' : '') . " />\n" .
		"</form>\n";

	return($ret);
}


function display_userappfs_version () {

	$ret =	"<br />\n" .
		"<div style=\"background-color: transparent; color: grey; float: right; width: 200px; text-align: right; font-size: 10px; margin-right: 40px;\">\n" .
		"\tUserAppFS Version " . get_userappfs_version() . "\n" .
		"</div>\n";

	return($ret);
}

include('/home/admin/lib/php/session.php');

if (isset($_POST['app_mount_rw'])) {
	exec('mount -oremount,rw /home/admin');
	set_fstab_mount_mode('/home/admin', (($_POST['app_mount_rw_perm'] == 1) ? 'rw' : 'ro'));
}

$bg = new beroGUIv2('UserApp Management');

echo	$bg->get_MainHeader(null, null) .
	display_developer_options() .
	display_userappfs_version();
	$bg->get_MainFooter();

?>
