<?php
include('/usr/fallback/beroConf.php');

# redirect to update-tool if boot_fwupdate is set to 1.
$bc = new beroConf('root');
if (file_exists('/tmp/enable_recovery')) {
	$bc->set('root', 'boot_fwupdate', '0');
	header('Location:/');
	exit();
}

if ($bc->get('root', 'boot_fwupdate') == '1') {
	header('Location:/cgi-bin/update-tool.php');
	exit();
}


chdir('..');
include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
$ba = new beroAri();

if ($bc->get('root', 'httpsOnly') == '1' && !isset($_SERVER['HTTPS']) ) {
	header('Location: https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI']);
	exit;
}

require_once("./includes/lang.php");

function convert_to_seconds($input) {
	if (is_numeric($input)) {
		return (float)$input;
	} else {
		// TODO: update the real value blocked
		return 100;
	}
}

function display_reason($reason) {

	if (!isset($reason)) {
		return;
	}

	switch ($reason) {
		case 'cred_empty':
			$line = LOGIN_PASS_USER_EMPTY_DIS;
			break;
		case 'cred_user':
			$line = LOGIN_USER_NOT_EXIST_DIS;
			break;
		case 'cred_pass':
			$line = LOGIN_PASS_FALSE_DIS;
			break;
		case 'blocked':
			$line = LOGIN_BLOCKED_DIS . (string)convert_to_seconds($_GET['time']) . "s";
			break;
		case 'forbidden_request':
			$line = LOGIN_FORBIDDEN_REQUEST_DIS;
			break;
		case 'sess_expd':
			$line = SESSION_EXPIRED;
			break;
	}

	echo $line;
}

if (isset($_GET['destination'])) {
	$reopen = '?destination=' . htmlspecialchars($_GET['destination'], ENT_QUOTES);
}

$version_fw = '';
$file_path = "/usr/local/FILENAME";
if (file_exists($file_path) && preg_match("/^appfs-([0-9]{2}).([0-9]{2,4}).tar.gz$/", file_get_contents($file_path), $version_matched)) {
        $version_fw = $version_matched[1] . $version_matched[2];
} else {
        $version_fw = date("Ymd");
}

?>
<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta http-equiv="cache-control" content="no-cache"/>
		<link rel="icon" href="images/favicon.ico" type="image/x-icon" />
		<link rel="stylesheet" type="text/css" href="css/bootstrap.min.css?<?php echo $version_fw; ?>" />
		<link rel="stylesheet" type="text/css" href="css/template_css.css?<?php echo $version_fw; ?>" />
		<script type="text/javascript" language="javascript" src="js/jquery-1.7.2.min.js?<?php echo $version_fw; ?>"></script>
		<script type="text/javascript" language="javascript" src="js/jquery-validation/jquery.validate.js?<?php echo $version_fw; ?>"></script>
		<script type="text/javascript" src="js/validation_modul.js?<?php echo $version_fw; ?>"></script>
		<title><?php echo ($ba->get('is_sbc_vm') ? LOGIN_TITLE_SBCVM_DIS: LOGIN_TITLE_DIS); ?></title>
		<script>
            function userfocus() {
                var user = document.getElementById('loginUser');
                user.focus();
            }
		</script>
	</head>
	<body onload="userfocus();">

		<div class="container boxed">
			<div class="header" style="margin-top:15px;">
				<div class="img-responsive">
					<a href="http://www.beronet.com" target="_blank" onfocus="if (this.blur()) {
                                this.blur();
                            }">
						<img src="images/beroNet.jpg" alt="beroNet" class="png"/>
					</a>
				</div>
			</div>
			<div>
				<form id="login" action="validate.php<?php echo $reopen; ?>" method="post" autocomplete="off">
					<br/>
					<?php
					display_reason($_GET['reason']);
					?>
					<div class="form-group">
						<label for="user"><?php echo LOGIN_USER_DIS; ?></label>
						<div class="row">
							<div class="col-lg-4">
								<input type="text" class="form-control" name="user" id="loginUser" required="true" size="20" maxlength="20"/>
							</div>
						</div>
					</div>
					<div class="form-group">
						<label for="password"><?php echo LOGIN_PASSWORD_DIS; ?></label>
						<div class="row">
							<div class="col-lg-4">
								<input type="password" class="form-control" id="loginPassword" name="password" size="20" autocomplete="off"/>
							</div>
						</div>
					</div>
					<button type="submit" class="btn btn-default"><?php echo LOGIN_LOGIN_DIS; ?></button>
				</form>
				<script>
                    $("#login").validate();
				</script>
			</div>
			<?php
			$helpPath = "./images/";
			include 'includes/footer.php';
			?>
