#!/bin/bash

## // PARSE ARGUMENTS \\ ##
ACTION=$1
shift

CANCEL=$1
shift

FILES_TO_TAR=$1
shift

FILES_TO_CLEAN=$1
shift

## // INIT \\ ##

RM=$(/usr/bin/which rm)
CAT=$(/usr/bin/which cat)
TAR=$(/usr/bin/which tar)
DATE=$(/usr/bin/which date)
GREP=$(/usr/bin/which grep)
SYNC=$(/usr/bin/which sync)
MKDIR=$(/usr/bin/which mkdir)
RMMOD=$(/usr/bin/which rmmod)
UNAME=$(/usr/bin/which uname)
KILLALL=$(/usr/bin/which killall)

TAR_NAME=/var/log/DebugFiles.tar.gz

if [ "$($UNAME -m)" = "x86_64" ]; then
	## CLOUD SBC parameters
	IS_SBC_VM=1
	ISGW_CONF=/etc/beroNet/isgw/isgw.conf
	FULLTRACE_INFO=/var/log/cloud-sbc/fulltrace-info.txt
else
	## Standard SBC
	IS_SBC_VM=0
	ISGW_CONF=/usr/conf/isgw.conf
	FULLTRACE_INFO=/var/log/fulltrace-info.txt
fi

## // FUNCTIONS \\ ##
function cleanup_log_files
{
	CLEAN=1
	if [ -f $ISGW_CONF ]; then
		if [ $($CAT $ISGW_CONF | $GREP 'keep_fulltrace_files=1') ]; then
			CLEAN=0
		fi
	fi
	if [ "$CLEAN" = "1" ]; then
		$RM -rf $FILES_TO_CLEAN
	fi
}

## // MAIN \\ ##
case $ACTION in
	start)
		/usr/fallback/beroconf delete root trace-state
		$RM -f $TAR_NAME
		cleanup_log_files
		if [ ! "$FILES_TO_TAR" = "0" ]; then
			## on Cloud SBC: create folder to store log files (captures, cloud-sbc)
			for file in "${FILES_TO_TAR[@]}"; do
				$MKDIR -p $file
				chmod uog+w $file
			done
		fi
		;;
	stop)
		## stop processes
		$KILLALL tcpdump.sh
		$KILLALL -9 tcpdump
		if [ "$IS_SBC_VM" = "0" ]; then
			$KILLALL -9 mISDNdebugtool
			$KILLALL -9 analog-debugtool
			$KILLALL -9 gsm-debugtool
			$RMMOD mISDN_debugtool
		fi		
		$SYNC
		## exit on cancel
		if [ "$CANCEL" = "1" ]; then
			cleanup_log_files
			exit 0
		fi
		## generate files
		/usr/local/sbin/generate_info.sh $FULLTRACE_INFO
		if [ "$IS_SBC_VM" = "0" ]; then
			$CAT /tmp/fulltrace-pcap.txt >> $FULLTRACE_INFO
			$CAT /proc/l1_stats > /var/log/l1_stats
			$CAT /proc/l2_stats > /var/log/l2_stats
		fi
		## create tar
		$TAR -czf $TAR_NAME -C /var/log $FILES_TO_TAR
		## clean
		cleanup_log_files
		## update beroconf
		/usr/fallback/beroconf set root trace-state COMPLETED
		;;
	*)
		echo "Usage: $0 [start|stop]"
		;;
esac

$SYNC
exit 0
