<?php
/**
 * @file
 * Modal form für GSM Portgruppen
 */
require_once("/usr/local/www/berogui/includes/Helper/Helper.php");

$load_popup = 1;
$invalid = array();

/* [CHECKING GET REQUEST] */
unset($_GET['start']);	// -> Instead to unset useless variable: TODO: fix the get request from Gsm.php page

$list_get = array('gr' => 'group-name');

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid);

/* [CHECKING POST REQUEST] */
unset($_POST);

/* [DISPLAYING POPUP] */
if (!$load_popup) {
        echo "<script>window.location='../../index.php?m=Gsm&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
        exit(1);
}

chdir("../..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
include("./misc/config_parameter.php");
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once ("./includes/isgwtelnet.php");
require_once ("./includes/Helper/HelperPstn.php");
require_once('/usr/local/www/berogui/includes/session.php');

$group = '"general"';
$query_comp = $ba->select("SELECT * FROM gsm");
while ($entry = $ba->fetch_array($query_comp)) {
	if ($entry['gr'] != $_GET['gr'])
		$group .= ',' . '"' . $entry['gr'] . '"';
}
?>


<script>
    var validator = $("#gsmpop").validate({
        rules: {
            group: {
                required: true,
                checkDigChar: true,
                compareName: [<?php echo $group; ?>]
            },
            'ports[]': {
                atLeastOnePort: true,
            },
	    sms_extension: {
		checkPhoneKeys: true,
	    }, 
	    extension: {
		checkPhoneKeys: true,
	    },
	    addit_options: {
		checkManual: true,
	    } 	
        }
    });

    $(document).ready(function () {
        $('input[name="group"]').focus();
        $('[data-toggle="tooltip"]').tooltip({placement: 'auto bottom', html: true, trigger: 'hover', container: 'body'});
    });

	$('#gsm-tab a').on('hide.bs.tab', function (e) {
			var valid = true;
			var tab=e.target.getAttribute('href');
			$(tab).find("input").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			$(tab).find("select").each(function() {
				if (!validator.element(this) && valid) {
					valid = false;
				}
			});
			if (!valid)
				e.preventDefault();
		});
</script>
	<?php
	$config_values = array();
	if ($ba->get('gui_mode') == 'simple')
		$simple_class = 'simple';
	?>
	<div>

		<!-- Nav tabs -->
		<ul class='nav nav-tabs' role='tablist' id='gsm-tab'>
			<li role='presentation' class='active'><a href='#settings' aria-controls='settings' role='tab' data-toggle='tab'>Settings</a></li>
			<li role='presentation'><a href='#config-string' aria-controls='config-string' role='tab' data-toggle='tab'>More</a></li>
		</ul>

		<form name='gsmpop' id='gsmpop' action='modules/Gsm/gsm_submit.php' method='POST' class='form-horizontal'>
			<div class='tab-content'>
				<div role='tabpanel' class='tab-pane active' id='settings' style='padding-top:15px;'>
					<div class='form-group group' data-toggle='tooltip' title='<?php echo GSM_GROUP_NAME; ?>'>
						<label for='group' class='col-sm-3 control-label'><?php echo PSTN_NAME_DIS; ?></label>
						<div class='col-sm-8'>
							<input name='group' id='group' class='form-control input-sm' type='text' value='<?php echo $_GET['gr']; ?>'>
						</div>
					</div>
					<div class='form-group ports[]'>
						<label for='ports[]' class='col-sm-3 control-label'><?php echo PSTN_PORTS_DIS; ?></label>
						<div class='col-sm-8'>
							<div class='left'>
								<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 0); ?></div>
								<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 0, 'gsm'); ?></div>
							</div>
							<div class='left' style='margin-left:50px;'>
								<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 1); ?></div>
								<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 1, 'gsm'); ?></div>
							</div>
							<?php if (Helper::getType() == 30) { ?>
						<div class='left' style='margin-left:50px;'>
							<div> <?php echo HelperPstn::title($ba, $_GET['gr'], 2); ?></div>
							<div> <?php echo HelperPstn::ports($ba, $_GET['gr'], 2, "gsm"); ?></div>
						</div>
						<?php } ?>
						</div>
					</div>
					<div class='form-group chansel <?php echo $simple_class; ?>' data-toggle='tooltip' title='<?php echo PSTN_CHANSEL; ?>'>
						<label for='chansel' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel', 'gsm', array('standard' => 'standard', 'random' => 'random', 'roundrobin' => 'roundrobin')); ?></div>
						</div>
					</div>
					<div class='form-group chansel_dir <?php echo $simple_class; ?>'>
						<label for='chansel_dir' class='col-sm-3 control-label'><?php echo PSTN_CHANSEL_DIR_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::dropdown($ba, $_GET['gr'], 'chansel_dir', 'gsm', array('ascending' => 'ascending', 'descending' => 'descending')); ?></div>
						</div>
					</div>
					<div class='form-group sms_extension <?php echo $simple_class; ?>'>
						<label for='sms_extension' class='col-sm-3 control-label'><?php echo PSTN_SMS_EXTENSION_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'sms_extension', 'gsm'); ?></div>
						</div>
					</div>
					<div class='form-group extension'>
						<label for='extension' class='col-sm-3 control-label'><?php echo PSTN_EXTENSION_DIS; ?></label>
						<div class='col-sm-8'>
							<div> <?php echo HelperPstn::textfield($ba, $_GET['gr'], 'extension', 'gsm'); ?></div>
						</div>
					</div>
				</div>
			<div role='tabpanel' class='tab-pane' id='config-string' style='padding-top:20px;'>
				<div class="row failover_proxy failover_timeout <?php echo $simple_class; ?>">
					<p class="lead text-center"><?php echo DIALPLAN_OTHER_DIS; ?></p>
				</div>
				<div class='form-group addit_options <?php echo $simple_class; ?>'  data-toggle='tooltip' title='<?php echo ADDIT_OPTIONS; ?>'>
					<label for='addit_options' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DIS; ?></label>
					<div class='col-sm-8'>
						<textarea name='addit_options' id='addit_options' class='form-control' rows='5'></textarea>
					</div>
				</div>
				<div class='form-group addit_options <?php echo $simple_class; ?>'>
					<label for='extra_tooltip' class='col-sm-3 control-label'><?php echo DIALPLAN_ADDITIONAL_CONFIG_DOC_DIS; ?></label>
					<div class='col-sm-8'>
						<p id='extra_tooltip' class='form-control-static' style='height: 170px; overflow: auto; border: 1px solid #A31D26; resize:both;'></p>
					</div>
				</div>
				<div class="clearfix"></div>
			</div>
			<div class='text-center'><i><?php echo REQUIRED_FIELDS; ?></i></div>
			</div>
			<?php
			if (isset($_GET['gr'])) {
				HelperPstn::showdefmc($config_values, 'g', 'gsm');
			} else {
				HelperPstn::show_confadd($config_values, 'g');
			}
			?>
			<br/>
			<input type='hidden' name='gr_upd' value='<?php echo $_GET['gr']; ?>'>
			<div class='text-center'>
				<input name='submit' class='btn btn-default' type='submit' value='<?php echo BUTTON_SAVE; ?>' >
			</div>
		</form>
	</div>
