<?php
	/*
	 *		Modal Popup for Wizard Configuration
	 */

############## INIT #############
unset($_GET);

chdir("../..");
require_once ('./includes/session.php');

include_once("/usr/www/include/SQLite2ToSQLite3.php");
include ("./misc/database.php");
$ba = new beroAri();

include ("./includes/variables.php");
include ("./misc/config_parameter.php");

require_once ('./includes/lang.php');

########### FUNCTIONS  ##############
function get_test_command_value ($cmd)
{
	exec($cmd, $output, $retval);
	return (($retval == 0) ? 1 : 0);
}

function display_internet_connection_message($post, $wizard_cfg)
{
	// error message already displayed and network configuration already updated
	if (isset($wizard_cfg['Network']['lan_mode']) || isset($post['lan_mode']))
	{
		return '';
	}

	//check internet connection
	$dns_on    = get_test_command_value('/bin/grep nameserver /etc/resolv.conf');
	$dns_works = get_test_command_value('/bin/ping -c 1 beronet.com');

	if (!($dns_on && $dns_works))
	{
		return WIZARD_NO_INTERNET_CONNECTION_DIS ."<br/>";
	}

	return '';
}

function get_current_modal_page ($post_data, $wizard_cfg, &$show_skip_button, $bool_previous)
{
	$current_modal = $post_data['settings'];

	// the save network setting is checked: we directly load the 'Scnearios' modal page
	if (strcmp($post_data['settings'], 'Network') == 0 && strcmp($post_data['save_net'], 'true') == 0)
	{
		//if $pbx is given , scenarios page gets skipped and scenario 2 gets chosen
		if (isset($_SESSION['pbx'])) {
			$current_modal = 'Sip';
		} else {
			$current_modal = 'Scenarios';
		}
	}
	// if the PBX scenario is chosen and several module are plugged we reload the PSTN modal page until: 
	//	-> all the modules have been seen (Next button) 
	// 	-> the 'Skip' button is not used
	else if (strcmp($post_data['settings'], 'Scenarios') != 0 && $wizard_cfg['Scenarios']['scenario'] == 2 && (isset($post_data['nb_porttypes']) || isset($wizard_cfg['Pstn']['nb_porttypes'])))
	{
		// in case where the user start with a PBX scenario, go backward and choose another scenario
		if (isset($post_data['scenario']))
		{
			return $post_data['settings'];
		}
		// in case where the user click on previous and never started to configure a module
		else if ($bool_previous && !(isset($wizard_cfg['Pstn'])))
		{
			return $post_data['settings'];
		}

		$count_port_types_cfgd = count(array_filter(explode('-', $wizard_cfg['Pstn']['port_types'])));

		// the skip button is used
		if (strcmp($post_data['settings'], 'Skip') == 0)
		{
			$current_modal = 'Activate';
		}
		// the previous button is used for all the modules
		else if ($bool_previous && isset($wizard_cfg['Pstn']) && $count_port_types_cfgd > 0)
		{
			$current_modal    = 'Pstn';
			$show_skip_button = ($count_port_types_cfgd > 1 ? true : false);
		}
		else if ($bool_previous && isset($wizard_cfg['Pstn']) && $count_port_types_cfgd == 0)
		{
			$current_modal = 'Sip';
		}
		// we navigate on the different PSTN pages
		else if (!(isset($wizard_cfg['Pstn'])) || isset($wizard_cfg['Pstn']) && $count_port_types_cfgd < ($wizard_cfg['Pstn']['nb_porttypes'] - 1))
		{
			$current_modal    = 'Pstn';
			$show_skip_button = (isset($post_data['nb_porttypes']) ? true : false);
		}
	}

	return $current_modal;
}

function get_post_requirement($previous_modal, $post, $wizard_cfg, $scenario = 1)
{
	$keeping_post = array('save_net' => 'bool', 'save_acl' => 'bool', 'save_provisioning' => 'bool', 'save_cloud' => 'bool', 'save_prefix' => 'bool');
	if (isset($_SESSION['pbx'])) {
		$scenario = 2;
	}
	$path = '/usr/local/www/berogui/modules/Wizard';

	switch ($previous_modal) {
		case 'Configuration':
			return array('post' => $keeping_post, 'options' => array());
		case 'Network':
			require_once("$path/network_wizard_popup.php");
			$networkWizard = new NetworkWizard();
			$conditions = $networkWizard -> get_post_conditions_list();
			return array('post' => array_merge($keeping_post, $conditions['post']), 'options' => $conditions['options']);	
		case 'Pstn':
			require_once("$path/pstn_wizard_popup.php");
			$pstnWizard = new PstnWizard();

			$conditions = $pstnWizard -> get_post_conditions_list($scenario, $post, $wizard_cfg);

			$general = array(
					 'post'    => array('nb_porttypes' => 'int>=0'),
					 'options' => array()
					);

			return array('post' => array_merge($general['post'], $conditions['post']), 'options' => array_merge($general['options'], $conditions['options']));
		case 'Scenarios':
			require_once("$path/scenarios_wizard_popup.php");
			$scenariosWizard = new ScenariosWizard();
			$conditions = $scenariosWizard -> get_post_conditions_list();
			return array('post' => array_merge($keeping_post, $conditions['post']), 'options' => $conditions['options']);	
		case 'Sip':
			require_once("$path/sip_wizard_popup.php");
			$sipWizard = new SipWizard();
			return $sipWizard -> get_post_conditions_list();
		default:
			return array('post' => array('ERROR' => 'ERROR'), 'options' => array());
	}
}

function get_previous_modal_page ($post_data, $current_modal, $wizard_cfg)
{
	if (isset($post_data['nb_porttypes'])) {
		return 'Pstn';
	}

	return $current_modal['previous'];
}

// Main displaying functions 
function display_modal_windows ($name, $title, $content, $nextmodal, $save_net, $error_message, $show_skip_button, $allow_continue)
{
	ob_start();
?>
<p class='text-center h3' style='margin-top: 0px;'><?php echo $title; ?></p>
<form class='form-horizontal' method='POST' style='margin-top: 10px;' name='<?php echo $name; ?>' id='<?php echo $name; ?>form'>
	<input type='hidden' name='settings' value='<?php echo $nextmodal; ?>'>
<?php 	echo (strlen($error_message) == 0 ? '' : "<div style='text-align: center; color: red;'>". $error_message ."</div>"); ?>
	<div class='tab-content' style='border-top: 1px solid #ddd;'>
		<div role='tabpanel' class='tab-pane active' id='id<?php echo $name; ?>'>
<?php echo $content; ?>
		</div>
	</div>
</form>
<?php 
	$required_line = "<div class='text-center' style='margin: 10px;'><i>". REQUIRED_FIELDS ."</i></div>\n";
	if (strcmp($name, 'Scenarios') == 0)
	{
		$required_line = "<br/>\n";
	}
	else if (strcmp($name, 'Activate') == 0)
	{
		$required_line = "<div class='text-center' style='margin: 10px; color: red;'><i>". WIZARD_ACTIVATE_WARNING_DIS ."</i></div>\n";
	}

	return 	  ob_get_clean()
		. $required_line
		. display_bottom_buttons($name, $save_net, $error_message, $show_skip_button, $allow_continue);
}

function display_general_javascript_code ($oldpage, $currentpage, $scenario, $extra_code, $show_skip_button)
{
	ob_start();
?>
<script type="text/javascript">
<?php
	if (strcmp($currentpage, 'Activate') == 0)
	{
?>
	function activateWizard ()
	{
		session();

		var confirmMe = confirm('<?php echo WIZARD_ACTIVATE_CONFIRME_DIS; ?>');
		if (confirmMe)
		{
			window.location.href = "/app/berogui/modules/RebootReset/recreate_sbc.php?wizard=1";	
		}
	}
<?php
	}
	else
	{
?>	
	function goToNextSettings ()
	{
		session();

		var checkForm = $("#<?php echo $currentpage; ?>form").validate({}).form();

		if (checkForm == true)
		{
<?php echo $extra_code; ?>
			$.ajax({
				type: 'POST',
				url: 'modules/Wizard/wizard_popup.php',
				data: $("#<?php echo $currentpage; ?>form").serialize(),
				success: function (loadedData) {
        	 			$('.modal-body').html(loadedData);
				},
				failure: function (errMsg) {
					alert(errMsg);
				}
			});
		}
	}
<?php
	}
?>
	function goToPreviousSettings ()
	{
		session();

		$.ajax({
			type: 'POST',
			url: 'modules/Wizard/wizard_popup.php',
			data: {settings: '<?php echo $oldpage ?>', previous: 1},
			success: function (loadedData) {
               			$('.modal-body').html(loadedData);
			},
			failure: function (errMsg) {
				alert(errMsg);
			}
		});
	}

<?php 	if ($show_skip_button)
	{ 	?>
	function goToActivateSettings ()
	{
		session();
		
		$.ajax({
			type: 'POST',
			url: 'modules/Wizard/wizard_popup.php',
			data: {settings: 'Skip'},
			success: function (loadedData) {
               			$('.modal-body').html(loadedData);
			},
			failure: function (errMsg) {
				alert(errMsg);
			}
		});
	}

<?php	} 	?>

	$(document).ready(
		function () 
		{
			$('[data-toggle="tooltip"]').tooltip({placement: 'auto bottom', html: true, trigger: 'hover', contenter: 'body'});
		}
	);
</script>
<?php
	return ob_get_clean() . "\n";
}

function display_bottom_buttons ($current_modal, $save_net, $error_message, $show_skip_button, $allow_continue)
{
	// Next/Activate button managment
	$next_button 	= BUTTON_NEXT;
	$onclick_next 	= 'onclick="goToNextSettings();"';
	if (strcmp($current_modal, 'Activate') == 0)
	{
		$next_button	= BUTTON_ACTIVATE;
		$onclick_next	= 'onclick="activateWizard();"';
	}

	// Previous button managment
	$previous_button = "\t<a role='button' class='btn btn-default' style='margin-right: 4px;' onclick=\"goToPreviousSettings();\">". BUTTON_PREVIOUS ."</a>\n";
	if (strcmp($current_modal, 'Network') == 0 || (strcmp($current_modal, 'Scenarios') == 0 && $save_net))
	{
		$previous_button = '';
	}	

	// Skip button managment
	$skip_button = "";
	if ($show_skip_button && $load_popup)
	{
		$skip_button = "<a role='button' class='btn btn-default' style='margin-right: 4px;' onclick=\"goToActivateSettings();\">". BUTTON_SKIP ."</a>\n";;
	}

	$html_str = 	  "<div class='text-center'>\n"
			. $previous_button
			. "\t<a role='button' data-remote='false' data-toggle='modal' data-target='#reset-popup' class='btn btn-default' style='margin-right: 4px;'>". BUTTON_CANCEL ."</a>\n"
			. ($allow_continue ? "\t<a role='button' class='btn btn-default' style='margin-right: 4px;' $onclick_next>$next_button</a>\n" : '')
			. $skip_button
			. "</div>\n\n";

	return $html_str;
}

function update_save_wizard_cfg($bool_previous, $save_setting, $configuration, $newparameters, $filename)
{
	// clear post data from pstn configuration 
	if (!($bool_previous) && strcmp($save_setting, 'Pstn') == 0)
	{
		// PBX Scenario
		if ($configuration['Scenarios']['scenario'] == 2)
		{
			// get port types
			$configuration[$save_setting]['port_types'] = (isset($configuration[$save_setting]['port_types']) ? $configuration[$save_setting]['port_types'] ."-" : '') . $newparameters['port_types'];

			// clear port type (not necessay -> security)
			$configuration[$save_setting]['port_types'] = array_unique(explode('-', $configuration[$save_setting]['port_types']));

			// save the hidden parameters for PBX scenario
			if (isset($newparameters['nb_porttypes']))
			{
				$configuration[$save_setting]['nb_porttypes'] = $newparameters['nb_porttypes'];
			}
		}
		// others Scenarios
		else
		{
			$configuration[$save_setting] = array();
			$configuration[$save_setting]['port_types'] = array($newparameters['port_types']);
		}

		foreach ($newparameters as $parameter => $value)
		{
                       	if (preg_match("/{$newparameters['port_types']}_[a-z0-9]*/", $parameter) || preg_match("/intern_{$newparameters['port_types']}_[0-9a-z_]*/", $parameter))
                       	{
                       	        if (is_array($value))
                       	        {
                       	                $configuration[$save_setting][$parameter] = implode('-', $value);
                       	        }
                       	        else if (strlen($value) > 0)
                       	        {
                       	                $configuration[$save_setting][$parameter] = str_replace("[", "", str_replace("]", "", $value));
                       	        }
                       	}
		}
	}
	// clear post data for other scenarios
	else if (!($bool_previous))
	{
		foreach ($newparameters as $parameter => $value)
		{
			if (strlen($value) > 0)
			{
				$configuration[$save_setting][$parameter] = $value;
			}
		}
	}

	// Save data
	$wizard_str = '';
	foreach ($configuration as $settings => $parameters)
	{
		$wizard_str .= '['. $settings ."]\n";
		foreach ($parameters as $parameter => $value)
		{
			if (is_array($value))
			{
				$wizard_str .= $parameter ."=". implode('-', $value) ."\n";
			} 
			else 
			{
				$wizard_str .= "$parameter=". $value ."\n";
			}
		}
		$wizard_str .= "\n";
	}

	$fp = fopen($filename, "w+");
	fputs($fp, html_entity_decode($wizard_str));
	fclose($fp);

	return $configuration;
}

########## MAIN MODAL POPUP SECTION #############
// init general variables
$previous_modal   = '';
$current_modal 	  = '';
$next_modal 	  = '';

$title_modal 	  = '';
$content_modal	  = '';

$javascript 	  = '';
$check_form  	  = '';

$flow_settings = array(	'Network' 	=> array( 'previous' => 'Configuration'	, 'next' => 'Scenarios'	, 'title' => WIZARD_NETWORK_SETTINGS_DIS  ),
			'Scenarios' 	=> array( 'previous' => 'Network'	, 'next' => 'Sip'	, 'title' => WIZARD_SCENARIOS_SETTINGS_DIS),
			'Sip' 		=> array( 'previous' => 'Scenarios' 	, 'next' => 'Pstn'	, 'title' => WIZARD_SIP_SETTINGS_DIS	  ),
			'Pstn'		=> array( 'previous' => 'Sip'		, 'next' => 'Activate'	, 'title' => WIZARD_PSTN_SETTINGS_DIS	  ),
			'Activate'	=> array( 'previous' => 'Pstn'		, 'next' => ''		, 'title' => WIZARD_ACTIVATE_SETTINGS_DIS ));	

$wizard_cfg = array();
$filename   = '/tmp/wizard.conf';

$previous_used = false;
if (isset($_POST['previous']))
{
	$previous_used = true;
	unset($_POST['previous']);
}

$show_skip_button = false;

################## MODAL WINDOWS ###############

// load configuration file
if (file_exists($filename) && !(isset($_POST['init'])))
{
	$wizard_cfg = parse_ini_file($filename, true);
}
unset($_POST['init']);

// check internet connection
$error_message = display_internet_connection_message($_POST, $wizard_cfg);

// check and get settings parameter
if (isset($_POST['settings']) && Helper::checkInputData('select', $_POST['settings'], array_merge(array_keys($flow_settings), array('Skip'))))
{
	// update current modal page
	if (strlen($error_message) == 0)
	{
		$current_modal = get_current_modal_page($_POST, $wizard_cfg, $show_skip_button, $previous_used);
	}
	else
	{
		$current_modal = 'Network';
		unset($_POST['save_net']);
	}

	$previous_modal = get_previous_modal_page($_POST, $flow_settings[$current_modal], $wizard_cfg);

	$title_modal 	= $flow_settings[$current_modal]['title'];
	$next_modal 	= $flow_settings[$current_modal]['next'];

	unset($_POST['settings']);
}

// check parameters coming from the POST request 
$list_post = get_post_requirement($previous_modal, $_POST, $wizard_cfg, $wizard_cfg['Scenarios']['scenario']);

$load_popup = 1;
$invalid = array();
$_POST = Helper::sanitizePost($_POST, $list_post['post'], $load_popup, $invalid, $list_post['options']);

//echo "<pre>"; print_r($invalid); print_r($_POST); print_r($list_post); echo "</pre>";

if (!$load_popup)
{
	$error_message .= Helper::displayErrorMessage($invalid['request'], $invalid['checkor'], $invalid['key']);
}

// update and save the configurations
$wizard_cfg = update_save_wizard_cfg($previous_used, $previous_modal, $wizard_cfg, $_POST, $filename);

// update network saving boolean to show the right buttons
$save_net = false;
if (isset($wizard_cfg['Network']['save_net']))
{
	$save_net = true;
}

/* NETWORK - set Network Settings popup */
if (strcmp($current_modal, 'Network') == 0)
{
	$bc = new beroConf('root');
	if (!($bc -> valid()))
	{
		$error_message .= WIZARD_ERROR_DATABASE_DIS . "<br/>";
	}

	require_once('./modules/Wizard/network_wizard_popup.php');	
	$networkWizard = new NetworkWizard();

	$content_modal = $networkWizard -> get_content_modal($bc, isset($wizard_cfg['Network']) ? $wizard_cfg['Network'] : array());

	$javascript = $networkWizard -> get_general_javascript_code();
	$check_form = $networkWizard -> get_unique_form_javascript_code();
}

/* SCENARIOS - Set the VoIP Scenarios */
else if (strcmp($current_modal, 'Scenarios') == 0)
{
	require_once('./modules/Wizard/scenarios_wizard_popup.php');
	$scenariosWizard = new ScenariosWizard();

	$content_modal = $scenariosWizard -> get_content_modal(isset($wizard_cfg['Scenarios']) ? $wizard_cfg['Scenarios'] : array());
}

/* SIP_SECTION - set Sip Settings popup */
else if (strcmp($current_modal, 'Sip') == 0)
{
	require_once('./modules/Wizard/sip_wizard_popup.php');
	$sipWizard = new SipWizard($wizard_cfg['Scenarios']['scenario']);

	$content_modal = $sipWizard -> get_content_modal(isset($wizard_cfg['Sip']) ? $wizard_cfg['Sip'] : array(), $title_modal);

	$javascript = $sipWizard -> get_general_javascript_code($current_modal . 'form');
	$check_form = $sipWizard -> get_unique_form_javascript_code();
}

/* PSTN_SECTION - set PTSN Settings popup */
else if (strcmp($current_modal, 'Pstn') == 0)
{
	require_once('./modules/Wizard/pstn_wizard_popup.php');
	$pstnWizard = new PstnWizard($wizard_cfg['Scenarios']['scenario']);

	$content_modal = $pstnWizard -> get_content_modal(isset($wizard_cfg['Pstn']) ? $wizard_cfg['Pstn'] : array(), $previous_used);

	if ($wizard_cfg['Scenarios']['scenario'] == 2 && $previous_used)
	{
		// previous used: he have displayed the last port type configured and we update and save the wizard
		$wizard_cfg['Pstn']['port_types'] = explode('-', $wizard_cfg['Pstn']['port_types']);
		array_pop($wizard_cfg['Pstn']['port_types']);
		$wizard_cfg['Pstn']['port_types'] = implode('-', $wizard_cfg['Pstn']['port_types']);

		$wizard_cfg = update_save_wizard_cfg($previous_used, $previous_modal, $wizard_cfg, $_POST, $filename);
	}

	$javascript = $pstnWizard -> get_general_javascript_code($current_modal . 'form');
	$check_form = $pstnWizard -> get_extra_check_form_javascript_code();
}

/* ACTIVATE - Activate the Settings */
else if (strcmp($current_modal, 'Activate') == 0)
{
	require_once('./modules/Wizard/activate_wizard_popup.php');
	$activateWizard = new ActivateWizard($wizard_cfg);

	$content_modal = $activateWizard -> get_modal_content();
}

/* Wrong URL */
else 
{
	echo 'Wrong URL';
	return 0;
}

// display the modal content
$html_str .=	  display_general_javascript_code($previous_modal, $current_modal, $wizard_cfg['Scenarios']['scenario'], $check_form, $show_skip_button)
		. display_modal_windows($current_modal, strtoupper($title_modal), $content_modal, $next_modal, $save_net, $error_message, $show_skip_button, $load_popup)
		. $javascript;

echo $html_str;

return 1;
?>
