<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/php/include/shortMessageService.Class.php');

class TelnetToIsgw extends apiCall {
	private $_sms;

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
		$this->_sms = new ShortMessageService();
	}

	function execute () {
		if (!isset($this->_parameters['cmd']) || empty($this->_parameters['cmd'])) {
			$this->_execResult = false;
			$this->_execResponseCode = 400;
			$this->_execResultString = 'error: invalid request';
			return $this->_execResult;
		}
		require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
		$isgw = new isgwtelnet();
		if (!$isgw->isgw_login()) {
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			$this->_execResultString = 'error: could not login to ISGW';
			return $this->_execResult;
		}
		$this->_execResultString = nl2br($isgw->command($this->_parameters['cmd']));
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>