<?php
/*
 * beroNet VoIP Gateway API
 *
 * Copyright (C) 2016 beroNet GmbH
 * Developer: Florian Kraatz <fk@beronet.com>
 *
 * If you experience problems with this component, please contact our support-team <support@beronet.com>
 */

// this is needed to check if api has been disabled
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');

define("TESTAPIMODE", "0");
define("APIPATH", "/usr/local/php/api/");

// generic table-display-function
function apiDisplayTable ($tableHead, $tableRows, $headSpan = null, $displayBack = null) {

	$table  =	'<table class="contenttoc" style="margin-top: 20px; margin-bottom: 20px; width: 50% !important;">' . "\n" .
			'<tr><th' . (($headSpan != null) ? ' colspan="' . $headSpan . '"': '') . '>' . $tableHead . '</th></tr>' . "\n" .
			$tableRows .
			(($displayBack != null) ? '<tr><td><input type="button" name="backButton" value="Overview" onclick="location.href=\'/app/api/api.php\'" /></td></tr>' . "\n" : '') .
			'</table>' . "\n";

	return($table);
}

// display overview of api-calls
function apiCallOverview () {

	$tableHeadline = 'Available Commands';
	$apiFunctions = scandir(APIPATH);

	// remove virtual directories
	foreach (array('.', '..') as $virtDirectory) {
		if (($index = array_search($virtDirectory, $apiFunctions)) !== false) {
			unset($apiFunctions[$index]);
		}
	}
	//hide cbm functions
	if ((file_exists ("/usr/conf/isgw.conf") && strpos (file_get_contents ("/usr/conf/isgw.conf"), "gsm_cbm_enable=1") != true) || $TESTAPIMODE == 1) {
		foreach (array('CbmGetMessage', 'CbmDeleteMessage', 'CbmListMessages') as $hiddenDirectory) {
			if (($index = array_search($hiddenDirectory, $apiFunctions)) !== false) {
				unset($apiFunctions[$index]);
			}
		}
	}

	if (empty($apiFunctions)) {
		return(apiDisplayTable($tableHeadline, '<tr><td>No API-Commands available!</td></tr>' . "\n"));
	}

	foreach ($apiFunctions as $apiFunction) {
		if (file_exists(APIPATH . $apiFunction . '/DISABLED')) {
			continue;
		}

		$apiInfo = file_get_contents(APIPATH . $apiFunction . '/info.txt');
		$tableRows .=	'<tr style="height: 45px;">' . "\n" .
				'<td style="width: 35%;">' .
				'<a href="?apiCommand=displayInfo&apiCall=' . $apiFunction . '"><b>' . $apiFunction . '</b></a>' .
				'</td>' . "\n" .
				'<td style="text-align:left !important;">' . $apiInfo . '</td>' . "\n" .
				'</tr>' . "\n";
	}

	return(apiDisplayTable($tableHeadline, $tableRows, 2));
}

// display description and example of an api-call
function apiCallInfo ($apiCallName) {

	$basePath = APIPATH . $apiCallName;

	if (!isset($apiCallName) || (empty($apiCallName)) || !file_exists($basePath . '/description.txt') || file_exists($basePath . '/DISABLED')) {
		return(apiDisplayTable($apiCallName, '<tr><td>This API-call does not exist or is disabled.</td></tr>' . "\n", null, true));
	}

	$lines = file(APIPATH . $apiCallName . '/description.txt');
	foreach($lines as $line) {
		$tmp = explode("=>", $line);
		$description[$tmp[0]] = trim($tmp[1]);
		unset($tmp);
	}

	$apiUrl = 'http://' . $_SERVER['HTTP_HOST'] . '/app/api/api.php?apiCommand=' . $apiCallName;

	$tableRows =	'<tr><td style="text-align: left;">' . $description['helptext'] . '</td></tr>' . "\n" .
			'<tr><td style="text-align: left;">Usage' . "\n" .
			'<ul style="padding: 5px 15px;">' . "\n" .
			'<li style="margin-left: 10px;">apiCommand = ' . $apiCallName . '</li>' . "\n";
	if (strlen($description['usage']) > 0) {
		foreach (explode(',', $description['usage']) as $value) {
				$tableRows .= '<li style="margin-left: 10px;">' . $value . '</li>' . "\n";
		}
	}
	$tableRows .=	'</ul>' . "\n" .
			'</td></tr>' . "\n" .
			'<tr><td style="text-align: left;">Examples' . "\n" .
			'<ul style="padding: 5px 15px;">' . "\n";
	foreach (explode(',', $description['example']) as $value) {
		$tableRows .= '<li style="margin-left: 10px;"><a href="' . $apiUrl . $value . '">' . $apiUrl . $value . '</a></li>' . "\n";
	}
	$tableRows .=	'</ul>' . "\n" .
			'</td></tr>' . "\n" .
			'<tr><td style="text-align: left;">Return Values' . "\n" .
			'<ul style="padding: 5px 15px;">' . "\n";
	foreach (explode(',', $description['return']) as $value) {
		$tableRows .= '<li style="margin-left: 10px;">' . $apiCallName . ':' . $value . '</li>' . "\n";
	}
	$tableRows .=	'</ul>' . "\n" .
			'</td></tr>' . "\n";

	return(apiDisplayTable($apiCallName, $tableRows, null, true));
}

if (TESTAPIMODE != 1) {
	// if api is disabled, return 403
	$bc = new beroConf('root');
	if ($bc->get('root', 'api_disable') == '1') {
		header($_SERVER['SERVER_PROTOCOL'] . ' 403 Forbidden');
		exit(0);
	}
	unset($bc);
}
$apiCommand = isset($_POST['apiCommand']) ? $_POST['apiCommand'] : (isset($_GET['apiCommand']) ? $_GET['apiCommand'] : 'displayOverview');

// display info or overview
switch ($apiCommand) {
default:
	// TESTAPIFLAG1 -- DO NOT REMOVE THIS LINE
	// we check if this command exists and return 404 if not.
	if (!file_exists(APIPATH . $apiCommand . '/'.$apiCommand.'.class.php') || file_exists(APIPATH . $cmd . '/DISABLED')) {
		header($_SERVER['SERVER_PROTOCOL'] . ' 404 Not Found');
		exit(0);
	}

	// run apiCommand and display result
	require_once('/usr/local/php/api/' . $apiCommand . '/'.$apiCommand.'.class.php');
	$api = new $apiCommand($_GET, $_POST, $_FILES);
	$api->execute();

	// we only set http-response-code if this is supported by api-call
	if ($api->responsecode() != false) {
		header($_SERVER['SERVER_PROTOCOL'] . ' ' . $api->responsecode());
	}

	// now we display output
	echo $api->display();
	exit(0);
case 'displayOverview':
	$head = 'Overview';
	$table = apiCallOverview();
	break;
case 'displayInfo':
	$head = $_GET['apiCall'];
	$table = apiCallInfo($_GET['apiCall']);
	break;
}

// update year shown
$version_file = "/usr/local/VERSION";

 // default value
$year = "2025";

 //update year 
$import_year = @file_get_contents($version_file);
preg_match("/YEAR=([0-9]*)/", $import_year, $output_year);

if (isset($output_year[1])) {
	$year = $output_year[1];
}
else {  
	// get year from server
	exec("/bin/cat /usr/conf/misc.conf | /bin/grep ntphost | /usr/bin/cut -d '=' -f 2", $ntphost);
	if (isset($ntphost[0]) && strlen($ntphost[0]) > 0) {
		exec("/bin/ping -c 1 $ntphost[0]", $output, $retval);
		$dns_works = (($retval == 0) ? 1 : 0);
                                        
		if ($dns_works) {
			system("/usr/local/bin/rdate -ns $ntphost[0]");
			$year = date('Y');
		}
	}
}

// display html
echo	'<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 Transitional//EN" ' . "\n" .
	'	"http://www.w3.org/TR/xhtml11/DTD/xhtml11-transitional.dtd">' . "\n" .
	'<html xmlns="http://www.w3.org/1999/xhtml">' ."\n" .
	'<head>' . "\n" .
	'<link rel="stylesheet" type="text/css" href="/app/berogui/includes/template_css.css" />' . "\n" .
	'<link rel="icon" href="/app/berogui/includes/images/favicon.ico" type="image/x-icon">' . "\n" .
	'<title>beroNet VoIP Gateway API: ' . $head . '</title>' . "\n" .
	'</head>' . "\n" .
	'<body>' . "\n" .
	'<div class="container" id="page">' . "\n" .
	'<div id="header" style="padding-bottom: 15px;">' . "\n" .
	'<div id="logo"><a href="http://www.beronet.com/" target="_blank" onfocus="if (this.blur()) { this.blur(); }">' .
	'<img src="/app/berogui/includes/images/beroNet.jpg" alt="beroNet" class="png" /></a></div>' . "\n" .
	'<div style="display: inline-block; font-size: 18pt; color: #918e8c;">beroNet VoIP Gateway API: ' . $head . '</div>' . 
	'<input type="button" name="backButton" value="back to beroGUI" style="float:right" onclick="location.href=\'/app/berogui/\'">' . "\n" .
	'</div>' . "\n" .
	$table .
	'<div id="footer" class="clear">' . "\n" .
	'<div class="part1">Copyright &copy; '.$year.' beroNet GmbH, Germany</div>' . "\n" .
	'</div>' . "\n" .
	'</body>' . "\n" .
	'</html>';

?>
