<?php
/**
 * implementiert die Informationsseite über Netzwerk, Versionen, Datum, Uptime und Line Interfaces
 * @author Miguel Palmer <mp@beronet.com>
 */

class Info {

	private $_is_sbc_vm = false;

 /**
 	* Constructor
 	*/
  function __construct($m, $get = array(), $post = array(), $session = array()) {
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Inhalt
	 */
	public function display() {
		// default
		$display_by_type = array(
			'0' => '_displaySbcInfo',
			'1' => '_displaySbcvmInfo'
		);

		// init
    $name = "INFO_TITLE_DIS";
		include('./includes/header.php');

    include('/usr/fallback/beroConf.php');
    $bc = new beroConf('root');

		include_once('./misc/database.php');
		$ba = new beroAri();

		// get type
		$this->_is_sbc_vm = $ba->get('is_sbc_vm') ? '1' : '0';

		// load info
		$info = Helper::getInfo($bc, $ba, null, $this->_is_sbc_vm);

		// display the info
		$method = $display_by_type[$this->_is_sbc_vm];
		$ret .= $this->$method($info);
		return $ret;
	}

	/* [PRIVATE METHOD] */
	private function _displayNetworkTable($ifaces, $provided = array(), $vpn_client = array()) {
		// rows title conversion
		$rows_title = array(
			'macaddr'	=> INFO_MAC_ADDRESS_DIS,
			'ipaddr'	=> INFO_IP_ADDRESS_DIS,
			'netmask'	=> INFO_NETMASK_DIS,
		);

		$rows_provided = array(
			'0' 			=> NETWORK_PRIMARY_NAME_SERVER_DIS,
			'1' 			=> NETWORK_SECONDARY_NAME_SERVER_DIS,
			'gateway'	=> INFO_GATEWAY_DIS,
		);

		// build table
		if (!empty($ifaces)) {
			$table =	"<table class='table table-striped table-bordered' style='width:36% !important; margin:auto; margin-bottom: 25px;'>\n"
				      . "\t<tr><th colspan='2'>".INFO_NET_CONFIGURATION_DIS."</th></tr>\n";

			foreach (array_keys($ifaces) as $iface) {
				$table .=	  "\t<tr></tr>\n"
					        . "\t<tr><th colspan='2'>". strtoupper($iface) ."</th></tr>\n";
				foreach($ifaces[$iface] as $param => $value) {
					$table .= "\t<tr><td nowrap>{$rows_title[$param]}</td><td>$value</td></tr>\n";
				}
			}
		}

		$is_gateway = isset($provided['gateway']) && strlen($provided['gateway']) > 0;
		$is_nameserver = isset($provided['nameserver']) && !empty($provided['nameserver']);

		if ($is_gateway || $is_nameserver) {
			$table .= "\t<tr><th colspan='2'>".INFO_NET_PROVIDED_DIS."</th></tr>\n"
						. ($is_gateway ? "\t<tr><td nowrap>{$rows_provided['gateway']}</td><td>{$provided['gateway']}</td></tr>\n" : '');
			if ($is_nameserver) {
				foreach ($provided['nameserver'] as $id => $value) {
					$table .= "\t<tr><td>{$rows_provided[$id]}</td><td>$value</td></tr>\n";
				}
			}
		}

		if (!empty($vpn_client)) {
			$rows_vpn = array(
				'virtIpaddr' 			=> VPN_DATA_VIRTIPADDR_DIS, 
				'realIpaddr' 			=> VPN_DATA_REALIPADDR_DIS,
				'connectedSince'	=> VPN_DATA_CONNECTEDSINCE_DIS,
			);
			$table .= "\t<tr><th colspan='2'>". INFO_NET_VPNCLIENT_DIS ."</th></tr>\n";
			foreach ($rows_vpn as $key => $title) {
				$table .= "\t<tr><td>$title</td><td>{$vpn_client[0][$key]}</td></tr>\n";
			}
		}

		// return table
		$table .= "</table>\n";
		return $table;
	}

	private function _displayInfoTable($name, $rows, $two_columns = false) {
		$table = "<table class='table table-striped table-bordered' style='width:36% !important; margin:auto; margin-bottom: 25px;'>\n";

		// display two columns
		if ($two_columns) {
			$table .= "\t<tr><th colspan='2'>$name</th></tr>\n";
			foreach ($rows as $key_column => $value_column) {
				$table .= "\t<tr><td>$key_column</td><td>$value_column</td></tr>\n";
			}
		}
		// display one column
		else {
			$table .=	"\t<tr><th>$name</th></tr>\n"
							. "\t<tr><td nowrap>$rows</td></tr>\n";
		}

		$table .= "</table>\n";
		return $table;
	}

	private function _displaySbcInfo($info) {
		// serial
		$html = $this->_displayInfoTable(INFO_SERIAL_NUMBER_DIS, $info['serial']);

		// versions
		$versions = array(
			'appfs' 		=> $info['appfs'],
			'rootfs'		=> $info['rootfs'],
			'mtdblock'		=> $info['mtdblock'],
			'FPGA'			=> $info['fpga'],
			'MSP'			=> $info['msp_fw'],
			INFO_HW_REVISION_DIS	=> $info['hw_revision'],
			'OpenSSL'	=> $info['openssl'],
			'PHP'			=> $info['php'],
		);
		$html .= $this->_displayInfoTable(INFO_VERSIONS_DIS, $versions, true);

		// Netzwerkkonfiguration
		$html .= $this->_displayNetworkTable($info['network']['iface'], $info['network']['provided']);

		// Sip License
		$html .= $this->_displaySipLicenseTable($info, 0);

		// date
		$html .= $this->_displayInfoTable(INFO_DATE_TIME_DIS, $info['date']);

		//Anzeige der installierten LI Module
		if (!empty($info['lif'])) {
			$html .=  "<table class='table table-striped table-bordered' style='width:36% !important; margin:auto; margin-bottom: 25px;'>\n"
							. "\t<tr><th>".INFO_LINE_INTERFACES_DIS."</th></tr>\n";
			foreach ($info['lif'] as $lif) {
				$html .= "\t<tr><td nowrap>$lif</td></tr>\n";
			}
			$html .= "</table>\n";
		}

		// storage
		$html .= $this->_displayInfoTable(INFO_STORAGE_DIS, $info['storage'], true);

		// uptime
		$uptime = array(
			'System'=> $info['system_uptime'],
			'ISGW'	=> $info['isgw_uptime'],
		);
		$html .= $this->_displayInfoTable(INFO_UPTIME_DIS, $uptime, true);

		return $html;
	}

	private function _displaySbcvmInfo($info) {
		// serial
		$html = $this->_displayInfoTable(INFO_SERIAL_NUMBER_DIS, $info['serial']);

		// versions
		$versions = array(
			'Package'	=> $info['package']['version'],
			'Appfs'		=> $info['package']['appfs'],
			'beroNode'=> $info['package']['beronode'],
			'OpenSSL'	=> $info['openssl'],
			'PHP' 		=> $info['php'],
		);
		$html .= $this->_displayInfoTable(INFO_VERSIONS_DIS, $versions, true);

		// network configuration
		$html .= $this->_displayNetworkTable($info['network'], null, $info['vpn-client']);

		// Sip license
		$html .= $this->_displaySipLicenseTable($info, 1);

		// date
		$html .= $this->_displayInfoTable(INFO_DATE_TIME_DIS, $info['date']);

		// uptime
		$uptime = array(
			'System'=> $info['system_uptime'],
			'ISGW'	=> $info['isgw_uptime'],
		);
		$html .= $this->_displayInfoTable(INFO_UPTIME_DIS, $uptime, true);

		return $html;
	}

	private function _displaySipLicenseTable($info, $is_sbc_vm = 0) {
		// check
		if (is_null($info['s2s_licenses'])) {
			return '';
		}
		$s2s_license = $info['s2s_licenses'];
		// get values
		$sessions = '';
		$transparant = '';
		if (preg_match('/^([0-9]+):([0-9]+)$/', trim($s2s_license['sip2sip_number_of_licenses']), $matched)) {
			$sessions = $matched[2];
			$transparent = $matched[1];
		}
		return	"<table class='table table-striped table-bordered' style='width:36% !important; margin:auto; margin-bottom: 25px;'>\n"
					.	"\t<tr><th colspan='2'>". SIP_LICENSE_HEADER_DIS ."</th></tr>\n"
					. "\t<tr><td>". SIP_LICENSE_STATE_DIS ."</td><td>". constant(trim($s2s_license['sip2sip_license_status'])) ."</td></tr>\n"
					. ($is_sbc_vm ? '' : "\t<tr><td>". SIP_LICENSE_SESSIONS_DIS ."</td><td>$sessions</td></tr>\n")
					. "\t<tr><td>". SIP_LICENSE_TRANSPARENT_SESSIONS_DIS ."</td><td>$transparent</td></tr>\n"
					. "</table>\n";
	}
}
?>
