<?php
############# /!\ /!\ PLEASE DO NOT USE /!\ /!\
## BACKUP CLOUD-API FOR 21.03 FW INSTALLED WITH A 20.06 ROOTFS INSTALLED
##				( should not happen)
## PLEASE DO NOT USE THIS SCRIPT TO INCREMENT NEW CLOUD FEATURES
## USE INSTEAD THE CLOUD-API FEATURE BELONGING TO ROOTFS

if (!defined('_CLOUDAPI_CLASS')) {
	define('_CLOUDAPI_CLASS', true);

	include_once("/usr/www/include/SQLite2ToSQLite3.php");
	require_once('/usr/local/www/berogui/misc/database.php');
	require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
	require_once('/usr/local/www/berogui/includes/Helper/Helper.php');
	require_once('/usr/local/php/include/confBackup.Class.php');
	require_once('/usr/fallback/beroConf.php');
	require_once('/usr/php/include/configExportImportTool.class.php');
	require_once('/usr/php/include/updateTool.php');

	/**
	 * Implementiert die Funktionen für die Kommunikation mit der Cloud
	 * @author Miguel Palmer <mp@beronet.com>
	 * @author Florian Kraatz <fk@beronet.com>
	 */
	Class cloudApi {

		private $_bc, $_ba, $_cardSerial, $_apiUrl, $_apiKey, $_apiVersion, $_proxyData;

		function __construct () {
			$this->_bc = new beroConf('root');
			$this->_ba = new beroAri('/usr/conf/ari.db');
			$cloudAddress = $this->_bc->get('root', 'cloudAddress');
			if (strlen($cloudAddress) == 0) {
				$cloudAddress = $this->_ba->get('cloudAddress');
			}
			if (strlen($cloudAddress) == 0) {
				$cloudAddress = 'berocloud.beronet.com';
			}
			$this->_cardSerial = Helper::getSerial();
			$this->_apiUrl = "https://$cloudAddress/index.php?r=api";
			$this->_apiKey = $this->_bc->get('root','cloud_key');
			$this->_apiVersion = '2.9';
			$this->_proxyData = array('address' => $this->_bc->get('root', 'proxyAddress'), 'port' => $this->_bc->get('root', 'proxyPort'),
						  'user' => $this->_ba->get('root', 'proxyUser'), 'secret' => $this->_bc->get('root', 'proxySecret'), 'type' => $this->_bc->get('root', 'proxyType'));
		}

		private function _modulesInstalled ($moduleNames = null) {
			if ($moduleNames == null) {
				return(false);
			}

			$moduleList = Helper::getLif();
			foreach($moduleNames as $moduleName) {
				if (in_array($moduleName, $moduleList)) {
					return(true);
				}
			}

			return(false);
		}

		private function _logCloud ($error) {
			file_put_contents('/var/log/cloud.log', Helper::getDate() . ' ' . $error . PHP_EOL, FILE_APPEND);
			$file = file('/var/log/cloud.log');
			if (count($file) >= 25000) {
				array_pop($file);
				file_put_contents('/var/log/cloud.log', $file);
			}
		}

		private function _curlInit ($data, $handle = null, $provideCredentials = true) {
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $this->_apiUrl);
			curl_setopt($ch, CURLOPT_POST, 1);
			curl_setopt($ch, CURLOPT_POSTFIELDS, ($provideCredentials ? array_merge(array('serial' => $this->_cardSerial, 'key' => $this->_apiKey), $data) : $data));
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_TIMEOUT, 100);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 100);
			curl_setopt($ch, CURLOPT_SSL_CIPHER_LIST, "AES256-SHA");

			if ($handle != null) {
				curl_setopt($ch, CURLOPT_FILE, $handle);
			}

			if ((strlen($this->_proxyData['address']) != 0) && (strlen($this->_proxyData['port']) != 0) && (strlen($this->_proxyData['type']) != 0)) {
				curl_setopt($ch, CURLOPT_PROXY, $this->_proxyData['address']);
				curl_setopt($ch, CURLOPT_PROXYPORT, $this->_proxyData['port']);
				curl_setopt($ch, CURLOPT_PROXYTYPE, $this->_proxyData['type']);
				if (strlen($this->_proxyData['user']) != 0) {
					curl_setopt($ch, CURLOPT_PROXYUSERPWD, $this->_proxyData['user'] . ':' . $this->_proxyData['secret']);
				}
			}

			return($ch);
		}

		private function _curlExec ($data, $handle = null, $provideCredentials = true) {
			$ch = $this->_curlInit($data, $handle, $provideCredentials);
			$ret = curl_exec($ch);
			curl_close($ch);
			return($ret);
		}

		private function _updateFW ($fileName) {
			$parm['userfile']['tmp_name'] = '/tmp/' . $fileName;
			$parm['userfile']['name'] = $fileName;
			$upd = new updateTool();
			$res = $upd->upload($parm);

			// Da die updateTool Klasse für Dateien, die durch ein Formular hochgeladen wurden konzipiert
			// wurde, wirft die Klasse einen Fehler, deswegen wird die Datei hier verschoben.
			if ($res['error_code'] == 3) {
				rename ('/tmp/' . $fileName, $upd->getImageDir() . '/' . $fileName);
				$upd->install($fileName);
			}
		}

		private function _systemReboot() {
			exec('/sbin/reboot');
			exit(0);
		}

		private function _syslogStart ($ip, $port) {
			$isgw = new isgwtelnet();
			if ($isgw->isgw_login() == false) {
				return;
			}

			file_put_contents('/var/log/syslog', $ip . ' ' . $port);
			$isgw->logactive(1);
			$isgw->loglevel(9);
			$isgw->logactive_message(1);
			$isgw->loglevel_message(2);
			$isgw->logserver($ip, $port);
		}

		private function _syslogStop () {
			$isgw = new isgwtelnet();
			if ($isgw->isgw_login() == false) {
				return;
			}

			$isgw->logactive(0);
			$isgw->loglevel(0);
			$isgw->logactive_message($this->_ba->get('syslog_active'));
			$isgw->loglevel_message($this->_ba->get('loglevel_message'));
			$result = $this->_ba->get('logserver');
			$ret = explode(':', $result);
			$ip = $ret[0];
			$port = $ret[1];
			$isgw->logserver($ip, $port);
		}

		private function _coreDumpUpload() {
			if (!file_exists('/var/log/debug-info.tar.gz')) {
				return;
			}

			clearstatcache();
			if (($time = filemtime('/var/log/debug-info.tar.gz')) != $this->_ba->get('time-coredump')) {
				$this->_ba->set('time-coredump', $time);
			}

			$file1 = file_exists('/var/log/core') ? '@/var/log/core' : '';
			$this->_curlExec(array('cmd' => 'coredumpResponse', 'file_name' => 'coredump.tar.gz', 'file' => '@/var/log/debug-info.tar.gz', 'file1' => $file1));
		}

		private function _coreDumpDelete () {
			@unlink('/var/log/debug-info.tar.gz');
			@unlink('/var/log/core');
			@unlink('/var/log/corelink');
		}

		private function _createTunnel ($key, $command) {
			if ((file_put_contents('/tmp/key', $key) === false) || (chmod('/tmp/key', 0600) === false)) {
				return;
			}

			exec('/sbin/' . $command);
			$this->_curlExec(array('cmd' => 'createTunnelResponse', 'result' => 'success'));
		}

		private function _configActivate () {
			$res = $this->_ba->set('activate','0');
			echo $this->_ba->error();
			exec('/usr/bin/php-cgi /usr/local/php/create_files.php');
			sleep(3);
			system('/usr/local/init/rcK');
			sleep(10);
			$this->_systemReboot();
		}

		private function _configUpdate ($file, $filename = 'beroGui.tar.gz') {
			if ($filename == 'beroGui.tar.gz'){
				$handle = @fopen('/tmp/beroGui.tmp.tar.gz', 'w');
				fwrite($handle, $file);
				fclose($handle);

				$cb = new confBackup();
				if ($cb->installFullBackup ('beroGui.tar.gz', '/tmp/beroGui.tmp.tar.gz') == true) {
					$res =  $this->_ba->set('activate','3');
				}
				$cb->installCleanup();
				@unlink('beroGui.tmp.tar.gz');
				@unlink('beroGui.tar.gz');
			} elseif (strstr($filename, '.config.xml')) {
				$handle = @fopen('/tmp/' . $filename, 'w');
				fwrite($handle, $file);
				fclose($handle);
				$imp = new configExportImportTool('/tmp/' . $filename);
				if (($configFiles = $imp->getConfigFiles()) === false) {
					return;
				}

				// create backup-directory
				if (!is_dir('/usr/conf/backup')) {
					@mkdir('/usr/conf/backup');
				}

				// go over configFiles
				foreach ($configFiles as $configFile) {
					// create backup of file
					@copy('/usr/conf/' . $configFile['name'], '/usr/conf/backup/' . $configFile['name']);
					@unlink('/usr/conf/' . $configFile['name']);

					// write file
					if (($FP = fopen('/usr/conf/' . $configFile['name'], 'w')) == null) {
						@copy('/usr/conf/backup/' . $configFile['name'], '/usr/conf/backup/' . $configFile['name']);
						continue;
					}

					fwrite($FP, $configFile['data'], strlen($configFile['data']));
					fclose($FP);
					$FP = null;
				}

				// go over appConfigFiles
				if (($appConfigFiles = $imp->getAppConfigFiles()) !== false) {
					foreach ($appConfigFiles as $app) {
						@mkdir('/usr/conf/userapp/' . $app['name']);

						if (empty($app['files'])) {
							continue;
						}

						foreach ($app['files'] as $appFile) {
							switch ($appFile['mode']) {
							case 'directory':	system('/bin/mkdir -p /usr/conf/userapp/' . $appFile['name']);	break;
							case 'binary':		$fileData = base64_decode($appFile['content']);			break;
							default:		$fileData = $appFile['content'];				break;
							}

							if ($appFile['mode'] != 'directory') {
								@unlink('/usr/conf/userapp/' . $appFile['name']);
								$FP = fopen('/usr/conf/userapp/' . $appFile['name'], 'w');
								fwrite($FP, $fileData, strlen($fileData));
								fclose($FP);
								$FP = null;
								unset($fileData);
							}

							system('/bin/chown admin:admin /usr/conf/userapp/' . $appFile['name']);
						}
					}
				}

				$restore = new restoreConfig(0);
				$restore->restoreConfig();
				$res = $this->_ba->set('activate','3');
    			}
		}

		private function _configBackup () {
			$exp = new configExportImportTool();
			$file = $exp->exportConfig();
			$filename = 'beroNetVoIPGateway_' . $this->_cardSerial . '_' . Helper::getDate('"+%c"') . '.config.xml';
			file_put_contents('/tmp/' . $filename, $file);
			$this->_curlExec(array('cmd' => 'backupConfigResponse', 'file_name' => $filename, 'file' => '@/tmp/' . $filename));
			@unlink('/tmp/' . $filename);
		}

		private function _queryInfo () {
			$data['cmd'] = 'queryResponse';
			$data['fw_version'] = Helper::getAppFsVersion();
			$data['rootfs_version'] = Helper::getRootFsVersion();
			$data['fpga_version'] = Helper::getFpgaVersion();
			$data['hw_rev'] = Helper::getRevision();
			$data['apiVersion'] = $this->_apiVersion;
			$data['mac'] = Helper::getNetworkMacAddr(Helper::getNetworkIfaceByName('lan'));
			$data['ip'] = Helper::getNetworkIpAddr(Helper::getNetworkIfaceByName('lan'));
			$data['apps'] = serialize(Helper::getAppList());
			$data['lifname'] = serialize(Helper::getLif());

			$isgw = new isgwtelnet();
			if ($isgw->isgw_login()) {
				$data['sip_license_count'] = trim($isgw->isgw_siplicensecount());
				$this->_logCloud ( "sip_license_count:".$data['sip_license_count']);
			}

			// collect sip-info
			$query = $this->_ba->select('SELECT * FROM sip');
			while ($entry = $this->_ba->fetch_array($query)) {
				$sip[] = array('name' => $entry['name'], 'monitor' => $entry['register']);
			}
			$data['sip'] = serialize(!empty($sip) ? $sip : array());

			$this->_curlExec($data);
		}

		private function _apiUpdate ($file) {
			if (($handle = @fopen('/tmp/cloud-api.php', 'w')) == null) {
				return;
			}
			fwrite($handle, $file);
			fclose($handle);

			system('/bin/mount -o remount,rw /usr/local/');
			system('/bin/cp /tmp/cloud-api.php /usr/local/php/');
			system('/bin/sync');
			system('/bin/mount -o remount,ro /usr/local/');
		}

		private function _aliveData () {
			$isgw = new isgwtelnet();
			$isgw_ret['state'] = ($isgw->isgw_login() == false) ? 0 : 1;
			if ($isgw_ret['state'] == 1) {
				$isgw_ret['uptime'] = preg_split('/: /', $isgw->isgw_uptime());
				$isgw_ret['actualcalls'] = explode("\n", $isgw->isgw_actualcalls());

				foreach(array('pstn_to_sip', 'sip_to_pstn') as $statName) {
					$statistics[$statName] = file_exists('/tmp/cloud.' . $statName) ? unserialize(file_get_contents('/tmp/cloud.' . $statName)) : array();
					// remove old entries from array
					while (count($statistics[$statName]) >= 20) {
						array_shift($statistics[$statName]);
					}

					// get and save data
					foreach ($isgw_ret['actualcalls'] as $statLine) {
						if (preg_match('/.*' . strtoupper($statName) . '.*\((.*) connected\).*/', $statLine, $matches) ) {
							$statistics[$statName][] = $matches[1];
							break; 
						}

					}
					unset($matches);
					file_put_contents('/tmp/cloud.' . $statName, serialize($statistics[$statName]));

					// calculate average
					$average[$statName] = 0;
					foreach($statistics[$statName] as $value) {
						$average[$statName] += $value;
					}
					$average[$statName] = round($average[$statName] / count($statistics[$statName]));
				}
			}

			// get uptime data
			$uptime_sec = strtok(file_get_contents('/proc/uptime'), '.');

			// get load data
			$load = strtok(file_get_contents('/proc/loadavg'), ' ');

			$string = file_get_contents('/proc/meminfo');
			preg_match('/.*MemFree:[ ]*([0-9]*)[ ]*kB*/', $string, $free_mem);
			preg_match('/.*Cached:[ ]*([0-9]*)[ ]*kB*/', $string, $cached);

			// coredump
        		$coredump = 0;
        		$sendCD = 0;
			if (file_exists('/var/log/debug-info.tar.gz')) {
				$coredump = 1;
				clearstatcache();
			       	$time = filemtime('/var/log/debug-info.tar.gz');
				if ($time != $this->_ba->get('time-coredump')) {
					$sendCD = 1;
				}
				file_put_contents('/var/log/time', $time . '=' . $this->_ba->get('time-coredump') . ' ' . $sendCD);
			}

			$data = array('cmd' => 'alive', 'serial' => $this->_cardSerial, 'key' => $this->_apiKey, 'uptime' => $uptime['t'], 'uptime_sec' => $uptime_sec,
				'isgw_state' => $isgw_ret['state'], 'coredump' => $coredump, 'sendCD' => $sendCD, 'isgw_uptime' => $isgw_ret['uptime'][1],
				'load' => $load, 'free_mem' => ($free_mem[1] + $cached[1]),
				'pstn_to_sip' => is_null($average['pstn_to_sip']) ? 'null' : $average['pstn_to_sip'], 'sip_to_pstn' => is_null($average['sip_to_pstn']) ? 'null' : $average['sip_to_pstn'],
			);

			return($data);
		}

		private function _isdnStatus () {
			if (!$this->_modulesInstalled(array('bf1S0', 'bf2S0', 'bf4S0', 'bf1E1', 'bf2E1', 'bf2S02FXS', 'bf1t1e1', 'bf2t1e1', 'bf4t1e1'))) {
				return(false);
			}

			$isgw = new isgwtelnet();
			if ($isgw->isgw_login() == false) {
				return(false);
			}
			
			// ISDN-Status nochmals einlesen
			$isdnresult = $isgw->isgw_isdnstate();
			$rows = explode("\n", $isdnresult);

			if (file_exists('/proc/l1_stats')) {
				foreach (file('/proc/l1_stats') as $key => $value) {
					foreach (explode(';', $value) as $werte) {
						$wert = explode('=', $werte);
						switch($wert[0]) {
						case 'port':
							$port = $wert[1];
							$l1_stats[$wert[1]] = "";
							break;
						case 'crc':
							$crc[$port] = $wert[1];
							$l1_stats[$port].="CRC Error: " . $wert[1] . "\n";
							break;
						}
					}
				}
			}

			if (file_exists('/proc/l2_stats')) {
				foreach (file('/proc/l2_stats') as $key => $value) {
					foreach (explode(';', $value) as $werte) {
						$wert = explode("=", $werte);
						switch($wert[0]) {
						case 'port':
							$port = $wert[1];
							$l2_stats[$wert[1]] = "";
							break;
						case 'mdl':
							$l2_stats[$port].="L2 Error: " . $wert[1] . "\n";
							break;
						case 'frm':
							$l2_stats[$port].="L2 Frame Error: " . $wert[1] . "\n";
							break;
						}
					}
				}
			}

			$i = 0;
			foreach ($rows as $value) {
				if (strpos($value, 'Port') !== false) {
					preg_match('&\* Port (?<port>\d+) Type (?<type>\w+) Prot. (?<prot>\w+) L2Link (?<l2>\w+) L1Link:(?<l1>\w+) Blocked:0&isU', $value, $arr);

					$isdnStatus[$i]['port'] = $arr['port'];
					$isdnStatus[$i]['state'] = $arr['l2'];
					$isdnStatus[$i]['ISDN CRC Error'] = $crc[$arr['port']];
					$isdnStatus[$i]['ISDN Port State L1'] = ($arr['l1'] == "UP") ? "1" : "0";
					$isdnStatus[$i]['ISDN Port State L2'] = ($arr['l2'] == "UP") ? "1" : "0";
					$isdnStatus[$i]['state'] = $arr['l2'];
					$isdnStatus[$i++]['message'] = 'L2Link:' . $arr['l2'] . "\n" . 'L1Link:' . $arr['l1'] . "\n" . $l1_stats[$arr['port']];
				}
			}

			return(array('cmd' => 'isdnStatus', 'serial' => $this->_cardSerial, 'key' => $this->_apiKey, 'status' => serialize(!empty($isdnStatus) ? $isdnStatus : array())));
		}

		private function _analogStatus () {
			if (!$this->_modulesInstalled(array('bf1FXS', 'bf2FXS', 'bf4FXS', 'bf8FXS', 'bf2S02FXS', 'bf2FXO', 'bf4FXO'))) {
				return(false);
			}

			$isgw = new isgwtelnet();
			if ($isgw->isgw_login() == false) {
				return(false);
			}

			$analogresult = $isgw->isgw_analogstate();
 			$i = 0;
			foreach(explode("\n", $analogresult) as $value) {
				if (strpos($value, 'Port') === false) {
					continue;
				}

				$tmp = explode("Port ", $value);
				$port = explode("type:", $tmp[1]);
				$message = "Port: " . $port[0] . "\n";
				$analogStatus[$i]['port'] = $port[0];
				$type = explode("state:", $port[1]);
				$message .= "Type: " . $type[0] . "\n";
				$state = explode("linevoltage:", $type[1]);
				$message .= "State: " . $state[0] . "\n";
				$linevoltage = explode("pol:", $state[1]);
				$message .= "Line voltage: " . $linevoltage[0] . "\n";
				$analogStatus[$i]['state'] = ($linevoltage[0] >= 30) ? 'UP' : 'DOWN';
				$pol = explode("rtlc:", $linevoltage[1]);
				$message .= "Polarity: " . $pol[0] . "\n";
				$analogStatus[$i++]['message'] = $message;
			}

			return(array('cmd' => 'analogStatus', 'serial' => $this->_cardSerial, 'key' => $this->_apiKey, 'status' => serialize(!empty($analogStatus) ? $analogStatus : array())));
		}

		private function _gsmStatus () {
			if (!$this->_modulesInstalled(array('bf1GSM', 'bf2GSM'))) {
				return(false);
			}

			$isgw = new isgwtelnet();
			if ($isgw->isgw_login() == false) {
				return(false);
			}

			$gsmresult = $isgw->isgw_gsmstate();
			$i = 0;
			foreach(explode("\n", $gsmresult) as $value) {
				if (strpos($value, 'Port') === false) {
					continue;
				}

				$tmp = explode("Port ", $value);
				$port = explode("Provider:", $tmp[1]);
				$message .= "Port: " . $port[0] . "\n";
				$gsmStatus[$i]['port'] = $port[0];
				$provider = explode("Pin Counter:", $port[1]);
				$message .= "Provider: " . $provider[0] . "\n";
				$counter = explode("Reg Status:", $provider[1]);
				$message .= "PIN Counter: " . $counter[0] . "\n";
				$state = explode("RSSI:", $counter[1]);

				switch (trim($state[0])) {
				case 'NOT READY':
					$gsmStatus[$i]['state'] = "DOWN";
					$message .= "Reg Status: Not ready\n";
					break;
				case 0:
					$gsmStatus[$i]['state'] = "DOWN";
					$message .= "Reg Status: not registered, ME is <b>not</b> currently searching a new operator to register to\n";
					break;
				case 1:
					$gsmStatus[$i]['state'] = "UP";
					$message .= "Reg Status: registered, home network\n";
					break;
				case 2:
					$gsmStatus[$i]['state'] = "DOWN";
					$message .= "Reg Status: not registered, but ME is currently searching a new operator to register to\n";
					break;
				case 3:
					$gsmStatus[$i]['state'] = "DOWN";
					$message .= "Reg Status: registration denied\n";
					break;
				case 4:
					$gsmStatus[$i]['state'] = "DOWN";
					$message .= "Reg Status: unknown\n";
					break;
				case 5:
					$gsmStatus[$i]['state'] = "UP";
					$message .= "Reg Status: registered, roaming\n";
				}

				$rssi = explode("BER:", $state[1]);
				$rssiNumber = explode(" ", trim($rssi[0]));
				if ($rssiNumber[0] == -1 || $rssiNumber[0] == 99)
					$message.="Signal: -\n";
				elseif ($rssiNumber[0] > -60)
					$message.="Signal: VERY HIGH\n";
				elseif ($rssiNumber[0] <= -60 && $rssiNumber[0] > -75)
					$message.="Signal: HIGH\n";
				elseif ($rssiNumber[0] <= -75 && $rssiNumber[0] > -100)
					$message.="Signal: OK\n";
				elseif ($rssiNumber[0] <= -100)
					$message.="Signal: LOW\n";

				$message.="RSSI: " . $rssi[0] . "\n";
				$ber = $rssi[1];
				$message.="BER: " . $ber . "\n";

				$gsmStatus[$i++]['message'] = $message;
			}

			return(array('cmd' => 'gsmStatus', 'serial' => $this->_cardSerial, 'key' => $this->_apiKey, 'status' => serialize(!empty($gsmStatus) ? $gsmStatus : array())));
		}

		private function _sipStatus () {
			$isgw = new isgwtelnet();
			if ($isgw->isgw_login() == false) {
				return(false);
			}

			$sipresult = $isgw->isgw_sipstate();
			$i = 0;
			foreach (explode("\n", $sipresult) as $value){
				preg_match('/(.+)\s*\=\>(.+)\s*/', $value, $match);
				switch (trim($match[1])) {
				case 'ACCOUNTNAME':
					$name = trim($match[2]);
					$sipStatus[$i]['message'] .= preg_replace("/\s+/", "", $value);
					break;
				case 'ADDRESS':
				case 'USERNAME':
					$sipStatus[$i]['message'] .= preg_replace("/\s+/", "", $value);
					break;
				case 'REGSTATUS':
					$sipStatus[$i]['name'] = $name;
					$sipStatus[$i]['state'] = trim($match[2]);
					$sipStatus[$i]['message'] .= preg_replace("/\s+/", "", $value);
					unset($name);
					$i++;
					break;
				}
			}

			return(array('cmd' => 'sipStatus', 'serial' => $this->_cardSerial, 'key' => $this->_apiKey, 'status' => serialize(!empty($sipStatus) ? $sipStatus : array())));
		}

		public function getTask () {
			$response = unserialize($this->_curlExec(array('cmd' => 'getTask')));

			// we log the sane task-requests we get
			if (strlen($response['task']) > 0) {
				$this->_logCloud('Received Task "' . $response['task'] . '" from beroCloud.');
			} 
			switch ($response['task']) {
			case 'updateFW':
				$this->_logCloud('Updating Firmware from "' . $response['file_name'] . '".');
				$this->_ba->set('cloudFileName', $response['file_name']);
				$upd = new updateTool();
				$upd->reboot();
				$this->_configActivate();
				$this->_systemReboot();
				break;
			case 'installApp':
				$this->_logCloud('Installing User-App from "' . $response['file_name'] . '".');
				$handle = @fopen('/tmp/' . $response['file_name'], 'w');
				$this->_curlExec(array('cmd' => 'appDownload', 'idapp' => $response['idapp']), $handle);
				fclose($handle);
				$this->_updateFW($response['file_name']);
				break;
			case 'reboot':
				$this->_systemReboot();
				break;
			case 'createTunnel':
				$this->_logCloud('Creating SSH-Tunnel with "' . $response['sysCmd'] . '".');
				$this->_createTunnel($response['sshKey'], $response['sysCmd']);
				break;
			case 'activate':
				$this->_configActivate();
				break;
			case 'updateConfig':
				$this->_logCloud('Updating config from "' . $response['file_name'] . '".');
				$this->_configUpdate($response['file'], $response['file_name']);
				break;
			case 'backupConfig':
				$this->_configBackup();
				break;
			case 'coredump':
				$this->_coreDumpUpload();
				break;
			case 'deleteCoredump':
				$this->_coreDumpDelete();
				break;
			case 'Query':
				$this->_queryInfo();
				break;
			case 'syslog':
				$this->_logCloud('Configuring syslog with IP "' . $response['ip'] . '" and port "' . $response['port'] . '".');
				$this->_syslogStart($response['ip'], $response['port']);
				break;
			case 'stopSyslog':
				$this->_syslogStop();
				break;
			case 'updateAPI':
				$this->_apiUpdate($response['file']);
				break;
			}

			if ($response['next']) {
				$this->getTask();
			}
		}

		public function mainRequest () {

			$data['alive']= serialize($this->_aliveData());

			if (($status = $this->_isdnStatus()) !== false) {
				$data['isdnStatus'] = serialize($status);
			}

			if (($status = $this->_analogStatus()) !== false) {
				$data['analogStatus'] = serialize($status);
			}

			if (($status = $this->_gsmStatus()) !== false) {
				$data['gsmStatus'] = serialize($status);
			}

			if (($status = $this->_sipStatus()) !== false) {
				$data['sipStatus'] = serialize($status);
			}

			$ch = $this->_curlInit($data, null, false);
    			curl_exec($ch);

			if(!curl_errno($ch)) {
        			// Wenn alive nicht funktioniert
        			$info = curl_getinfo($ch);

				if (($info['http_code'] == 400) || ($info['http_code'] == 401)) {
					sleep(5);
					$this->_bc->set('root', 'cloud_enable', '0');
					$this->_ba->set('error', 'Invalid cloud request. Please check your cloud registration');
					$this->_logCloud('Invalid cloud request. Please check your cloud registration - Main request');

					if ($this->_ba->get('activate') <= 1) {
						$this->_ba->set('activate', '1');
					}
					curl_close($ch);
					exec('/usr/local/init/S60cloud stop');
					die('Invalid cloud request. Please check your cloud registration');
				} else {
            				$this->_ba->set('error', '');
				}
			} else {
				$this->_logCloud(curl_error($ch) . ' ' . curl_errno($ch) . ' Main request');
				$this->_ba->set('error', curl_error($ch));
			}

			curl_close($ch);
		}

	/* [COMPATIBILITY METHODS] */
	//// If updating rootfs of 21.03 firmware (or higher) from older firmware fails
	//// the cloud connection would be broken 
	//// we define some functions to ensure a compatibility and give the possibility
	//// to fix a device from beroCloud
	//////// MUST BE REMOVED IN THE FUTURE
	public function send($uri, $data = array(), $options = null, $info = null) {
		return($this->_doCurl($uri, $data));
	}

	private function _doCurl($uri, $data) {
		$ch = curl_init("$this->_apiUrl/$uri");
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, array_merge(array('serial' => $this->_cardSerial, 'key' => $this->_apiKey), $data));
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		$fp = null;
		if (1) {
			curl_setopt($ch, CURLOPT_VERBOSE, 1);
			if ($fp = fopen('/tmp/curl.cloud.log', 'w')) {
				curl_setopt($ch, CURLOPT_STDERR, $fp);
			}
		}
		$result = curl_exec($ch);
		curl_close($ch);
		if (!is_null($fp)) {
			fclose($fp);
		}
		return($result);
	}

	}

} /* _CLOUDAPI_CLASS */
