<?php
require_once ("/usr/local/php/include/apiCall.class.php");
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/local/www/berogui/misc/database.php');
require_once('/usr/local/php/include/fulltrace.Class.php');

class GatewayFulltrace extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		if (!isset($this->_parameters['performAction']) || empty($this->_parameters['performAction'])) {
			$this->_execResultString = 'error:missing_parameter_performAction;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$db = new beroAri();
		$ft = new fulltrace(null, $db);

		switch ($this->_parameters['performAction']) {
		case 'start':
			if ($db->get('trace') == 1) {
				$this->_execResultString = 'error:trace_alread_in_progress;';
				$this->_execResult = false;
				$this->_execResponseCode = 405;
				return($this->_execResult);
			}

			$enable = (($this->_parameters['mode'] == 1) ? 1 : 0);
			$ft->start($enable, array(
				'advanced' => isset($this->_parameters['options']) ? $this->_parameters['options'] : null,
				'analog' => array(
					'isset' => isset($this->_parameters['ports']),
					'ports' => isset($this->_parameters['ports']) ? explode('|', $this->_parameters['ports']): null,
				),
			));
			break;
		case 'stop':
			$ft->stop(false);
			break;
		case 'cancel':
			$ft->stop(false, 1);
			break;
		case 'download':
			$this->_execResponseCode = false;
			if (!file_exists('/var/log/DebugFiles.tar.gz')) {
				$this->_execResultString = 'error:no_fulltrace_found;';
				$this->_execResponseCode = 404;
				$this->_execResult = false;
			}
			break;
		default:
			$this->_execResultString = 'error:invalid_parameter_performAction;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			break;
		}

		return($this->_execResult);
	}

	function display () {
		if (($this->_parameters['performAction'] == 'download') && ($this->_execResult != false)) {
			$debugArchive = file_get_contents('/var/log/DebugFiles.tar.gz');
			header('Content-Type: application/force-download');
			header('Content-Disposition: attachment; filename=DebugFiles.tar.gz' . "\r\n\r\n");
			header('Content-Length: ' . strlen($debugArchive) . "\n\n");

			return($debugArchive);
		}

		return($this->_name . ':' . $this->_execResultString);
	}

}?>