<?php
$m = 'Vpn';
define('BEROGUI_PATH', '/usr/local/www/berogui');

/* [REQUIRED] */
require_once('/usr/fallback/beroConf.php');
require_once("/usr/local/php/include/beronode/VpnApi.php");
require_once(BEROGUI_PATH ."/misc/database.php");
require_once(BEROGUI_PATH ."/includes/Helper/Helper.php");

/* [INTERN FUNCTIONS] */
function isDataAccepted($m, &$data, $exec_ajax = 1, $invalid = []) {
	$parameters = require(BEROGUI_PATH ."/modules/Vpn/vpn_parameters.php");
	Helper::setDataValidator($parameters['server']['data'], $list_data, $options_data);
	$data = Helper::sanitizePost($data, $list_data, $exec_ajax, $invalid, $options_data);
	if (!$exec_ajax) {
		Helper::redirectOnInvalidData($m, $invalid);
	}
}

/* [CHECKING SESSION] */
$newTarget = "/app/berogui/index.php?m=$m";
include(BEROGUI_PATH ."/includes/session.php");
unset($newTarget);

/* [CHECKING GET] */
unset($_GET);

/* [CHECKING POST] */
unset($_POST['submit']);
$exec_ajax = 1;

$data = $_POST['data'];
unset($_POST['data']);

$list_post = [
	'action'				=> 'select',
	'idkey' 				=> 'int>=0',
	'isMainVpnExist'=> 'bool',
];

$options_post = [
	'action' => ['delete', 'kill-client', 'save'],
];

$_POST = Helper::sanitizePost($_POST, $list_post, $exec_ajax, $invalid, $options_post);
$action = $_POST['action'];

/* [EXECUTING AJAX] */
if (!$exec_ajax) {
	Helper::redirectOnInvalidData($m, $invalid);
}

$vpn_api = new VpnApi();

switch ($action) {
case 'delete':
	$id = $_POST['idkey'];

	// remove vpn server
	if (!$vpn_api->serverStop($id)) {
		Helper::redirectOnError($m, 2, $vpn_api->getError('msg'));
	}

	// update beroari
	$ba = new beroAri();
	$ba->delete("DELETE FROM sbc_vpns WHERE id='$id'");

	// update beroconf
	$bc = new beroConf('root');
	$update = [
		'is-vpn-running'	=> 0,
		'lan-ipaddr' 			=> '',
		'lan-mode'				=> 'single',
		'lan-netmask'			=> '',
	];
	foreach ($update as $key => $value) {
		$bc->set('root', $key, $value);
	}
	break;
case 'kill-client':
	// get client info
	require_once(BEROGUI_PATH ."/modules/Vpn/vpn_helper.php");
	$client = VpnHelper::getDataClients();
	if ($vpn_api->clientKill(0, ['name' => $client[0]['commonName']]) == false) {
		Helper::redirectOnError($m, 2, $vpn_api->getError('msg'));
	}
	break;
case 'save':
	isDataAccepted($m, $data);
	$id = $_POST['idkey'];
	$hasMainVpn = $_POST['isMainVpnExist'] == 1;

	// update beroari -> must be executed before vpn_api since the setup_script use beroAri database
	$ba = new beroAri();
	if ($hasMainVpn) {
		$ba->updateTable('sbc_vpns', $id, $data);
	}
	else {
		$ba->insertTable('sbc_vpns', $id, $data);
	}

	// update VPN settings using nodejs server
	if (!$vpn_api->serverStart($id, $data)) {
		$ba->delete("DELETE FROM sbc_vpns WHERE id='$id'");
		Helper::redirectOnError($m, 2, $vpn_api->getError('msg'));
	}

	$ipaddr = Helper::getNetworkIpAddr('tun0', 1);
	$netmask = Helper::getNetworkMask('tun0', 1);

	$ba->updateTable('sbc_vpns', $id, ['ipaddr' => $ipaddr]);

	// update beroconf
	$bc = new beroConf('root');
	$update = [
		'is-vpn-running'	=> 1,
		'lan-ipaddr' 			=> $ipaddr,
		'lan-mode'				=> 'lan-wan',
		'lan-netmask'			=> $netmask,
	];
	foreach ($update as $key => $value) {
		$bc->set('root', $key, $value);
	}
	break;
}

// redirect
Helper::redirectAfterSubmit($ba, $m);
?>
