#!/usr/bin/php -q
<?php
##########################
#### /!\ /!\ PLEASE DO NOT USE THIS SCRIPT - USED AS BACKUP /!\ /!\
####
#### USE /usr/fallback/cloud INSTEAD

$apiVersion="1.0";
/*
 * Einbindung der nötigen externen Klassen
 */
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');

/*
 * Datenbank Klassen instanziieren
 */
$bc = new beroConf('root');

$apiUrl='https://'.$bc->get('root', 'cloudAddress').'/index.php?r=api';


/*
 * Seriennummer der Karte herausfinden
 */
$serial = trim(file_get_contents('/sys/class/beronet/gateway/serial'));
$apiKey=$bc->get('root','cloud_key'); //Dummy
$proxyAddress=$bc->get('root', 'proxyAddress');
$proxyPort=$bc->get('root', 'proxyPort');
$proxyUser=$bc->get('root', 'proxyUser');
$proxySecret=$bc->get('root', 'proxySecret');
$proxyType=$bc->get('root', 'proxyType');

$pstn_to_sip_arr=array();
$sip_to_pstn_arr=array();

$sleep_interval=$bc->get('root', 'cloud_interval');
if (!$sleep_interval) $sleep_interval=60;

$cloud_enable=$bc->get('root', 'cloud_enable');
if ($cloud_enable != 1 ) {
	exit(1);
}

try {
    if ($bc->get("cloudFileName")!="")
	getFW();
} catch(Exception $e) {
	file_put_contents('/var/log/api-error.log' , $e->getMessage(). ' ' .$e->getFile(). ' ' .$e->getLine() . "\n" , FILE_APPEND);
}


/**
  * Geplante Aufgaben aus dem Server lesen
  *
  * Diese Funktion ist eine rekursive Funktion, und wird so oft
  * ausgeführt, wie es geplante fällige Aufgaben auf dem Server gibt.
  *
  * @return void
  */
function getFW(){
    global $serial, $apiKey, $apiUrl, $proxyAddress, $proxyPort, $proxyUser, $proxySecret, $proxyType;
                $file_name=$bc->get("cloudFileName");
		$handle = @fopen('/tmp/'.$file_name, 'w');
		$ch = curl_init();
		$data = array('cmd'=>'firmwareDownload', 'serial'=>$serial, 'key'=>$apiKey);
		curl_setopt($ch, CURLOPT_URL, $apiUrl);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_FILE, $handle);
                if ($proxyAddress!='' && $proxyPort!='' && $proxyType!=''){
                    curl_setopt($ch, CURLOPT_PROXY, $proxyAddress);
                    curl_setopt($ch, CURLOPT_PROXYPORT, $proxyPort);
                    curl_setopt($ch, CURLOPT_PROXYTYPE, $proxyType);
                    if ($proxyUser!="")
                        curl_setopt($ch, CURLOPT_PROXYUSERPWD, $proxyUser.':'.$proxySecret);

                }
		curl_exec($ch);
		curl_close($ch);
		fclose($handle);

		updateFW($file_name);

}

/**
  * Firmware der Karte aktualisieren
  *
  * Die Alte Firmwares dir sich auf der Karte befinden werden gelöscht
  * und die neue Firmware wird installiert, die die aus der beroCloud
  * heruntergeladen wurde.
  *
  * @param  $fileName Name der neuen Firmware
  * @return void
  */
function updateFW($fileName){
	global $bc;
        require_once('/usr/php/include/updateTool.php');
        $parm=array();
        $parm['userfile']['tmp_name']="/tmp/".$fileName;
        $parm['userfile']['name']=$fileName;
        $updateTool=new updateTool();
        $result=$updateTool->upload($parm);
        /*
         * Da die updateTool Klasse für Dateien, die durch ein Formular hochgeladen wurden konzipiert
         * wurde, wirft die Klasse einen Fehler, deswegen wird die Datei hier verschoben.
         */
	if ($result['error_code']==3){
            rename ('/tmp/' . $fileName, $updateTool->getImageDir()."/".$fileName);
            $updateTool->install($fileName);
            $file_name=$bc->set("cloudFileName","");

	}


}

?>
