<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class CFActivate extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}
	
	function execute () {
		//sanitize
		$this->_allowedParameters += array(
			'Port'                 => 'int-range',
			'ServedUserNumber'     => 'phone-char',
			'ForwardedToNumber'    => 'phone-char',
			'ServedUserNumberTon'  => 'int',
			'ForwardedToNumberTon' => 'int',
		);
		$this->_sanitizeOptions =array('Port'=> array('min' =>1, 'max'=>12));
		if ($this->sanitizeInputs()==false) return $this->_execResult;
		

		if (!isset($this->_parameters['Port']) || !isset($this->_parameters['ServedUserNumber']) || !isset($this->_parameters['ForwardedToNumber'])) {
			$this->_execResultString = 'error:missing_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$cfact_cmd = "cfact:" . $this->_parameters['Port'] . ":" . $this->_parameters['ServedUserNumber'] . ":" . $this->_parameters['ForwardedToNumber'];
		
		if (isset($this->_parameters['ServedUserNumberTon'])) {
			$cfact_cmd .= ":" . $this->_parameters['ServedUserNumberTon'];
			if (isset($this->_parameters['ForwardedToNumberTon'])) {
				$cfact_cmd .= ":" . $this->_parameters['ForwardedToNumberTon'];
			}
		}
		$isgw = new isgwtelnet();
		if (!($result = $isgw->isgw_login())) {
				$this->_execResultString = 'error:login_failed;';
				$this->_execResult = false;
				$this->_execResponseCode = 500;
				return($this->_execResult);
		}
		$this->_execResultString .= "\n" . trim($isgw->Query($cfact_cmd));
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>