<?php

if (!defined('_CONFIGEXPORTIMPORTTOOL_CLASS')) {
	define('_CONFIGEXPORTIMPORTTOOL_CLASS', true);

	include('/usr/php/include/verySimpleXmlParser.php');
	include_once("/usr/www/include/SQLite2ToSQLite3.php");
	include_once '/usr/fallback/beroConf.php';
	require_once('/usr/php/include/rootHelper.class.php');

	class configExportImportTool {

		private $_configPath;
		private $_xmlData;
		private $_error = array('has' => false, 'whichOne' => null, 'more' => null);

		private $_is_sbc_vm = false;
		/**
		 * is dynamically populated for export and import based on whetever a config file is given when object is created and on device modules and files
		 */
		private $_fileList;
		/**
		 * array with ['name'] and ['data'] of all files when importing a file
		 */
		private $_fileData;
		private $_fileDataIndex =0;
		private $_fileGroups;
		private $_fileGroupsTooltips;
		private $_tlsCertFiles = array();
		private $_sectionGroups=array();
		private $_sectionGroupsTooltips;

		/**
		 * Import: shows if the file inlcudes app configurations
		 * Export: shows if apps are installed on the system
		 */
		private $_apps=false;
		private $_provisionConfigUpdate = false;
		private $_provisionActivate = false;
		private $_plainPassword;

		//To add||change things, you will need to add||modify cases for import, export and for groups in the commented sections
		/**
		 * Constructor
		 * @param string $fileName File for import
		 * @param boolean $parse whetever the given file should be xml parsed or not. if set to false only the filelists and groups are set
		 */
		function __construct ($fileName = null,$parse = true) {
			$this->_xmlData = null;

		//set all stuff for export
			if (false) {
				$this->_configPath = "/etc/beroNet/isgw/";
				$this->_fileList = array('isgw.conf', 'isgw.dialplan', 'isgw.sip', 'isgw.whitelist', 'misc.conf', 'network.acl');
			}
			else {
				$this->_configPath  = "/usr/conf/";
				$this->_fileList = array('hardware.conf', 'isgw.causes', 'isgw.conf', 'isgw.cpt', 'isgw.dialplan', 
										 'isgw.sip', 'isgw.whitelist', 'misc.conf', 'network.acl','apiusers.conf');
				$this->_fileList = array_merge($this->_fileList,$this->_setFilesOfModulesInstalled());
			}
			if($fileName==null){
			// certfile list
			$this->_tlsCertFiles= rootHelper::tlsGetCertificate();
			foreach($this->_tlsCertFiles as $tlsFile){
				if(!file_exists($tlsFile)){
					$this->_tlsCertFiles= array_diff($this->_tlsCertFiles,array($tlsFile));
				}
			}
			//sets appstatus(whetever apps are installed)
			$apps_installed = rootHelper::getAppList();
			if(count($apps_installed)) $this->_apps = true;

			}
		// sets all stuff for import
			if ($fileName != null) {
				$this->_tlsCertFiles =array();
				if (substr($fileName, -3) == '.gz') {
					exec("gzip -d $fileName");
					$fileName = substr($fileName, 0, -3);
				}
				// parses file completely
				if($parse ==true){
					if (($this->_xmlData = xmlParseData(file_get_contents($fileName))) === false) {
						exit(false);
					}
					$this->_setConfigData();
					$filesNotPresent =array_diff(array('iw.analog',"isgw.gsm","isgw.isdn","isgw.cas","isgw.lte"),$this->_setFilesOfModulesInstalled());
					$this->_fileList = array_diff($this->_fileList,$filesNotPresent);
				}
				//only sets list and groups of files
				else if ($parse ==false){
					$configFileString =file_get_contents($fileName);
					preg_match_all('/<Name>(?<Name>.*)<\/Name>/', $configFileString, $matched);
					$this->_fileList = array_intersect($matched['Name'], $this->_fileList);
					$this->_fileList = array_merge($this->_fileList, array_intersect($matched,$this->_setFilesOfModulesInstalled()));
					foreach (array('caCrt', 'clientCrt', 'clientKey') as $tlsFile) {
						if (in_array($tlsFile, $matched['Name'])) {
							$this->_tlsCertFiles[] = $tlsFile;
						}
					}
					if(strstr($configFileString,'<AppConfig>')) $this->_apps =true;
				}	 
			}
		//sets groups for import and export
			$this->_setFileGroups();
			$this->_setSectionGroups();		
		}
	
		public function hasError() {
			return($this->_error['has']);
		}

		public function getError() {
			return($this->_error);
		}

		/**
		 * Checks module specified with @param $lifToCheck, for whetever the cas mode is activated for that module
		 *
		 * @param int index of lif to check for cas mode
		 * @return int 0 if no cas mode, 1 if cas mode, 2 if both  cas and isdn mode on different ports
		 */
		private function _checkCasMode($lifToCheck){
			if (file_exists('/usr/conf/hardware.conf')){ 
				$hardwareConf = @parse_ini_file('/usr/conf/hardware.conf',true);
				$lifConf = $hardwareConf['lif'.$lifToCheck]['interface_type'];
				if(preg_match('/^cas(,*(cas)*)*$/',$lifConf) == true) return 1;
				else if(strstr($lifConf,'cas')!==false) return 2;
				else return 0;
			}
			else return 0;
		}

		/**
		 * gets modules of gateway and returns the corresponding configuration files in array
		 * @return array
		 */
		private function _setFilesOfModulesInstalled(){
			$modulefiles = array();
			foreach(rootHelper::getLif() as $lifIndex => $module){
				$module = ltrim($module, "bf");
				switch ($module) {
					case '2S02FXS':
						if(!in_array("isgw.analog",$modulefiles,1))array_push($modulefiles, "isgw.analog");
						if(!in_array("isgw.isdn",$modulefiles,1))array_push($modulefiles, "isgw.isdn");
						break;
					
					case preg_match('/[1248]FX[OS]/', $module)==1:
						if(!in_array("isgw.analog",$modulefiles,1))array_push($modulefiles, "isgw.analog");
						break;
					
					case preg_match('/[124]S0|[12]E1/',$module)==1:
						if(!in_array("isgw.isdn",$modulefiles,1))array_push($modulefiles, "isgw.isdn");
						break;
					case preg_match('/[12]LTE/', $module)==1:
						if(!in_array("isgw.lte",$modulefiles,1))array_push($modulefiles, "isgw.lte");
						break;
					case  preg_match('/[124]t1e1/', $module)==1:
						$hasCas = $this->_checkCasMode($lifIndex);
						if($hasCas==2) {
							if(!in_array("isgw.cas",$modulefiles,1))array_push($modulefiles, 'isgw.cas');
							if(!in_array("isgw.isdn",$modulefiles,1))array_push($modulefiles, 'isgw.isdn');
						}
						else if($hasCas === 1 &&!in_array("isgw.cas",$modulefiles,1))array_push($modulefiles, "isgw.cas");
						else if(!in_array("isgw.isdn",$modulefiles,1))array_push($modulefiles, "isgw.isdn");
						break;
					case preg_match('/[12]GSM/', $module)==1:
						if(!in_array("isgw.gsm",$modulefiles,1))array_push($modulefiles, "isgw.gsm");

					default:
						break;
				}
			}
			return $modulefiles;
		}
		
		/**
		 * set all variables for export from the provided file
		 */
		private function _setConfigData(){
			if ($this->_getSectionByName('AppConfig')!==false) $this->_apps =true; 
			if (($config = $this->_getSectionByName('Config')) === false) {
				return (false);
			}

			//go over and set config section options
			foreach ($config as $cfg_section) {
				if (!is_array($cfg_section)) continue;
				foreach ($cfg_section as $cfg_file) {
					switch ($cfg_file['name']) {
						case 'File':
							$this->__setFileDataAndList($cfg_file,'_fileList');
							break;

						case 'PlainPassword':
							if($cfg_file['data'] ==='yes'|| $cfg_file['data'] ==='true') $this->_plainPassword =true;
							break;

						case 'Update':
							if($cfg_file['data'] == 'yes') $this->_provisionConfigUpdate = true;
							break;

						case 'Activate':
							$this->_provisionActivate = $cfg_file['data'];
							break;
	
						default:
							break;
					}
				}
			}
			//go over Certificates section
			$tls = $this->_getSectionByName('Certificates');

			if($tls !==false){				
			foreach ($tls as $tls_section) {
				if (!is_array($tls_section)) continue;
				foreach ($tls_section as $cfg_file) {
					//go over files
					$this->__setFileDataAndList($cfg_file,'_tlsCertFiles');
				}
			}}
		}

		/**
		 * adds file to $_fileData
		 *
		 * @param array file in config to add to $_fileData
		 * @param string $listToAdd string of variable name to specify to which array the names of the files set should be added via array_push()
		 * @return void
		 */
		private function __setFileDataAndList($fileSection,$listToAdd){
			if($fileSection['name']=='File'){
				foreach($fileSection['subsection'] as $index => $file){
							switch($file['name']) {
								case 'Name':
									array_push($this->$listToAdd, $file['data']);
									$this->_fileData[$this->_fileDataIndex]['name'] = $file['data'];	
									break;

								case 'Contents':	
									$this->_fileData[$this->_fileDataIndex]['data'] = $file['data'];	
									break;
							}
						}
				$this->_fileDataIndex++;
			}
		}

		/**
		 * generates \<File> sections
		 *
		 * @param array $confFiles array with files
		 * @param string $altPath alternative path to files, if not set $_configPath will be used
		 * @return string
		 */
		private function _exportFiles($confFiles,$altPath=null){
			unset($files);
			foreach ($confFiles as $confFile) {
				$filePath = ($altPath===null?$this->_configPath:$altPath) . '/'. $confFile;
				if (file_exists($filePath)) {
					$files .=	"\t\t" . '<File>' . "\n" .
						"\t\t\t" . '<Name>' .$confFile. '</Name>' . "\n" .
						"\t\t\t" . '<Contents>' . "\n" .
						file_get_contents($filePath) . "\n" .
						"\t\t\t" . '</Contents>' . "\n" .
						"\t\t" . '</File>' . "\n";
				}
				else {
					// has error. stop the export. alert customer
					$this->_error['has'] = true;
					$this->_error['whichOne'] = 2; // see modules/BackupRestore.php for the list of error codes
					$this->_error['more'] = $confFile;
					return(false);
				}
			}
			return $files;
		}

		/**
		 * generates <Config> section of backup file
		 *
		 * @param array $confFiles array of files to include in section
		 * @return string string with <Conf> section
		 */
		private function _exportGatewayConfig ($confFiles) {
			$files = $this->_exportFiles($confFiles);
			if (strlen($files)) {
				$ret =	"\t" . '<Config>' . "\n" .
				"\t\t" . '<PlainPassword>false</PlainPassword>' . "\n" .
				"\t\t" . '<Update>yes</Update>' . "\n" .
				"\t\t" . '<Activate>3</Activate>' . "\n" .
				$files .
				"\t" . '</Config>' . "\n";
				return($ret);
			}
			return(false);
		}

		/**
		 * generates <Certificates> section of backup file
		 *
		 * @param array $confFiles array of files to include in section
		 * @return string string with \<Certificates> section
		 */

		private function _exportTlsCertConfig(){
			$ret = '';
			if(count($this->_tlsCertFiles)!=0){
				$ret .= "\t".'<Certificates>'."\n";
				foreach ($this->_tlsCertFiles as $fileName => $file) {
					$ret .=	"\t\t" . '<File>' . "\n" .
							"\t\t\t" . '<Name>' .$fileName. '</Name>' . "\n" .
							"\t\t\t" . '<Contents>' . "\n" .
							file_get_contents($file) . "\n" .
							"\t\t\t" . '</Contents>' . "\n" .
							"\t\t" . '</File>' . "\n";
				}
					$ret .="\t".'</Certificates>'."\n";
			}
			return $ret;
		}

		private function _isBinary ($fileName, $maxLimit = 1024) {

			$size = filesize($fileName);
			$limit = ($size > $maxLimit) ? $maxLimit : $size;
			$data = file_get_contents($fileName, false, null, -1, $limit);

			// everything with char \0 is binary
			for ($i = 0; $i < $limit; $i++) {
				if ($data[$i] == "\0") {
					return(true);
				}
			}

			// XML-files are also handled as binary data
			if (strpos($data, '<?xml') !== false) {
				return(true);
			}

			return(false);
		}

		private function _getFileList ($dirName, &$dirArray) {

			$files = array_diff(scandir($dirName), array('.', '..'));
			if (empty($files)) {
				return;
			}

			foreach($files as $val) {
				$dirArray[$dirName][] = $val;
				if(is_dir($dirName . '/' . $val)) {
					$this->_getFileList($dirName . '/' . $val, $dirArray);
				}
			}
			@ksort($dirArray);
		}

		private function _getAppConfig () {

			$baseDir = '/usr/conf/userapp';

			if (!is_dir($baseDir)) {
				return(null);
			}

			$apps = array_diff(scandir($baseDir), array('.', '..'));

			$i = 0;
			foreach ($apps as $app) {

				// get config-files of app
				unset($appFiles);
				$this->_getFileList($baseDir . '/' . $app, $appFiles);
				if (empty($appFiles)) {
					continue;
				}

				// save all info in array
				$ret[$i]['name'] = $app;
				$j = 0;
				foreach ($appFiles as $key => $val) {

					foreach ($val as $item) {
						$filePath = $key . '/' . $item;
						$fileMode = $this->_isBinary($filePath);
						$ret[$i]['files'][$j]['name'] = strstr($filePath, $app);
						if (is_dir($filePath)) {
							$ret[$i]['files'][$j]['mode'] = 'directory';
							$j++;
							continue;
						}
						$ret[$i]['files'][$j]['mode'] = ($fileMode ? 'binary' : 'text');
						$contentRaw = file_get_contents($filePath);
						$ret[$i]['files'][$j]['content'] = ($fileMode ? base64_encode($contentRaw) : trim($contentRaw));
						unset($contentRaw);
						$j++;
					}
				}
				$i++;
			}

			return(empty($ret) ? null : $ret);
		}

		private function _exportAppConfig () {

			if (($apps = $this->_getAppConfig()) == null) {
				return('');
			}

			$ret =	"\t" . '<AppConfig>' . "\n";

			foreach ($apps as $app) {
				if (empty($app['files'])) {
					continue;
				}

				$ret .=	"\t\t" . '<App>' . "\n" .
					"\t\t\t" . '<Name>' . $app['name'] . '</Name>' . "\n";

				foreach ($app['files'] as $appFile) {
					$ret .= "\t\t\t" . '<File>' . "\n" .
						"\t\t\t\t" . '<Name>' . $appFile['name'] . '</Name>' . "\n" .
						"\t\t\t\t" . '<Mode>' . $appFile['mode'] . '</Mode>' . "\n" .
						(($appFile['mode'] == 'directory') ? '' :	"\t\t\t\t" . '<Content>' . "\n" .
												$appFile['content'] . "\n" .
												"\t\t\t\t" . '</Content>' . "\n") .
						"\t\t\t" . '</File>' . "\n";
				}
				$ret .= "\t\t" . '</App>' . "\n";
			}

			$ret .=	"\t" . '</AppConfig>' . "\n";

			return($ret);
		}

		private function _getSectionByName ($name) {

			if ($this->_xmlData == null) {
				return(false);
			}

			// check if this file is valid
			if ($this->_xmlData['name'] != 'beroNetProvisioning') {
				return(false);
			}

			// get the section with config-files
			foreach ($this->_xmlData['subsection'] as $section) {
				if ($section['name'] == $name) {
					return($section);
				}
			}

			return(false);
		}

		/**
		 * sets the file groups for the GUI based on files and modules present in the config and gateway
		 * if tooltip or groupname is a constant string, the constant value will be displayed, else the actual value will be displayed
		 */
		private function _setFileGroups(){
			$this->_fileGroupsTooltips = array(
			"BACKUP_RESTORE_CONFIG_GROUP_MISC_ISGW"		=>"BACKUP_RES_GROUP_MISC_ISGW",
			"BACKUP_RESTORE_CONFIG_GROUP_MISC"			=>"BACKUP_RES__GROUP_MISC",
			"BACKUP_RESTORE_CONFIG_GROUP_HARDWARE"		=>"BACKUP_RES_GROUP_HARDWARE",
			"BACKUP_RESTORE_CONFIG_GROUP_DIALPLAN"		=>"BACKUP_RES_GROUP_DIALPLAN",
			"BACKUP_RESTORE_CONFIG_GROUP_VOIP"			=>"BACKUP_RES_GROUP_VOIP",
			"BACKUP_RESTORE_CONFIG_GROUP_ACL"			=>"BACKUP_RES_GROUP_ACL",
			);

			$this->_fileGroups = array(
				"BACKUP_RESTORE_CONFIG_GROUP_MISC_ISGW"		=>array('isgw.causes','isgw.cpt'),
				"BACKUP_RESTORE_CONFIG_GROUP_MISC"			=>array('isgw.conf','misc.conf','apiusers.conf'),
				"BACKUP_RESTORE_CONFIG_GROUP_HARDWARE"		=> 'hardware.conf',
				"BACKUP_RESTORE_CONFIG_GROUP_DIALPLAN"		=> 'isgw.dialplan',
				"BACKUP_RESTORE_CONFIG_GROUP_VOIP"			=> 'isgw.sip',
				"BACKUP_RESTORE_CONFIG_GROUP_ACL"			=>array('isgw.whitelist','network.acl'),
			);
			//remove groups that are not in imported file
			foreach ($this->_fileGroups as $group => $files) {
				if (is_array($files)) {
					foreach ($files as  $key =>$file) {
						if(!in_array($file,$this->_fileList)) unset($files[$key]);
					}
					if(!$files) unset($this->_fileGroups[$group]);
				} else {
					if(!in_array($files,$this->_fileList)) unset($this->_fileGroups[$group]);
				}
			}
			$this->_fileGroupsTooltips =array_intersect_key($this->_fileGroupsTooltips,$this->_fileGroups);
			//add module configs; remove <isgw.> part of filename and add to _fileGroups
			foreach ($this->_fileList as $key => $fileName) {
				if(preg_match('/isgw\.(analog|isdn|gsm|cas|lte)/',$fileName) ==1) {
					$isgwName =strtoupper(str_replace('isgw.','',$fileName));
					$this->_fileGroups 			+= array($isgwName=>$fileName);
					$this->_fileGroupsTooltips 	+= array($isgwName=>"BACKUP_RESTORE_GROUP_MODULE");
				}
			}
		}

		/**
		 * Sets all other option- and Sectiongroups needed
		 * The format of the array should be:
		 * sectionGroups= array({groupname}=>array({value used in import/export},{tooltip}))
		 * @return void
		 */
		private function _setSectionGroups(){
			if($this->_apps==true)				$this->_sectionGroups += array("BACKUP_RESTORE_CONFIG_GROUP_APPS" => array('appConfig',"BACKUP_RES_GROUP_APPS"));
			if(count($this->_tlsCertFiles)>0)	$this->_sectionGroups += array("BACKUP_RESTORE_CONFIG_GROUP_TLS"  => array('tls',"BACKUP_RES_GROUP_TLS"));
		}

		/**
		 * converts the filegroups to the corresponding files
		 * @param array  filegroups to convert
		 */
		public function fileGroupsToFiles($groups){
			$filesToImport = array();
			if(is_array($groups)) $filelist =array_intersect_key($this->_fileGroups, $groups);
			else $filelist = array_intersect_key($this->_fileGroups, array($groups));
			foreach ($filelist as $files) {
				if (is_array($files)){
					foreach ($files as $file) {
						array_push($filesToImport,$file);
					}
				}
				else array_push($filesToImport,$files);
			}
			return $filesToImport;
		}

		/**
		 * generates a configfile with current device settings
		 * @param array the configfiles to be included in backup. If not set, then all configfiles will be exported 
		 * @param array array with other options for exporting, set by  $_sectionGroups. if null, the full config will be exported
		 * @return string the configfile
		 */
		public function exportConfig ($configs=NULL,$options=null) {
			if ($configs === NULL) $configs = $this->_fileList;
			else $configs = array_intersect($this->_fileList,$configs);

			$cfgApp = '';
			$cfgTls = '';
			$cfgFiles = $this->_exportGatewayConfig($configs);
			if($options['appConfig']==true|| $options ==null) $cfgApp = $this->_exportAppConfig();
			if($options['tls']==true||$options==null) $cfgTls = $this->_exportTlsCertConfig();

			if (strlen($cfgFiles) || strlen($cfgApp) || strlen($cfgTls)) {
				return('<?xml version="1.0"?>' ."\n".
				'<beroNetProvisioning>' ."\n".
				"\t" . '<!-- Created on ' . date('c') . ' -->' ."\n".
				$cfgFiles.$cfgApp.$cfgTls ."\n".
				'</beroNetProvisioning>' ."\n");
			}
			return(false);
		}

		/**
		 *  imports configfiles specified with param <code>$configfiles</code> and encrypts password if set
		 * @param  array $name Array of the configfiles to be imported
		 * @return array|bool on success: array with information about success=>['info'] and failure=>['warning'] of the file import
		 */
		public function importConfigFiles($configFiles=null, $configPath =null){
			if ($configFiles ===false) return(false);
			if($configPath ===null) $configPath = $this->_configPath;
			if($configFiles ===null) $configFiles = $this->getConfigFiles();
			// create backup-directory
			if (!is_dir($this->_configPath . 'backup')) {
				rootHelper::mkdir(0, "{$this->_configPath}/backup");
			}
			// go over each configFile
			foreach ($configFiles as $key=> $configFile) {
				//if Plain Password set to true, then encrypt that password
				if ($configFile['name']=='misc.conf' &&$this->_plainPassword==true){
					include_once('/usr/local/www/berogui/includes/password_func.php');
					if (preg_match('/admin-pass=(.+)/',$configFile['data'],$encode)==1){
						$encode = tep_encrypt_password($encode[1]);
						$configFile['data']=preg_replace("/admin-pass=.*/",'admin-pass='.$encode,$configFile['data']);
					}
				}
				// create backup of file
				rootHelper::copy(0, "{$configPath}/{$configFile['name']}", "{$this->_configPath}/backup/{$configFile['name']}");
				rootHelper::unlink(0, "{$configPath}/{$configFile['name']}");

				// write file
				if (!($FP = fopen("{$configPath}/{$configFile['name']}", 'w'))) {
					$log['warning'][$key]='could_not_write'. $configFile['name'];
					rootHelper::copy(0, "{$this->_configPath}/backup/{$configFile['name']}", "{$configPath}/{$configFile['name']}");
					continue;
				}

				fwrite($FP, $configFile['data'], strlen($configFile['data']));
				fclose($FP);
				$FP = null;
				$log['info'][$key]=('updated'.$configFile['name']);

			}
			return $log;
		}

		/**
		 * Imports a config file, if @params are null, full config file will be imported
		 *
		 * @param array Filegroups to import
		 * @param array  optionGroups to import
		 * @return array|bool
		 */
		##TODO use the function for all import related tasks (cloud sbc, provisioning,API), which would reduce code and make changes easier && a few functions could be made private then
		##TODO merge app import here as well, from provisioning and upload.php
		##TODO logging improvements
		public function import($configFiles=null,$configOptions=null){
			if($configFiles !==null && count($configFiles)>0)$configFiles = $this->fileGroupsToFiles($configFiles);
			//imports tls certificate files
			if($configOptions['tls']==true||($configOptions===null && count($this->_tlsCertFiles)>0)){
				$certFiles=$this->getConfigFiles($this->_tlsCertFiles);
				foreach($certFiles as $key => $certFile){
					$tlsFiles = rootHelper::tlsGetCertificate();
					$certFiles[$key]['name'] = $tlsFiles[$certFiles[$key]['name']];
				}
				$ret =$this->importConfigFiles($certFiles,'');
			}
			//imports config files
			if(count($configFiles)>0 || $configFiles ===null){
				$configFiles= $this->getConfigFiles($configFiles);
				$ret=$this->importConfigFiles($configFiles);
			}
			return $ret;
		}

		/**
		 * returns data of configFiles specified with <code>configsToGet</code>, only returns configfiles present in _fileList
		 * @param array list with names of files to get. if not set, all files will be returned
		 * @return array|bool
		 */
		##TODO can be made private and auto used when the cloud SBC & API uses the import function instead of writing the files itself
		public function getConfigFiles ($configsToGet =null) {
			$return = array();
			if($configsToGet ===null) return((count($this->_fileData) > 0) ? $this->_fileData : false);
			else{
				foreach( $this->_fileData as $file){
					if(in_array($file['name'],$configsToGet)) array_push($return,$file);
				}
				return((count($return) > 0) ? $return : false);
			}
		}

		public function getConfigActivate () {
			return $this->_provisionActivate;
		}

		/**
		 * returns true if <code><update></code> in the config is set to yes, else return false
		 */
		public function getConfigEnabled ($section) {
			return $this->_provisionConfigUpdate;
		}

		/**
		 *
		 * @return array returns a list of groups for configfiles with the key as the groupname and the value as the tooltip
		 */
		public function getFileGroups(){
			return $this->_fileGroupsTooltips;
		}

		/**
		 *
		 * @return array returns a list of groups for various import options, with the key as the groupname and an array as value, 
		 * 				 with value[0]=optionName and value[1]=tooltip
		 */
		public function getSectionGroups(){
			return $this->_sectionGroups;
		}

		public function getAppConfigFiles () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($apps = $this->_getSectionByName('AppConfig')) === false) {
				return(false);
			}

			foreach ($apps as $app) {
				if (!is_array($app)) {
					continue;
				}

				$i = 0;
				foreach ($app as $appConfig) {
					$j = 0;
					foreach ($appConfig['subsection'] as $appConfigSub) {
						if ($appConfigSub['name'] == 'Name') {
							$ret[$i]['name'] = $appConfigSub['data'];
						}

						if (!is_array($appConfigSub['subsection'])) {
							continue;
						}

						foreach ($appConfigSub['subsection'] as $confFileAttr) {
							switch ($confFileAttr['name']) {
							case 'Name':	$ret[$i]['files'][$j]['name'] = $confFileAttr['data'];		break;
							case 'Mode':	$ret[$i]['files'][$j]['mode'] = $confFileAttr['data'];		break;
							case 'Content':	$ret[$i]['files'][$j]['content'] = $confFileAttr['data'];	break;
							}
						}
						$j++;
					}

					$i++;
				}
			}

			return((count($ret) > 0) ? $ret : false);
		}

		public function getFirmwareInstallInfo () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($attributes = $this->_getSectionByName('Firmware')) === false) {
				return(false);
			}

			unset($ret);
			foreach ($attributes['subsection'] as $attribute) {
				switch ($attribute['name']) {
				case 'Install':	 $ret['install'] = $attribute['data'];	break;
				case 'Filename': $ret['package'] = $attribute['data'];	break;
				case 'Url':      $ret['url'] = $attribute['data']; break;
				}
			}

			return(isset($ret) ? $ret : false);
		}

		public function getAppInstallInfo () {

			if ($this->_xmlData == null) {
				return(false);
			}

			if (($apps = $this->_getSectionByName('Apps')) === false) {
				return(false);
			}

			unset($ret);
			$i = 0;
			foreach ($apps['subsection'] as $app) {
				if (!is_array($app)) {
					continue;
				}

				foreach ($app['subsection'] as $app_attr) {
					switch ($app_attr['name']) {
					case 'Install':		$ret[$i]['install'] = $app_attr['data'];	break;
					case 'Filename':	$ret[$i]['package'] = $app_attr['data'];	break;
					}
				}
				$i++;
			}

			return($ret);
		}

	}

} /* _CONFIGEXPORTIMPORTTOOL_CLASS */

?>
