<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class CFQuery extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {
		//sanitize
		$this->_allowedParameters += array(
			'Port'             => 'int-range',
			'ServedUserNumber' => 'phone-char',
		);
		$this->_sanitizeOptions = array('Port' => array('min' => 1, 'max' => 12));
		if ($this->sanitizeInputs() == false) return $this->_execResult;

		if (!isset($this->_parameters['Port']) || !isset($this->_parameters['ServedUserNumber'])) {
			$this->_execResultString = 'error:missing_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$cfquery_cmd = "cfquery:" . $this->_parameters['Port'] . ":" . $this->_parameters['ServedUserNumber'];
		
		$isgw = new isgwtelnet();
		if (!($result = $isgw->isgw_login())) {
		    $this->_execResultString = 'error:login_failed;';
		    $this->_execResult = false;
		    $this->_execResponseCode = 500;
		    return($this->_execResult);
		}
		
		$this->_execResultString .= "\n" . trim($isgw->Query($cfquery_cmd));
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>