<?php
require_once ("/usr/local/php/include/apiCall.class.php");
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');

class NetworkGetConfiguration extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		$bc = new beroConf('root');

		foreach (array('lan-dhcp', 'lan-ipaddr', 'lan-netmask', 'lan-gateway', 'lan-nameserver', 'lan-mtu') as $lanSetting) {
			$result[$lanSetting] = $bc->get('root', $lanSetting);
		}

		$this->_execResultString .=	':Dhcp:' . (!empty($result['lan-dhcp']) ? $result['lan-dhcp'] : '0') . ';' .
						(!empty($result['lan-ipaddr']) ? 'IpAddress:' . $result['lan-ipaddr'] . ';' : '') .
						(!empty($result['lan-netmask']) ? 'NetMask:' . $result['lan-netmask'] . ';' : '') .
						(!empty($result['lan-gateway']) ? 'GateWay:' . $result['lan-gateway'] . ';' : '') .
						(!empty($result['lan-nameserver']) ? 'NameServer:' . $result['lan-nameserver'] . ';' : '') .
						(!empty($result['lan-mtu']) ? 'MtuSize:' . $result['lan-mtu'] . ';' : '');
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>