<?php
require_once ("/usr/local/php/include/apiCall.class.php");
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');

class NetworkSetmDNS extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		if (!isset($this->_parameters['Mode']) || !in_array($this->_parameters['Mode'], array('enabled', 'disabled'))) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$bc = new beroConf('root');

		switch ($this->_parameters['Mode']) {
		case 'enabled':
			$bc->set('root', 'beroAvahi-enabled', '1');
			@exec('/usr/local/init/S90beroAvahi start');
			break;
		case 'disabled':
			@exec('/usr/local/init/S90beroAvahi stop');
			$bc->set('root', 'beroAvahi-enabled', '0');
			break;
		}

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>