<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/php/include/shortMessageService.Class.php');

class SmsListMessages extends apiCall {

	private $_sms;

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
		$this->_sms = new ShortMessageService();
	}
	
	function execute () {

		if (!isset($this->_parameters['SmsQueue'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$this->_execResultString .= ':' . $this->_parameters['SmsQueue'] . ':';

		$messages = $this->_sms->listMessages($this->_parameters['SmsQueue']);
		if (($messages == null) || (count($messages) == 0)) {
			$this->_execResultString .= 'empty_queue;';
			return($this->_execResult);
		}


		foreach ($messages as $message) {
			$this->_execResultString .= $message . ';';
		}

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>