#!/bin/bash
#
# VERSION=3
# CHANGES="beroconf is now part of rootfs"

BEROCONF=/usr/fallback/beroconf

APPS_HOME=/home/admin
APPS_ROOT=/apps

PKG_NAME=${1}
PKG_UPDT=${2}

PKG_PATH=${APPS_ROOT}/${PKG_NAME}

PREFIX="[userappfs_uninstall]"

logmode=$(${BEROCONF} get root userapp-logmode | grep -v failed)

if [ "${logmode}" = "1" ]; then
	echo "${PREFIX} logmode enabled, leaving."
	exit 0
fi

if [ -z "${PKG_NAME}" ]; then
	echo "${PREFIX} FAIL: package name empty, leaving."
	exit 1
fi

if [ ! -d "${PKG_PATH}" ]; then
	echo "${PREFIX} FAIL: package is not installed, leaving."
	exit 1
fi

echo "${PREFIX} stopping userapp-services"
/etc/init.d/S91userapp stop > /dev/null

mount -oremount,rw ${APPS_HOME} || exit 1

if [ -x ${APPS_HOME}/setup/pre_remove.sh ]; then
	echo "${PREFIX}: running pre_remove-script for package ${PKG_NAME}."
	${APPS_HOME}/setup/pre_remove.sh ${PKG_NAME} ${PKG_UPDT}
fi

echo "${PREFIX} removing ${PKG_PATH}."
rm -rf ${PKG_PATH}

echo "${PREFIX} updating PATH-variable in .bash_profile."
for i in $(ls ${APPS_ROOT}/); do
	path_str_bin="${path_str}:${APPS_ROOT}/${i}/bin"
	path_str_lib="${path_str}:${APPS_ROOT}/${i}/lib"
done
path_str_bin=$(echo ${path_str_bin} | sed -e 's/\([[\/.*]\|\]\)/\\&/g')
path_str_lib=$(echo ${path_str_lib} | sed -e 's/\([[\/.*]\|\]\)/\\&/g')
sed "s/APPS_PATHS/${path_str_bin}/g" ${APPS_HOME}/bash_profile_skel > /tmp/admin_bash_profile.tmp
sed "s/LIBS_PATHS/${path_str_lib}/g" /tmp/admin_bash_profile.tmp > ${APPS_HOME}/.bash_profile
rm -f /tmp/admin_bash_profile.tmp
chown admin:admin ${APPS_HOME}/.bash_profile

echo "${PREFIX} waiting and syncing"
sleep 1; sync; sync; sleep 1

mount -oremount,ro ${APPS_HOME} || exit 1

echo "${PREFIX} starting userapp-services"
/etc/init.d/S91userapp start > /dev/null
