<?php

/**
 * Implementiert die beroCloud und SNMP Einstellungen
 * @author Miguel Palmer <mp@beronet.com>
 */
include_once ('/usr/www/include/SQLite2ToSQLite3.php');
class RemoteManagement {
	private $m_attr;
	private $post_attr,
			$post_checked = 0;
	private $isRequestRejected = 0,
			$reasonRejected = array ();
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		
		$this->m_attr = $m;
		
		$this->trap_array = array (
				"sip_validation",
				"sip_registration",
				"isdn_layer1",
				"isdn_layer2",
				"isdn_crc",
				"memory_threshold",
				"cpu_load"
		);
			
			// TODO: maybe set a checkor for an user input instead the 'config-option' checkor
		if (isset ($post ['submit'])) {
			unset ($post ['m'], $post ['fixChrome'], $post ['dummy'], $post ['submit']);
			
			$list_post = array (
					// SNMP
					'snmp_enabled' => 'bool',
					'snmp_traps_enable' => 'bool',
					'snmp_syslocation' => 'comment',

					'snmp_community_rw' => 'snmp',
					'snmp_community_ro' => 'snmp',
					
					'snmp_version' => 'group-name',
					'snmp_ro_user' => 'group-name',
					'snmp_ro_auth_password' => 'password',
					'snmp_ro_encrypt_password' => 'password',
					'snmp_server_key' => 'special-char',
					'snmp_server_cert' => 'special-char',
					'snmp_client_cert' => 'special-char',
					'snmp_security_level' => 'alphanumeric',
					'snmp_auth_method' => 'alphanumeric',
					'snmp_encrypt_method' => 'alphanumeric',
					
					'snmptraps_community' => 'snmp',
					'snmptraps_user' => 'alphanumeric',
					'snmptraps_server' => 'url',

					'snmptraps_auth_password' => 'password',
					'snmptraps_encrypt_password' => 'password',
					
					'snmptraps_auth_method' => 'alphanumeric',
					'snmptraps_encrypt_method' => 'alphanumeric',
					'snmptraps_security_level' => 'alphanumeric',
					
					'snmptraps_interval' => 'int>=0',
					'snmptraps_isdn_layer1' => 'bool',
					'snmptraps_isdn_layer2' => 'bool',
					'snmptraps_isdn_crc' => 'bool',
					'snmptraps_isdn_crc_value' => 'int>0',
					'snmptraps_sip_validation' => 'bool',
					'snmptraps_sip_registration' => 'bool',
					'snmptraps_cpu_load' => 'bool',
					'snmptraps_cpu_load_value' => 'int>0',
					'snmptraps_memory_threshold' => 'bool',
					'snmptraps_memory_threshold_value' => 'int>=0',
					
					'cb_snmptraps_enabled' => 'bool',
					'cb_snmpserver_enabled' => 'bool' 
			);
			
			$list_post_options = array (
					'snmptraps' => array (
							'snmptrap_isdnl2',
							'snmptrap_isdn_crc_increase',
							'snmptrap_sip_register_events',
							'snmptrap_system_memory_threshold',
							'snmptrap_system_cpu_load' 
					) 
			);
			
			$this->post_checked = 1;
			$this->post_attr = Helper::sanitizePost ($post, $list_post, $this->post_checked, $this->reasonRejected, $list_post_options);
// 			print_r($this->reasonRejected);
			$this->isRequestRejected = ! $this->post_checked;
		}
	}

		/*
	 * @return string HTML code
	 */
	function _display_tabs($bc) {
		$tabs = "\t\t" . '<li><a href="#tabs-1">' . SNMP_TABLE_HEADER_DIS . '</a></li>' . "\n";
		$tabs .= "\t\t" . '<li><a href="#tabs-2">' . "SNMP Server" . '</a></li>' . "\n";
		$tabs .= "\t\t" . '<li><a href="#tabs-3">' . "SNMP Traps" . '</a></li>' . "\n";
		
		$display_tabs = "<form id='snmp' action='' method='POST' class=\"form-horizontal\" ENCTYPE=\"multipart/form-data\">";
		$display_tabs .= $this->_display_tab1 ($bc) . "\n";
		$display_tabs .= $this->_display_tab2 ($bc) . "\n";
		$display_tabs .= $this->_display_tab3 ($bc) . "\n";
		$display_tabs .= "<div class=\"text-center\" >";
		$display_tabs .= "<input name='submit' class='btn btn-default' type='submit' value='" . BUTTON_SAVE . "'>";
		$display_tabs .= "</div>";
		$display_tabs .= "<div class='text-center' style='margin-top:10px;'><i>" . REQUIRED_FIELDS . "</i></div>\n";
		$display_tabs .= "</form>";
	
		$html_str = '<br/>' . "\n" . '<br/>' . "\n" . '<script>' . "\n" . "\t" . '$(function() {' . "\n" . "\t\t" . '$( "#tabs" ).tabs({active:0})' . "\n" . "\t" . '});' . "\n" . '</script>' . "\n" . "\n\n" . '<!-- BEGIN TABS //-->' . "\n\n" . '<div id="tabs" class="">' . "\n" . "\t" . '<ul>' . "\n";
		$html_str .= $tabs . "\t" . '</ul>' . "\n\n" . $display_tabs . "\n\n" . '<!-- END TABS //-->' . "\n" . '</div>' . "\n\n";
		
		return $html_str;
	}

	/*
	 * @return string HTML code
	 */
	function _display_tab1($bc) {
		$html_str = "\n\n" . '<!-- BEGIN TAB1 //-->' . "\n\n" . '<div id="tabs-1" style="margin-top: 20px;">' . "\n";
		
		$html_str .= $this->snmpTableGeneral ($bc) . "\n" . "<br>\n" . "<div class='text-center'>\n" . "</div>\n";
		
		if (is_file ("/usr/local/conf/BEROFIX-MIB.txt")) {
			$html_str .= "<hr><div class=\"text-center\" > <a href=\"misc/files_download.php?option=BEROFIX-MIB\">Download BEROFIX-MIB</a></div>";
		}

		$html_str .= '</div>' . "\n";
		
		return $html_str;
	}

	function _display_tab2($bc) {
		$html_str = "\n\n" . '<!-- BEGIN TAB2 //-->' . "\n\n" . '<div id="tabs-2" style="margin-top: 20px;">' . "\n";
		
		$html_str .= $this->snmpTable ($bc) . "\n" . "<br>\n" . "<div class='text-center'>\n" . "</div>\n";
		
		$html_str .= '</div>' . "\n";
		
		return $html_str;
	}

	function _display_tab3($bc) {
		$html_str = "\n\n" . '<!-- BEGIN TAB3 //-->' . "\n\n" . '<div id="tabs-3" style="margin-top: 20px;">' . "\n";
		
		$html_str .= $this->snmpTrapTable ($bc) . "\n" . "<br>\n" . "<div class='text-center'>\n" . "</div>\n";
		
		$html_str .= '</div>' . "\n";
		
		return $html_str;
	}

	/**
	 * Generiert die HTML Seite
	 *
	 * @return string HTML code
	 */
	function display() {
		$m = $this->m_attr;
		$name = "REMOTE_MANAGEMENT_TITLE_DIS";
		include ('./includes/header.php');
		
		$ba = new beroAri ();
		require_once ("./includes/lang.php");

		require_once ('/usr/fallback/beroConf.php');
		$bc = new beroConf ('root');

		// Save the changes
		if ($this->post_checked) {
			$ret .= $this->upload_certificate ($ba, $_FILES);
			$ret .= $this->save ($ba, $bc);
		}
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage ($this->reasonRejected ['request'], $this->reasonRejected ['checkor'], $this->reasonRejected ['key']);
		}
		
		$ret .= $this->_display_tabs ($bc);
		$ret .= $this->javascript ();
		return $ret;
	}

	function snmp_version($bc) {
		$snmp_version = $bc->get ("root", "snmp-version");
		$snmpv2_selected = "";
		$snmpv3_usm_selected = "";
		$snmpv3_tsm_selected = "";
		
		if ($snmp_version == "SNMPv3_usm") {
			$snmpv3_usm_selected = "selected";
		}
		else if ($snmp_version == "SNMPv3_tsm") {
			$snmpv3_tsm_selected = "selected";
		}
		else if ($snmp_version == "SNMPv2") {
			$snmpv2_selected = "selected";
		}
		else {
			$snmpv_disabled_selected = "selected";
		}
		ob_start ();
		?>
<select class='form-control input-sm' name='snmp_version'
	id='snmp_version' onchange='snmp_show();'>
	<option name='snmp_version' id='snmp_version_disabled' value='Disabled'
		<?php echo $snmpv_disabled_selected; ?>>Disabled</option>
	<option name='snmp_version' id='snmp_version2' value='SNMPv2'
		<?php echo $snmpv2_selected; ?>>SNMP v2</option>
	<option name='snmp_version' id='snmp_version3_usm' value='SNMPv3_usm'
		<?php echo $snmpv3_usm_selected; ?>>SNMP v3 USM/UDP</option>
	<option name='snmp_version' id='snmp_version3_tsm' value='SNMPv3_tsm'
		<?php echo $snmpv3_tsm_selected; ?>>SNMP v3 TSM/TLS</option>
</select>
<?php
		return ob_get_clean ();
	}

	function snmp_security_level($bc, $trap = 0) {
		$prefix = "snmp";
		if ($trap) {
			$prefix = "snmptraps";
		}
		
		if ($trap) {
			$snmp_security_level = $bc->get ("root", $prefix . "_security_level");
		}
		else {
			$snmp_security_level = $bc->get ("root", $prefix . "-security-level");
		}
		
		$auth_priv_selected = "";
		$auth_no_priv_selected = "";
		$no_auth_no_priv_selected = "";
		
		if ($snmp_security_level == "NoAuthNoPriv") {
			$no_auth_no_priv_selected = "selected";
		}
		else if ($snmp_security_level == "AuthNoPriv") {
			$auth_no_priv_selected = "selected";
		}
		else {
			$auth_priv_selected = "selected";
		}
		
		ob_start ();
		?>
<select class='form-control input-sm'
	name='<?php echo $prefix; ?>_security_level'
	id='<?php echo $prefix; ?>_security_level'>
	<option name='<?php echo $prefix; ?>_security_level'
		id='<?php echo $prefix; ?>_security_level_no_auth_no_priv'
		value='NoAuthNoPriv' <?php echo $no_auth_no_priv_selected; ?>>
		NoAuthNoPriv</option>
	<option name='<?php echo $prefix; ?>_security_level'
		id='<?php echo $prefix; ?>_security_level_auth_no_priv'
		value='AuthNoPriv' <?php echo $auth_no_priv_selected; ?>>AuthNoPriv</option>
	<option name='<?php echo $prefix; ?>_security_level'
		id='<?php echo $prefix; ?>_security_level_auth_priv' value='AuthPriv'
		<?php echo $auth_priv_selected; ?>>AuthPriv</option>
</select>
<?php
		return ob_get_clean ();
	}

	function snmp_auth_method($bc, $trap = 0) {
		$prefix = "snmp";
		$dbvalue = "snmp-auth-method";
		if ($trap) {
			$prefix = "snmptraps";
			$dbvalue = "snmptraps_auth_method";
		}
		
		$snmp_auth_method = $bc->get ("root", $dbvalue);
		$md5_selected = "";
		$sha_selected = "";
		
		if ($snmp_auth_method == "SHA") {
			$sha_selected = "selected";
		}
		else {
			$md5_selected = "selected";
		}
		
		ob_start ();
		?>
<select class='form-control input-sm'
	name='<?php echo $prefix; ?>_auth_method'
	id='<?php echo $prefix; ?>_auth_method'>
	<option name='<?php echo $prefix; ?>_auth_method'
		id='<?php echo $prefix; ?>_auth_method_md5' value='MD5'
		<?php echo $md5_selected; ?>>MD5</option>
	<option name='<?php echo $prefix; ?>_auth_method'
		id='<?php echo $prefix; ?>_auth_method_sha' value='SHA'
		<?php echo $sha_selected; ?>>SHA</option>
</select>
<?php
		return ob_get_clean ();
	}

	function snmp_encrypt_method($bc, $trap = 0) {
		$prefix = "snmp";
		$dbvalue = "snmp-encrypt-method";
		if ($trap) {
			$prefix = "snmptraps";
			$dbvalue = "snmptraps_encrypt_method";
		}
		$snmp_encrypt_method = $bc->get ("root", $dbvalue);
		
		$aes_selected = "";
		$des_selected = "";
		
		if ($snmp_encrypt_method == "DES") {
			$des_selected = "selected";
		}
		else {
			$aes_selected = "selected";
		}
		
		ob_start ();
		?>
<select class='form-control input-sm'
	name='<?php echo $prefix; ?>_encrypt_method'
	id='<?php echo $prefix; ?>_encrypt_method'>
	<option name='<?php echo $prefix; ?>_encrypt_method'
		id='<?php echo $prefix; ?>_encrypt_method_aes' value='AES'
		<?php echo $aes_selected; ?>>AES</option>
	<option name='<?php echo $prefix; ?>_encrypt_method'
		id='<?php echo $prefix; ?>_encrypt_method_des' value='DES'
		<?php echo $des_selected; ?>>DES</option>
</select>
<?php
		return ob_get_clean ();
	}

	/**
	 *
	 * @return string Textfeld SNMP Syslocation
	 */
	function snmp_syslocation($bc) {
		$snmp_syslocation = $bc->get ('root', 'snmp-syslocation');
		ob_start ();
		?>
<input type="text" class="form-control input-sm" name="snmp_syslocation" value="<?php echo $snmp_syslocation ?>" maxlength="255">
<?php
		return ob_get_clean ();
	}

	/**
	 *
	 * @return string Textfeld SNMP community ro
	 */
	function ro_community($bc) {
		$ro_community = $bc->get ("root", "snmp-community-ro");
		ob_start ();
		?>
<input type='text' class='form-control input-sm' name='snmp_community_ro' value='<?php echo $ro_community ?>'>
<?php
		return ob_get_clean ();
	}

	/**
	 *
	 * @return string Textfeld SNMP community rw
	 */
	function rw_community($bc) {
		$rw_community = $bc->get ("root", "snmp-community-rw");
		ob_start ();
		?>
<input type='text' class='form-control input-sm'
	name='snmp_community_rw' value='<?php echo $rw_community ?>'>
<?php
		return ob_get_clean ();
	}

	function snmp_ro_user($bc) {
		$snmp_ro_user = $bc->get ("root", "snmp-ro-user");
		ob_start ();
		?>
<input type='text' class='form-control input-sm' name='snmp_ro_user'
	value='<?php echo $snmp_ro_user ?>'>
<?php
		return ob_get_clean ();
	}

	function snmp_ro_auth_password($bc, $prefix) {
		if ($prefix == "snmptraps") {
			$snmp_ro_auth_password = $bc->get ("root", "snmptraps_auth_password");
		}
		else {
			$snmp_ro_auth_password = $bc->get ("root", "snmp-ro-auth-password");
		}
		ob_start ();
		?>
<input type='password' class='form-control input-sm'
	name='<?php echo $prefix?>_auth_password'
	value='<?php echo $snmp_ro_auth_password; ?>'>
<?php
		return ob_get_clean ();
	}

	function snmp_ro_encrypt_password($bc, $prefix) {
		if ($prefix == "snmptraps") {
			$snmp_ro_encrypt_password = $bc->get ("root", "snmptraps_encrypt_password");
		}
		else {
			$snmp_ro_encrypt_password = $bc->get ("root", "snmp-ro-encrypt-password");
		}
		ob_start ();
		?>
<input type='password' class='form-control input-sm'
	name='<?php echo $prefix?>_encrypt_password'
	value='<?php echo $snmp_ro_encrypt_password; ?>'>
<?php
		return ob_get_clean ();
	}

	function snmptraps_checkbox_enable_server_page($bc) {
		$snmptraps = $bc->get ("root", "snmpserver_enabled");
		$snmptraps == "1" ? $checked = "checked" : $checked = "";
		
		ob_start ();
		?>
<input type='checkbox' id='cb_snmpserver_enabled' value='1' name='cb_snmpserver_enabled' <?php echo $checked ?> onchange='snmp_show();'>
<?php
		return ob_get_clean ();
	}

	/**
	 *
	 * @return string Checkbox Enable SNMP traps
	 */
	function snmptraps_checkbox_enable_trap_page($bc) {
		$snmptraps = $bc->get ("root", "snmptraps_enabled");
		$snmptraps == "1" ? $checked = "checked" : $checked = "";
		
		ob_start ();
		?>
<input type='checkbox' id='cb_snmptraps_enabled' name='cb_snmptraps_enabled' value='1' <?php echo $checked ?> onchange='snmp_show();'>
<?php
		return ob_get_clean ();
	}

	function snmptraps_trap_text_field ($bc, $trap_type, $default) {
		$snmptraps_value = $bc->get ("root", "snmptraps_" . $trap_type);
		if (strlen ($snmptraps_value) == 0) {
			$snmptraps_value = $default;
		}
		ob_start ();
		?>
			<br><input type='text' class='form-control input-sm' id='snmptraps_<?php echo $trap_type ?>_value' name='snmptraps_<?php echo $trap_type ?>_value' value='<?php echo $snmptraps_value ?>'>
<?php
		return ob_get_clean ();
	}
	

	function snmptraps_checkbox_enable_trap_item($bc, $trap_type) {
		$snmptraps = $bc->get ("root", "snmptraps_traplist");
		$snmptraps = explode (",", $snmptraps);
		$checked = (in_array ($trap_type, $snmptraps)) ? "checked" : "";
		ob_start ();
		?>
			<input type='checkbox' name='snmptraps_<?php echo $trap_type; ?>' id='snmptraps_<?php echo $trap_type; ?>' value='1' <?php echo $checked ?> onchange='snmp_show();'>
<?php
		return ob_get_clean ();
	}

	/**
	 *
	 * @return string Textfeld SNMP traps server
	 */
	function snmptraps_server($bc) {
		$snmptraps_server = $bc->get ("root", "snmptraps_server");
		ob_start ();
		?>
<input type='text' class='form-control input-sm' id='snmptraps_server' name='snmptraps_server' value='<?php echo $snmptraps_server ?>'>
<?php
		return ob_get_clean ();
	}

	/**
	 *
	 * @return string Textfeld SNMP community trap
	 */
	function snmp_v2_community_trap($bc) {
		$community_trap = $bc->get ("root", "snmptraps_community");
		ob_start ();
		?>
<input type='text' class='form-control input-sm' name='snmptraps_community' value='<?php echo $community_trap ?>'>
<?php
		return ob_get_clean ();
	}

	/**
	 *
	 * @return string Textfeld SNMP traps intervall
	 */
	function snmptraps_interval($bc) {
		$snmptraps_interval = $bc->get ("root", "snmptraps_interval");
		if ($snmptraps_interval == "") {
			$snmptraps_interval = 60;
		}
		ob_start ();
		?>
<input type='text' class='form-control input-sm' name='snmptraps_interval' value='<?php echo $snmptraps_interval ?>'>
<?php
		return ob_get_clean ();
	}

	function snmptraps_user($bc) {
		$snmp_trap_user = $bc->get ("root", "snmptraps_user");
		ob_start ();
		?>
<input type='text' class='form-control input-sm' name='snmptraps_user' value='<?php echo $snmp_trap_user ?>'>
<?php
		return ob_get_clean ();
	}

	/**
	 * Generates the javascript code
	 * 
	 * @return string
	 */
	function javascript() {
		ob_start ();
		?>
<script type="text/javascript">
		    $(document).ready(function () {
		        snmp_show();
		    });
			
			function snmp_update_trap_items() {
			
				if ($('#cb_snmptraps_enabled').is(':checked')) {
					$('#fg_snmptraps_server').show();
					$('#snmptraps_server').show();
					
					$('#fg_snmp_trap_list').show();
					
					if ($('#snmptraps_memory_threshold').is(':checked')) {
						$('#snmptraps_memory_threshold_value').show();
					}
					else {
						$('#snmptraps_memory_threshold_value').hide();
					}
					if ($('#snmptraps_cpu_load').is(':checked')) {
						$('#snmptraps_cpu_load_value').show();
					}
					else {
						$('#snmptraps_cpu_load_value').hide();
					}
					if ($('#snmptraps_isdn_crc').is(':checked')) {
						$('#snmptraps_isdn_crc_value').show();
					}
					else {
						$('#snmptraps_isdn_crc_value').hide();
					}
				}
				else {
					$('#fg_snmptraps_server').hide();
					$('#fg_snmp_trap_list').hide();
					$('#fg_snmptraps_v2_settings').hide();
					$('#fg_snmptraps_v3usm_settings').hide();
				}
			}
		
			function snmp_show() {
				$('#snmp_version').show();
				if (! $('#snmp_version_disabled').is(':selected')) {
				
					$("#cb_snmpserver_enabled").prop("disabled", false)
					$("#cb_snmptraps_enabled").prop("disabled", false)
					$('#snmp_syslocation').show();
					$('#fg_snmpserver_enable').show();
					$('#fg_snmptraps_enable').show();
					
					if ($('#snmp_version2').is(':selected')) {
						
						$('#fg_snmptraps_v3usm_settings').hide();
						$('#fg_snmpserver_v3usm_settings').hide();
						$('#snmpCertificates').hide();
						
						if ($('#cb_snmpserver_enabled').is(':checked')) {
							$('#fg_snmpserver_v2_settings').show();
						}
						else {
							$('#fg_snmpserver_v2_settings').hide();
						}

						if ($('#cb_snmptraps_enabled').is(':checked')) {
							$('#fg_snmptraps_v2_settings').show();

						}
						snmp_update_trap_items();
						
					}
					else if ($('#snmp_version3_usm').is(':selected')) {
					
						$('#fg_snmpserver_v2_settings').hide();
						$('#fg_snmptraps_v2_settings').hide();
						$('#snmpCertificates').hide();
						
						if ($('#cb_snmpserver_enabled').is(':checked')) {
							$('#fg_snmpserver_v3usm_settings').show();
						}
						else {
							$('#fg_snmpserver_v3usm_settings').hide();
						}
						
						if ($('#cb_snmptraps_enabled').is(':checked')) {
							$('#fg_snmptraps_v3usm_settings').show();
						}
						$('#snmptraps_server').hide();
						snmp_update_trap_items();
					}
					else if ($('#snmp_version3_tsm').is(':selected')) {
					
						$('#fg_snmpserver_v2_settings').hide();
						$('#fg_snmptraps_v2_settings').hide();
						$('#fg_snmpserver_v3usm_settings').hide();
						$('#fg_snmptraps_v3usm_settings').hide();
						$('#snmpCertificates').show();
						snmp_update_trap_items();
					}
				}
				else {
					$('#snmpCertificates').hide();
					$('#tabs-2').hide();
					$('#tabs-3').hide();
					$('#fg_snmpserver_v2_settings').hide();
					$('#fg_snmptraps_v2_settings').hide();
					$('#fg_snmpserver_v3usm_settings').hide();
					$('#fg_snmptraps_v3usm_settings').hide();
					$('#fg_snmp_trap_list').hide();
					$('#fg_snmptraps_server').hide();
					$("#cb_snmpserver_enabled").prop("disabled", true)
					$("#cb_snmptraps_enabled").prop("disabled", true)
				}
			}
			
			$('#snmp').validate({
				rules: {
				
					snmp_ro_user: {
						required: true,
						checkDigChar: true
					},
					snmp_community_ro: {
						checkSnmp: true
					},
					snmp_community_rw: {
						checkSnmp: true
					},
					
					snmp_ro_auth_password: {
						required: true,
					},
					snmp_ro_encrypt_password: {
						required: true,
					},
					
					snmptraps_server: {
						required: true,
						checkUrl: true,
					},
					snmptraps_user: {
						required: true,
						alphanumeric: true,
					},
					snmptraps_auth_password: {
						required: true,
					},
					snmptraps_encrypt_password: {
						required: true,
					},
					snmptraps_interval: {
						range: [10, 86400],
					},
					snmptraps_community: {
						checkSnmp: true
					},
					snmptraps_memory_threshold_value: {
						range: [0, 65535],
					},
					snmptraps_cpu_load_value: {
						range: [1, 1000],
					},
					snmptraps_isdn_crc_value: {
						range: [1, 1000000],
					},
					snmptraps_cpu_load_value: {
						range: [10, 86400],
						required: true,
					},
					
				}
		    });
		</script>
<?php
		return ob_get_clean ();
	}

	function getColorForCertFile($certFile) {
		$response = "punkt_rot.gif";
		if ($certFile == "snmpd_agent.crt") {
			if (file_exists ("/usr/conf/tls/certs/snmpd_agent.crt")) {
				$response = "punkt_gruen.gif";
			}
			else {
				$response = "punkt_rot.gif";
			}
		}
		else if ($certFile == "snmpd_manager.crt") {
			if (file_exists ("/usr/conf/tls/certs/snmpd_manager.crt")) {
				$response = "punkt_gruen.gif";
			}
			else {
				$response = "punkt_rot.gif";
			}
		}
		else if ($certFile == "snmpd_agent.key") {
			if (file_exists ("/usr/conf/tls/private/snmpd_agent.key")) {
				$response = "punkt_gruen.gif";
			}
			else {
				$response = "punkt_rot.gif";
			}
		}
		print $response;
	}
	
	function snmpTrapTable($bc) {
		ob_start ();
		?>
<input type=hidden name=m value="<?php echo $this->m_attr ?>">

<div class="form-group" id='fg_snmptraps_enable'>
	<label for='snmptraps_checkbox_enable_trap_page' class='col-sm-5 control-label'><?php echo SNMP_TRAPS_CHECKBOX_LABEL_ENABLE ?></label>
	<div class='col-sm-4 form-checkbox'>
		<?php echo $this->snmptraps_checkbox_enable_trap_page($bc) ?>
	</div>
	<br> <br>

	<div class="form-group" id='fg_snmptraps_server'>
		<label for='snmptraps_server' class='col-sm-5 control-label'><?php echo SNMP_TRAPS_SINK_DIS ?></label>
		<div class='col-sm-4'>
			<?php echo $this->snmptraps_server($bc) ?>
		</div>
	</div>

	<div class="form-group" id='fg_snmptraps_v3usm_settings'>
		<div class="form-group" id='fg_snmptraps_user'>
			<label for='snmptraps_user' class='col-sm-5 control-label'><?php echo SNMP_TRAP_USER  ?></label>
			<div class='col-sm-4'>
				<?php echo $this->snmptraps_user($bc) ?>
			</div>
		</div>

		<div class="form-group" id="fg_snmptraps_security_level">
			<label for='snmptraps_security_level' class='col-sm-5 control-label'> <?php echo SNMP_SECURITY_LEVEL ?> </label>
			<div class='col-sm-4 form-checkbox'>
				<?php echo $this->snmp_security_level($bc, 1) ?>
			</div>
		</div>

		<div class="form-group" id="fg_snmptraps_auth_method">
			<label for='snmptraps_auth_method' class='col-sm-5 control-label'> <?php echo SNMP_AUTHENTICATION_METHOD ?> </label>
			<div class='col-sm-4 form-checkbox'>
				<?php echo $this->snmp_auth_method($bc, 1) ?>
			</div>
		</div>

		<div class="form-group" id="fg_snmptraps_encrypt_method">
			<label for='snmptraps_encrypt_method' class='col-sm-5 control-label'> <?php echo SNMP_ENCRYPTION_METHOD ?> </label>
			<div class='col-sm-4 form-checkbox'>
				<?php echo $this->snmp_encrypt_method($bc, 1) ?>
			</div>
		</div>

		<div class="form-group" id='fg_snmptraps_auth_password' data-toggle='tooltip' title='<?php echo SNMP_AUTH_PASSWORD_TOOLTIP ?>'>
			<label for='snmptraps_auth_password' class='col-sm-5 control-label'><?php echo SNMP_RO_AUTH_PASSWORD ?></label>
			<div class='col-sm-4'>
				<?php echo $this->snmp_ro_auth_password($bc, "snmptraps") ?>
			</div>
		</div>

		<div class="form-group" id='fg_snmptraps_encrypt_password' data-toggle='tooltip' title='<?php echo SNMP_ENCRYPT_PASSWORD_TOOLTIP ?>'>
			<label for='snmptraps_encrypt_password'
				class='col-sm-5 control-label'><?php echo SNMP_RO_ENCRYPT_PASSWORD ?></label>
			<div class='col-sm-4'>
				<?php echo $this->snmp_ro_encrypt_password($bc, "snmptraps") ?>
			</div>
		</div>
	</div>

	<div class="form-group" id='fg_snmptraps_v2_settings'>
		<div class="form-group" id='snmp_v2_community_trap'>
			<label for='snmp_v2_community_trap' class='col-sm-5 control-label'><?php echo SNMP_COMMUNITY_TRAP_DIS ?></label>
			<div class='col-sm-4'>
					<?php echo $this->snmp_v2_community_trap($bc) ?>
			</div>
		</div>

	</div>

	<div class="form-group" id='fg_snmp_trap_list'>
		<div class="form-group" id='fg_snmptraps_interval' data-toggle='tooltip' title='<?php echo SNMP_TRAPS_INTERVAL_TOOLTIP ?>' >
			<label for='snmptraps_interval' class='col-sm-5 control-label'><?php echo SNMP_TRAPS_INTERVAL_DIS ?></label>
			<div class='col-sm-4'>
				<?php echo $this->snmptraps_interval($bc) ?>
			</div>
		</div>
		<hr>

<?php

		foreach ( $this->trap_array as $value ) {
			$show_memory_limit_text_field = 0;
			$show_memory_cpu_load_field = 0;
			$show_isdn_crc_field = 0;
			$tooltip="";
			if ($value == "isdn_layer1") {
				$label = SNMP_TRAPS_CHECKBOX_LABEL_ISDN_LAYER1;
				$tooltip=" data-toggle='tooltip' title='" . SNMP_TRAPS_CHECKBOX_LABEL_ISDN_LAYER1_TOOLTIP . "' ";
			}
			else if ($value == "isdn_layer2") {
				$label = SNMP_TRAPS_CHECKBOX_LABEL_ISDN_LAYER2;
				$tooltip=" data-toggle='tooltip' title='" . SNMP_TRAPS_CHECKBOX_LABEL_ISDN_LAYER2_TOOLTIP . "' ";
			}
			else if ($value == "isdn_crc") {
				$label = SNMP_TRAPS_CHECKBOX_LABEL_ISDN_CRC;
				$show_isdn_crc_field = 1;
				$tooltip=" data-toggle='tooltip' title='" . SNMP_TRAPS_CHECKBOX_LABEL_ISDN_CRC_TOOLTIP . "' ";
			}
			else if ($value == "sip_validation") {
				$label = SNMP_TRAPS_CHECKBOX_LABEL_SIP_VALIDATION;
				$tooltip=" data-toggle='tooltip' title='" . SNMP_TRAPS_CHECKBOX_LABEL_SIP_VALIDATION_TOOLTIP . "' ";
			}
			else if ($value == "sip_registration") {
				$label = SNMP_TRAPS_CHECKBOX_LABEL_SIP_REGISTRATION;
				$tooltip=" data-toggle='tooltip' title='" . SNMP_TRAPS_CHECKBOX_LABEL_SIP_REGISTRATION_TOOLTIP . "' ";
			}
			else if ($value == "memory_threshold") {
				$label = SNMP_TRAPS_CHECKBOX_LABEL_MEMORY_THRESHOLD;
				$show_memory_limit_text_field = 1;
				$tooltip=" data-toggle='tooltip' title='" . SNMP_TRAPS_CHECKBOX_LABEL_MEMORY_THRESHOLD_TOOLTIP . "' ";
			}
			else if ($value == "cpu_load") {
				$label = SNMP_TRAPS_CHECKBOX_LABEL_CPU_OVERLOAD;
				$show_memory_cpu_load_field = 1;
				$tooltip=" data-toggle='tooltip' title='" . SNMP_TRAPS_CHECKBOX_LABEL_CPU_OVERLOAD_TOOLTIP . "' ";
			}
			else {
				$label = "-----";
			}
			?>
		<div class="form-group" id='fg_snmptraps_<?php echo $value; ?>'  <?php echo $tooltip ?>>
			<label for='snmptraps_checkbox_enable_<?php echo $value; ?>' class='col-sm-5 control-label'><?php echo $label ?></label>
			<div class='col-sm-4 form-checkbox'>
<?php
					echo $this->snmptraps_checkbox_enable_trap_item($bc, $value);
					if ($show_memory_limit_text_field) {
						echo $this->snmptraps_trap_text_field ($bc, "memory_threshold", "2000");
					}
					if ($show_memory_cpu_load_field) {
						echo $this->snmptraps_trap_text_field ($bc, "cpu_load", "150");
					}
					if ($show_isdn_crc_field) {
						echo $this->snmptraps_trap_text_field ($bc, "isdn_crc", "20");
					}
				?>
			</div>
		</div>
<?php } ?>
	</div>
</div>
<br>

<?php
		return ob_get_clean ();
	}
	
	/**
	 * Generates the html form for the SNMP settings
	 * 
	 * @return string HTML form
	 */
	function snmpTable($bc) {
		ob_start ();
		?>
<input type=hidden name=m value="<?php echo $this->m_attr ?>">
<div class="form-group" id='fg_snmpserver_enable'>
	<div>
		<label for='snmptraps_checkbox_enable_server_page'
			class='col-sm-5 control-label'><?php echo SNMP_SERVER_CHECKBOX_LABEL_ENABLE ?></label>
		<div class='col-sm-4 form-checkbox'>
				<?php echo $this->snmptraps_checkbox_enable_server_page($bc) ?>
		</div>
		<br> <br>

		<div class="form-group" id='fg_snmpserver_v2_settings'>
			<div class="form-group" id='communityRo'>
				<label for='snmp_community_ro' class='col-sm-5 control-label'><?php echo SNMP_RO_COMMUNITY_DIS ?></label>
				<div class='col-sm-4'>
					<?php echo $this->ro_community($bc) ?>
				</div>
			</div>
			<div class="form-group" id='communityRw'>
				<label for='snmp_community_rw' class='col-sm-5 control-label'><?php echo SNMP_RW_COMMUNITY_DIS ?></label>
				<div class='col-sm-4'>
					<?php echo $this->rw_community($bc) ?>
				</div>
			</div>
		</div>

		<div class="form-group" id='fg_snmpserver_v3usm_settings'>

			<div class="form-group" id='snmp_ro_user'>
				<label for='snmp_ro_user' class='col-sm-5 control-label'><?php echo SNMP_RO_USER ?></label>
				<div class='col-sm-4'>
					<?php echo $this->snmp_ro_user($bc) ?>
				</div>
			</div>

			<div class="form-group" id="snmpSecurityLevel">
				<label for='snmp_security_level' class='col-sm-5 control-label'> <?php echo SNMP_SECURITY_LEVEL ?> </label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->snmp_security_level($bc) ?>
				</div>
			</div>

			<div class="form-group" id="snmpAuthMethod">
				<label for='snmp_auth_method' class='col-sm-5 control-label'> <?php echo SNMP_AUTHENTICATION_METHOD ?> </label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->snmp_auth_method($bc) ?>
				</div>
			</div>

			<div class="form-group" id="snmpEncryptMethod">
				<label for='snmp_encrypt_method' class='col-sm-5 control-label'> <?php echo SNMP_ENCRYPTION_METHOD ?> </label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->snmp_encrypt_method($bc) ?>
				</div>
			</div>

			<div class="form-group" id='snmpRoAuthPassword' data-toggle='tooltip' title='<?php echo SNMP_AUTH_PASSWORD_TOOLTIP ?>'>
				<label for='snmp_ro_auth_password' class='col-sm-5 control-label'><?php echo SNMP_RO_AUTH_PASSWORD ?></label>
				<div class='col-sm-4'>
					<?php echo $this->snmp_ro_auth_password($bc, "snmp_ro") ?>
				</div>
			</div>

			<div class="form-group" id='snmpRoEncryptPassword' data-toggle='tooltip' title='<?php echo SNMP_ENCRYPT_PASSWORD_TOOLTIP ?>'>
				<label for='snmp_ro_encrypt_password' class='col-sm-5 control-label'><?php echo SNMP_RO_ENCRYPT_PASSWORD ?></label>
				<div class='col-sm-4'>
					<?php echo $this->snmp_ro_encrypt_password($bc, "snmp_ro") ?>
				</div>
			</div>
		</div>
	</div>
</div>
<br>
<br>
<?php
		return ob_get_clean ();
	}
	
	
	
	function snmpTableGeneral($bc) {
		ob_start ();
		?>

<input type=hidden name=m value="<?php echo $this->m_attr ?>">

<div class="form-group" id="snmp_version">
	<label for='snmp_version' class='col-sm-5 control-label'> SNMP Version
	</label>
	<div class='col-sm-4 form-checkbox'>
		<?php echo $this->snmp_version($bc) ?>
	</div>
</div>
<div class="form-group" id='snmp_syslocation'>
	<label for='snmp_syslocation' class='col-sm-5 control-label'><?php echo SNMP_SYSLOCATION ?></label>
	<div class='col-sm-4'>
		<?php echo $this->snmp_syslocation($bc) ?>
	</div>
</div>

<div class="form-group" id='snmpCertificates'>
	<div class='form-group' id='upload_snmp_server_cert'
		data-toggle='tooltip'
		title='<?php echo SNMP_UPLOAD_SERVER_CERTIFICATE_TOOLTIP; ?>'>
		<label for='snmp_server_cert' class='col-sm-5 control-label'> <?php echo SNMP_UPLOAD_SERVER_CERTIFICATE_LABEL ?> <img
			src='./includes/images/<?php $this->getColorForCertFile("snmpd_agent.crt")?>'></label>

		<div class='col-sm-4 form-checkbox'>
			<input type='file' size='28' name='snmp_server_cert'>
		</div>
					<?php if (file_exists("/usr/conf/tls/certs/snmpd_agent.crt")) { ?>
					<input type='button' class='btn btn-default'
			value='<?php echo BUTTON_DELETE ?>'
			onclick="javascript:if (confirm('<?php echo SIP_STACKS_DELETE_CERTIFICATE_MESS_DIS ?>?') == true) window.location.href = 'misc/deletefile.php?m=<?php echo $this->m_attr ?>&option=certificate&file=snmpd_agent_cert';">
					<?php } ?>
	</div>

	<div class='form-group' id='upload_snmp_server_key'
		data-toggle='tooltip'
		title='<?php echo SNMP_UPLOAD_SERVER_KEY_TOOLTIP; ?>'>

		<label for='snmp_server_key' class='col-sm-5 control-label'> <?php echo SNMP_UPLOAD_SERVER_KEY_LABEL ?> <img
			src='./includes/images/<?php $this->getColorForCertFile("snmpd_agent.key")?>'></label>
		<div class='col-sm-4 form-checkbox'>
			<input type='file' size='28' name='snmp_server_key'>
		</div>
					<?php if (file_exists("/usr/conf/tls/private/snmpd_agent.key")) { ?>
					<input type='button' class='btn btn-default'
			value='<?php echo BUTTON_DELETE ?>'
			onclick="javascript:if (confirm('<?php echo SIP_STACKS_DELETE_CERTIFICATE_MESS_DIS ?>?') == true) window.location.href = 'misc/deletefile.php?m=<?php echo $this->m_attr ?>&option=certificate&file=snmpd_agent_key';">
					<?php } ?>
	</div>

	<div class='form-group' id='upload_snmp_client_cert'
		data-toggle='tooltip'
		title='<?php echo SNMP_UPLOAD_CLIENT_CERTIFICATE_TOOLTIP; ?>'>
		<label for='snmp_client_cert' class='col-sm-5 control-label'> <?php echo SNMP_UPLOAD_CLIENT_CERTIFICATE_LABEL ?>  <img
			src='./includes/images/<?php $this->getColorForCertFile("snmpd_manager.crt")?>'></label>
		<div class='col-sm-4 form-checkbox'>
			<input type='file' size='28' name='snmp_client_cert'>
		</div>
					
					<?php if (file_exists("/usr/conf/tls/certs/snmpd_manager.crt")) { ?>
					<input type='button' class='btn btn-default'
			value='<?php echo BUTTON_DELETE ?>'
			onclick="javascript:if (confirm('<?php echo SIP_STACKS_DELETE_CERTIFICATE_MESS_DIS ?>?') == true) window.location.href = 'misc/deletefile.php?m=<?php echo $this->m_attr ?>&option=certificate&file=snmpd_manager_cert';">
					<?php } ?>
	</div>

</div>
<?php
		return ob_get_clean ();
	}

	/**
	 * Saves the setting in the database
	 *
	 * @param beroAri $ba
	 * @return string HTML code
	 */
	function save($ba, $bc) {
		if (isset ($this->post_attr ['snmp_version'])) {
			if (sqlite_escape_string ($this->post_attr ['snmp_version']) != "Disabled") {
				
				$server_enabled = sqlite_escape_string ($this->post_attr ['cb_snmpserver_enabled']);
				$traps_enabled = sqlite_escape_string ($this->post_attr ['cb_snmptraps_enabled']);
				$server_enabled == "1" ? 0 : $server_enabled = "0";
				$traps_enabled == "1" ? 0 : $traps_enabled  = "0";
				
				$error = 0;
				if (sqlite_escape_string ($this->post_attr ['snmp_version']) == "SNMPv3_usm") {
					
					if ($server_enabled == "1") {
						if (strlen (sqlite_escape_string ($this->post_attr ['snmp_ro_user'])) == 0) {
							$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_NO_USERNAME_ERROR . "</div>";
							$error = 1;
						}
						if (sqlite_escape_string ($this->post_attr ['snmp_security_level']) == "AuthPriv") {
							
							if (strlen (sqlite_escape_string ($this->post_attr ['snmp_ro_auth_password'])) < 8) {
								$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . "SNMP-Server: " . SNMP_NO_AUTHENTICATION_PASSWORD . "</div>";
								$error = 1;
							}
							if (strlen (sqlite_escape_string ($this->post_attr ['snmp_ro_encrypt_password'])) < 8) {
								$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . "SNMP-Server: " .SNMP_NO_ENCRYPTION_PASSWORD . "</div>";
								$error = 1;
							}
						}
						else if (sqlite_escape_string ($this->post_attr ['snmp_security_level']) == "AuthNoPriv") {
							if (strlen (sqlite_escape_string ($this->post_attr ['snmp_ro_auth_password'])) < 8) {
								$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . "SNMP-Server: " .SNMP_NO_AUTHENTICATION_PASSWORD . "</div>";
								$error = 1;
							}
						}
					}
					if ($traps_enabled == "1") {
						if (strlen (sqlite_escape_string ($this->post_attr ['snmptraps_user'])) == 0) {
							$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_NO_USERNAME_ERROR . "</div>";
							$error = 1;
						}
						if (sqlite_escape_string ($this->post_attr ['snmp_security_level']) == "AuthPriv") {
							
							if (strlen (sqlite_escape_string ($this->post_attr ['snmptraps_auth_password'])) < 8) {
								$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . "Traps: " . SNMP_NO_AUTHENTICATION_PASSWORD . "</div>";
								$error = 1;
							}
							if (strlen (sqlite_escape_string ($this->post_attr ['snmptraps_encrypt_password'])) < 8) {
								$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . "Traps: " . SNMP_NO_ENCRYPTION_PASSWORD . "</div>";
								$error = 1;
							}
						}
						else if (sqlite_escape_string ($this->post_attr ['snmptraps_security_level']) == "AuthNoPriv") {
							if (strlen (sqlite_escape_string ($this->post_attr ['snmptraps_auth_password'])) < 8) {
								$table .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . "Traps: " . SNMP_NO_AUTHENTICATION_PASSWORD . "</div>";
								$error = 1;
							}
						}
					}
				}
				
				if ($error == 0) {
					$bc->set ('root', 'snmp-enabled', "1");
					
					$bc->set ('root', 'snmp-syslocation', sqlite_escape_string ($this->post_attr ['snmp_syslocation']));
					$bc->set ('root', 'snmp-version', sqlite_escape_string ($this->post_attr ['snmp_version']));
					$bc->set ('root', 'snmpserver_enabled', $server_enabled);
					
					
					if ($server_enabled == "1") {
						$bc->set ('root', 'snmp-community-rw', sqlite_escape_string ($this->post_attr ['snmp_community_rw']));
						$bc->set ('root', 'snmp-community-ro', sqlite_escape_string ($this->post_attr ['snmp_community_ro']));
						
						$bc->set ('root', 'snmp-ro-user', sqlite_escape_string ($this->post_attr ['snmp_ro_user']));
						$bc->set ('root', 'snmp-security-level', sqlite_escape_string ($this->post_attr ['snmp_security_level']));
						$bc->set ('root', 'snmp-auth-method', sqlite_escape_string ($this->post_attr ['snmp_auth_method']));
						$bc->set ('root', 'snmp-encrypt-method', sqlite_escape_string ($this->post_attr ['snmp_encrypt_method']));
						$bc->set ('root', 'snmp-ro-auth-password', sqlite_escape_string ($this->post_attr ['snmp_ro_auth_password']));
						$bc->set ('root', 'snmp-ro-encrypt-password', sqlite_escape_string ($this->post_attr ['snmp_ro_encrypt_password']));
					}
					
					
					$bc->set ('root', 'snmptraps_enabled', $traps_enabled);
					
					if ($traps_enabled == "1") {
						
						$bc->set ('root', 'snmptraps_community', sqlite_escape_string ($this->post_attr ['snmptraps_community']));
						
						$trap_list = "";
						foreach ( $this->trap_array as $value ) {
							$key = "snmptraps_" . $value;
							$val = sqlite_escape_string ($this->post_attr [$key]);
							if ($val == "1") {
								$trap_list .= $value;
								$trap_list .= ",";
								if ($value == "memory_threshold") {
									$bc->set ('root', 'snmptraps_memory_threshold', sqlite_escape_string ($this->post_attr ['snmptraps_memory_threshold_value']));
								}
								if ($value == "cpu_load") {
									$bc->set ('root', 'snmptraps_cpu_load', sqlite_escape_string ($this->post_attr ['snmptraps_cpu_load_value']));
								}
								if ($value == "isdn_crc") {
									$bc->set ('root', 'snmptraps_isdn_crc', sqlite_escape_string ($this->post_attr ['snmptraps_isdn_crc_value']));
								}
							}
						}
						$bc->set ('root', 'snmptraps_traplist', $trap_list);
						
						$bc->set ('root', 'snmptraps_server', sqlite_escape_string ($this->post_attr ['snmptraps_server']));
						$bc->set ('root', 'snmptraps_interval', sqlite_escape_string ($this->post_attr ['snmptraps_interval']));
						
						$bc->set ('root', 'snmptraps_security_level', sqlite_escape_string ($this->post_attr ['snmptraps_security_level']));
						$bc->set ('root', 'snmptraps_auth_method', sqlite_escape_string ($this->post_attr ['snmptraps_auth_method']));
						$bc->set ('root', 'snmptraps_encrypt_method', sqlite_escape_string ($this->post_attr ['snmptraps_encrypt_method']));
						$bc->set ('root', 'snmptraps_auth_password', sqlite_escape_string ($this->post_attr ['snmptraps_auth_password']));
						$bc->set ('root', 'snmptraps_encrypt_password', sqlite_escape_string ($this->post_attr ['snmptraps_encrypt_password']));
						$bc->set ('root', 'snmptraps_user', sqlite_escape_string ($this->post_attr ['snmptraps_user']));
					}
				}
			}
			else {
				$bc->set ('root', 'snmp-enabled', "0");
				$bc->set ('root', 'snmp-version', sqlite_escape_string ($this->post_attr ['snmp_version']));
			}
			
			$table .= Helper::activate (2, true, $this->m_attr, ACTIVATE);
			return $table;
		}
		return $table;
	}

	function upload_certificate($ba, $files) {
		$response = "";
		$output = "";
		$retval = "";
		
		$cert_file_agent = "/usr/conf/tls/certs/snmpd_agent.crt";
		$key_file_agent = "/usr/conf/tls/private/snmpd_agent.key";
		$cert_file_manager = "/usr/conf/tls/certs/snmpd_manager.crt";
		$tmp_key_file = "/tmp/snmpd.tmp.key";
		
		$tmp_file = $files ["snmp_server_cert"] ["tmp_name"];
		if ($files ["snmp_server_cert"] ["name"] != "") {
			if ($files ["snmp_server_cert"] ["size"] > 51200) { // 50 kB
				$response .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_UPLOAD_SERVER_CERTIFICATE_ERROR_SIZE . "</div>";
			}
			else {
				
				exec ("mkdir -p /usr/conf/tls/certs");
				exec ("openssl x509 -in " . $tmp_file . " -noout -text &> /dev/null", $output, $retval);
				if ($retval == 0) {
					exec ("/bin/cp " . $tmp_file . " " . $cert_file_agent);
					exec ("/bin/chmod 600 " . $cert_file_agent);
					$response .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'>" . SNMP_UPLOAD_SERVER_CERTIFICATE_SUCCESS . "</div>";
					
					if (0) { // pkey not working with old openssl
					         // extract the key out of the file if it exists
						exec ("openssl pkey -in " . $tmp_file . " -out " . $tmp_key_file, $output, $retval);
						if ($retval == 0) {
							exec ("mkdir -p /usr/conf/tls/private");
							exec ("/bin/cp " . $tmp_key_file . " " . $key_file_agent);
							exec ("/bin/chmod 600 " . $key_file_agent);
							unlink ($tmp_key_file);
							$response .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'>" . SNMP_UPLOAD_SERVER_KEY_SUCCESS . "</div>";
						}
					}
					else { // we just check if it contains a PRIVATE KEY and copy the whole file to the private location
						$handle = fopen ($tmp_file, "r");
						
						$key_found = 0;
						if ($handle) {
							// Read file line-by-line
							while ( ($buffer = fgets ($handle)) !== false ) {
								if (strpos ($buffer, "--BEGIN PRIVATE KEY--") === false) {
									$key_found = 1;
								}
							}
						}
						
						if ($key_found) {
							exec ("mkdir -p /usr/conf/tls/private");
							exec ("/bin/cp " . $tmp_file . " " . $key_file_agent);
							exec ("/bin/chmod 600 " . $key_file_agent);
							unlink ($tmp_key_file);
							$response .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'>" . SNMP_UPLOAD_SERVER_KEY_SUCCESS . "</div>";
						}
					}
				}
				else {
					$response .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_UPLOAD_SERVER_CERTIFICATE_ERROR_FORMAT . "</div>";
				}
			}
		}
		$tmp_file = $files ["snmp_server_key"] ["tmp_name"];
		if ($files ["snmp_server_key"] ["name"] != "") {
			if ($files ["snmp_server_key"] ["size"] > 51200) { // 50 kB
				$response .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_UPLOAD_SERVER_KEY_ERROR_SIZE . "</div>";
			}
			else {
				exec ("openssl pkey -in " . $tmp_file . " -out " . $tmp_key_file, $output, $retval);
				if ($retval == 0) {
					exec ("mkdir -p /usr/conf/tls/private");
					exec ("/bin/cp " . $tmp_file . " " . $key_file_agent);
					exec ("/bin/chmod 600 " . $key_file_agent);
					
					$response .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'>" . SNMP_UPLOAD_SERVER_KEY_SUCCESS . "</div>";
				}
				else {
					$response .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_UPLOAD_SERVER_KEY_ERROR_FORMAT . "</div>";
				}
				unlink ($tmp_key_file);
			}
		}
		
		$tmp_file = $files ["snmp_client_cert"] ["tmp_name"];
		if ($files ["snmp_client_cert"] ["name"] != "") {
			if ($files ["snmp_client_cert"] ["size"] > 51200) { // 50 kB
				$response .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_UPLOAD_CLIENT_CERTIFICATE_ERROR_SIZE . "</div>";
			}
			else {
				exec ("mkdir -p /usr/conf/tls/certs");
				exec ("openssl x509 -in " . $tmp_file . " -noout -text &> /dev/null", $output, $retval);
				if ($retval == 0) {
					exec ("/bin/cp " . $tmp_file . " " . $cert_file_manager);
					exec ("/bin/chmod 600 " . $cert_file_manager);
					$response .= "<div class='text-center'><img src='./includes/images/punkt_gruen.gif'>" . SNMP_UPLOAD_CLIENT_CERTIFICATE_SUCCESS . "</div>";
				}
				else {
					$response .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_UPLOAD_CLIENT_CERTIFICATE_ERROR_FORMAT . "</div>";
				}
			}
		}
		// check if the key matches the installed certificate, if not, just delete the key
		if (file_exists ($cert_file_agent) && file_exists ($key_file_agent)) {
			$cert_modulus = "1";
			$key_modulus = "2";
			exec ("openssl x509 -noout -modulus -in " . $cert_file_agent, $cert_modulus, $retval);
			if ($retval == 0) {
				exec ("openssl rsa -noout -modulus -in " . $key_file_agent, $key_modulus, $retval);
			}
			if ($cert_modulus != $key_modulus) {
				$response .= "<div class='text-center'><img src='./includes/images/punkt_rot.gif'>" . SNMP_UPLOAD_SERVER_KEY_ERROR_MATCH . "</div>";
				unlink ($key_file_agent);
			}
		}
		return $response;
	}
}
?>
