<?php
/**
 * Informationsseite über den Status von PSTN Ports, SIP Konten, Cloud-Verbindung, usw.
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');
require_once('/usr/local/www/berogui/includes/Helper/HelperHtml.php');


class State {
	
	private $_m = null;

	private	$isRequestRejected 	= 0,
			$reasonRejected 	= array();

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->_m = $m;

		// if an error occurs during a background script or in other modules (badly redirected)
        if (isset($get['error'])) {
            $this->isRequestRejected = 1;
            $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
            unset($get['error'], $get['request'], $get['checkor'], $get['key']);
        }
	}
	// returns HTML for ISDN table
	function isdn_state_table ($isgw) {

		$isdnresult=$isgw->isgw_isdnstate();
		$rows = "";
		$rows = explode("\n", $isdnresult);
		if (count($rows)>=4){
			$l1=file("/proc/l1_stats");
			foreach($l1 as $key => $value){
				$v=explode(";",$value);
				foreach($v as $werte){
					$wert=explode("=",$werte);
					if ($wert[0]=="port") {$port=$wert[1]; $l1_stats[$wert[1]]="";}
					if ($wert[0]=="physw") {$l1_stats[$port].="Physical Link Switch: ".$wert[1]."<br>";}
					if ($wert[0]=="crc") {$l1_stats[$port].="CRC Error: ".$wert[1]."<br>";}
					if ($wert[0]=="fr") {$l1_stats[$port].="Frame Resent: ".$wert[1]."<br>";}
					if ($wert[0]=="fs") {$l1_stats[$port].="Frame Resync: ".$wert[1]."<br>";}
					if ($wert[0]=="los") {$l1_stats[$port].="Loss of Signal: ".$wert[1];}
				}
			}

			$l2=file("/proc/l2_stats");
			foreach($l2 as $key => $value){
				$v=explode(";",$value);
				foreach($v as $werte){
					$wert=explode("=",$werte);
					if ($wert[0]=="port") {$port=$wert[1]; $l2_stats[$wert[1]]="";}
					if ($wert[0]=="mdl") {$l2_stats[$port].="L2 Error: ".$wert[1]."<br>";}
					if ($wert[0]=="frm") {$l2_stats[$port].="L2 Frame Error: ".$wert[1]."<br>";}
				}
			}

			$ret .= "<br><br>";
			$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
			$ret .= "<th colspan='6' class='text-center'>".STATE_ISDN_STATUS_DIS."</th>";
			$ret .= "<tr><td><b>".STATE_PORT_DIS."</b></td><td><b>".STATE_TYPE_DIS."</b></td><td><b>".STATE_PROT_DIS."</b></td>";
			$ret .= "<td><b>".STATE_L2LINK_DIS."</b></td><td><b>".STATE_L1LINK_DIS."</b></td><td></td></tr>";

			foreach ($rows as $value){
				$pos=strpos($value,"Port");
				if($pos !== false){
					$ret .= "<tr>";
					$tmp = explode("Port ", $value);
					$port = explode(" Type", $tmp[1]);
					$ret .= "<td>" . $port[0] . "</td>";
					$type = explode(" Prot.", $port[1]);
					$ret .= "<td>" . $type[0] . "</td>";
					$prot = explode(" L2Link", $type[1]);
					$ret .= "<td>" . $prot[0] . "</td>";
					$l2link = explode(" L1Link:", $prot[1]);
					$l2link[0] = str_replace(" ", "", $l2link[0]);
					if ($l2link[0] == "UP") {
						$ret .= "<td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP<br>" . $l2_stats[$port[0]] . "')\" onmouseout='UnTip()'></td>";
					} else {
						$ret .= "<td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN<br>" . $l2_stats[$port[0]] . "')\" onmouseout='UnTip()'></td>";
					}
					$l1link = explode(" Blocked:", $l2link[1]);
					$l1link[0] = str_replace(" ", "", $l1link[0]);
					if ($l1link[0] == "UP") {
						$ret .= "<td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP<br>" . $l1_stats[$port[0]] . "')\" onmouseout='UnTip()'></td>";
					} else {
						$ret .= "<td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN<br>" . $l1_stats[$port[0]] . "')\" onmouseout='UnTip()'></td>";
					}
					$ret .= "<td><button id='stateRestart' class='btn btn-default ajaxsubmit' value='reloadisdn' value2='".$port[0]."'>".BUTTON_RESTART."</button></td></tr>";
				}//endif
			}//endforeach

			$ret .= "</table><br/><br/>";
		}

		return $ret;
	} //end function isdn_state_table

	// returns HTML for ANALOG table
	function analog_state_table($isgw) {

		$analogresult=$isgw->isgw_analogstate();
		$rows = "";
		$rows = explode("\n", $analogresult);
		if (count($rows)>=4){
			$ret .= "<br><br>";
			$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
			$ret .= "<th colspan='6' class='text-center'>".STATE_ANALOG_STATUS_DIS."</th>";
			$ret .= "<tr><td><b>".STATE_PORT_DIS."</b></td><td><b>".STATE_TYPE_DIS."</b></td><td><b>".STATE_STATE_DIS."</b></td>";
			$ret .= "<td><b>".STATE_LINE_VOLTAGE_DIS."</b></td></tr>";

			foreach ($rows as $value){
				$pos=strpos($value,"Port");
				if($pos !== false){
					$ret .= "<tr>";
					
					$fields = explode("\t", $value);
					$tmp = explode("Port ", $value);
					$port = explode("type:", $tmp[1]);
					$ret .= "<td>" . $port[0] . "</td>";
					$type = explode("state:", $port[1]);
					$broken="<b><font color='red'>".$type[0]."</font></b>";
					$ret .= "<td>" .((trim($type[0])!="BROKEN") ? $type[0] : $broken) . "</td>";
					
					$state = explode("linevoltage:", $type[1]);
					
					$admin_offset = explode(":", $fields[6]);
					
					if ($admin_offset[1] == "1") {
						$shown_state = "FXO_ADMINISTRATIVE_OFFHOOK";
					}
					else {
						$shown_state = $state[0];
					}
					
					if (trim($shown_state)=="UNKNOWN" || trim($shown_state)=="FXS_LOWPOWER"){
						$shown_state="FXS_LOWPOWER";
						$ret .= "<td onmouseover=\"Tip('" . STATE_LOWPOWER_DIS. "')\" onmouseout='UnTip()'>" . $shown_state . "</td>";
					}
					else {
						$ret .= "<td>" . $shown_state . "</td>";
					}
					$linevoltage = explode("pol:", $state[1]);
					$pol = explode("rtlc:", $linevoltage[1]);


					if ($linevoltage[0] >= 30) {
						$ret .= "<td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP<br>" . STATE_LINE_VOLTAGE_DIS. ":". $linevoltage[0] . "<br>".STATE_POLARITY_DIS.":" .  $pol[0] . "')\" onmouseout='UnTip()'></td>";
					} else {
						$ret .= "<td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN<br>" . STATE_LINE_VOLTAGE_DIS. ":". $linevoltage[0] . "<br>".STATE_POLARITY_DIS.":" .  $pol[0] . "')\" onmouseout='UnTip()'></td>";
					}
					$ret.="</tr>";
				}//endif
			}//endforeach

			$ret .= "</table><br/><br/>";
		}

		return $ret;
	} //end analog_state_table

	// returns HTML for CAS table
	function cas_state_table($isgw) {

		$casresult=$isgw->isgw_casstate();
		$rows = "";
		$rows = explode("\n", $casresult);
		if (count($rows)>=3){
			$ret .= "<br><br>";
			$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
			$ret .= "<th colspan='2' class='text-center'>".STATE_CAS_STATUS_DIS."</th>";
			$ret .= "<tr><td><b>".STATE_PORT_DIS."</b></td><td><b>".STATE_STATE_DIS."</b></td></tr>";

			foreach ($rows as $value){
				$row=  explode("\t", $value);
                                if (count($row)>=2){
					$ret .= "<tr>";
					$port = $row[0];
					$ret .= "<td>" . $port . "</td>";
					$state = $row[1];
					if ($state==1) {
						$ret .= "<td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP<br>" . STATE_LINE_VOLTAGE_DIS. ":". $linevoltage[0] . "<br>".STATE_POLARITY_DIS.":" .  $pol[0] . "')\" onmouseout='UnTip()'></td>";
					} else {
						$ret .= "<td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN<br>" . STATE_LINE_VOLTAGE_DIS. ":". $linevoltage[0] . "<br>".STATE_POLARITY_DIS.":" .  $pol[0] . "')\" onmouseout='UnTip()'></td>";
					}
					$ret.="</tr>";
				}//endif
			}//endforeach

			$ret .= "</table><br/><br/>";
		}
		return $ret;
	} //end cas_state_table

	// returns HTML of GSM table
	function gsm_state_table($ba,$isgw) {
		
		$gsm_result=$isgw->isgw_gsmstate();
		$adv_gsm_result=$isgw->isgw_adv_gsmstate(); 
		$isLtePlugged = sqlite_num_rows($ba->select("SELECT * from lte"))>0;
		$isGsmPlugged = sqlite_num_rows($ba->select("SELECT * from gsm"))>0;

		$rows = "";
		$rows = explode("\n", $gsm_result);
		if (count($rows)>=4){
			$ret .= "<br><br>";
			$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
			if ($isLtePlugged) $ret .= "<th colspan='5' class='text-center'>".STATE_LTE_STATUS_DIS."</th>";
			if ($isGsmPlugged && !$isLtePlugged) $ret .= "<th colspan='4' class='text-center'>".STATE_GSM_STATUS_DIS."</th>";
			$ret .= "<tr><td><b>".STATE_PORT_DIS."</b></td><td><b>".STATE_PROVIDER_DIS."</b></td><td><b>".STATE_REG_STATUS_DIS."</b></td>";
			$ret .= "<td><b>".STATE_TECH_DIS."</b></td>";
			$ret .= "<td><b>".STATE_SIGNAL_QUALITY_DIS."</b></td></tr>";
			$where="";
			foreach ($rows as $value){
				$pos=strpos($value,"Port");
				if($pos !== false){
					$ret .= "<tr>";
					
					$port = "0";
					$provider = "unknown";
					$counter = "-1";
					$regstatus = "3";
					$rssi= "-100";
					$ber = "0";
					$tech = "unknown";
					$fields = explode("\t", $value);
					if (count ($fields) == 6 || count ($fields) == 7) {
						$vals = explode(" Port ", $fields[0]);
						if (count ($vals) == 2) {
							$port = trim ($vals[1]);
						}
						$vals = explode("Provider:", $fields[1]);
						if (count ($vals) == 2 && trim($vals[1]) != "null") {
							$provider = trim ($vals[1]);
						}
						$vals = explode("Pin Counter:", $fields[2]);
						if (count ($vals) == 2) {
							$counter = trim ($vals[1]);
						}
						$vals = explode("Reg Status:", $fields[3]);
						if (count ($vals) == 2) {
							$regstatus = trim ($vals[1]);
						}
						$vals = explode("RSSI:", $fields[4]);
						if (count ($vals) == 2) {
							$rssi = trim ($vals[1]);
						}
						$vals = explode("BER:", $fields[5]);
						if (count ($vals) == 2) {
							$ber = trim ($vals[1]);
						}
						$vals = explode("Tech:", $fields[6]);
						if (count ($vals) == 2) {
							$tech = trim ($vals[1]);
						}
					}

					$lines=explode("\n",$adv_gsm_result);
					$imsi="";
					$imei="";
					for ($i=0;$i<=count($lines);$i++){
						if (trim($lines[$i])=="GSM PORT ".trim($port[0]).":"){
							$imsi=explode(": ",$lines[$i+1]);
							$imsi="IMSI: ".$imsi[1]."<br>";
							$imei=explode(": ",$lines[$i+2]);
							$imei="IMEI: ".$imei[1];
							break;
						}
					}

					$ret .= "<td onmouseover=\"Tip('".$imsi.$imei."')\" onmouseout='UnTip()'>" . $port . "</td>";
					$ret .= "<td onmouseover=\"Tip('" . STATE_PIN_COUNTER_DIS. ":". $counter . "')\" onmouseout='UnTip()'>" . $provider  . "</td>";
					if (trim($regstatus)=="NOT READY" || trim($regstatus)<0){ $src="./includes/images/punkt_rot.gif"; $tTip='DOWN<br>Not ready';}
					elseif (trim($regstatus)==0){ $src="./includes/images/punkt_rot.gif"; $tTip='DOWN<br>'.STATE_REG_STATUS0_DIS . "<br>" . $tech;}
					elseif (trim($regstatus)==1){ $src="./includes/images/punkt_gruen.gif"; $tTip='UP<br>'.STATE_REG_STATUS1_DIS . "<br>" . $tech;}
					elseif (trim($regstatus)==2){ $src="./includes/images/punkt_rot.gif"; $tTip='DOWN<br>'.STATE_REG_STATUS2_DIS . "<br>" . $tech;}
					elseif (trim($regstatus)==3){ $src="./includes/images/punkt_rot.gif"; $tTip='DOWN<br>'.STATE_REG_STATUS3_DIS . "<br>" . $tech;}
					elseif (trim($regstatus)==4){ $src="./includes/images/punkt_rot.gif"; $tTip='DOWN<br>'.STATE_REG_STATUS4_DIS . "<br>" . $tech;}
					elseif (trim($regstatus)==5){ $src="./includes/images/punkt_gruen.gif"; $tTip='UP<br>'.STATE_REG_STATUS5_DIS . "<br>" . $tech;}

					$ret .= "<td onmouseover=\"Tip('$tTip')\" onmouseout='UnTip()'><img src='".$src."'></td>";
					$ret .= "<td>". $tech ."</td>";

					$rssiNumber=$rssi;
					
					if 	($rssiNumber == -1 	|| $rssiNumber == 99) 		$signal = "No Signal";
					elseif 	($rssiNumber > 	-70) 					$signal = "Very High (" . $rssiNumber . ")";
					elseif 	($rssiNumber <= -70 	&& $rssiNumber > -85) 		$signal = "High (" . $rssiNumber . ")";
					elseif 	($rssiNumber <= -80 	&& $rssiNumber > -90) 		$signal = "Good (" . $rssiNumber . ")";
					elseif 	($rssiNumber <= -90) 					$signal = "Poor (" . $rssiNumber . ")";
					
					if ($regstatus == "NOT READY" || $regstatus < 0) {
						$signal = "---";
					}
					($where=="") ? $where="port=".$port[0] : $where.=" or port=".$port[0];
					$ret .= "<td onmouseover=\"Tip('" . STATE_RSSI_DIS . ":" . $rssi . "<br>" . STATE_BER_DIS . ":" . $ber . "')\" onmouseout='UnTip()'>" . $signal . "</td></tr>";
				}//endif
			}//endforeach
			$ret .= "<tr><td colspan='5' class='text-center'>";
			
			for ($i = 0; $i < 2; $i++) {
				($i == 0) ? $mtype = "gsm" : $mtype = "lte";
				$query=$ba->select("select distinct lif from " . $mtype . " where ".$where);
				$ret .= "<div style='display: inline-block; margin-right: 5px;'>";
				while ($entry = $ba->fetch_array($query)) {
					// TODO: the modification must be tested
				$queryPort=$ba->select("select port from $mtype where lif=".$entry['lif']);
				while ($entryPort = $ba->fetch_array($queryPort)) {
					$portsgsm[]=$entryPort['port'];
				}
				$ret .= "<button id='stateRestart' class='btn btn-default ajaxsubmit' style='margin-right:5px;' value='reloadgsm' value2='".$entry['lif']."' value3='".$portsgsm[0]."' value4='".$portsgsm[1]."'>LI ".$entry['lif'] . " ". BUTTON_RESTART."</button>";
				}
				$ret .= "</div>";
			}

			$ret .= "</td></tr>";
			$ret .= "</table><br/><br/>";
		}
		return $ret;
	} //end gsm_state_table

	// returns HTML for SIP table
	function sip_state_table($ba,$isgw) {

		$sipresult=$isgw->isgw_sipstate();

		$ret .= "<br/><br/>";
		$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
		$ret .= "<tr><th colspan='5' class='text-center'>".STATE_REGISTRATION_STATUS_DIS."</th></tr>";
		$ret .= "<tr><td><b>".STATE_ACCOUNTNAME_DIS."</b></td><td><b>".STATE_REGISTRAR_DIS."</b></td><td><b>".STATE_USER_DIS."</b></td>";
		$ret .= "<td><b>".STATE_VALIDATIONSTATUS_DIS."</b></td><td><b>".STATE_REGSTATUS_DIS."</b></td></tr>";

		$rows = explode("\n", $sipresult);
		$i=0;
		foreach ($rows as $value){
			preg_match('/(.+)\s*\=\>(.+)\s*/', $value,$match);
			if (trim($match[1])=="RESPONSECODE") $responsecode = trim($match[2]);
			if (trim($match[1])=="RESPONSECODEVAL") $responsecodeval = trim($match[2]);
			
			if (trim($match[1])=="ACCOUNTNAME") $ret.="<tr><td>".trim($match[2])."</td>";
			if (trim($match[1])=="ADDRESS") $ret.="<td>".trim($match[2])."</td>";
			if (trim($match[1])=="USERNAME") $ret.="<td>".trim($match[2])."</td>";

			if (trim($match[1])=="VALIDATED" && (trim($match[2])=="-1")) $ret .= "<td><img src='./includes/images/punkt_grau.gif' onmouseover=\"Tip('" . TOOLTIP_NOVALIDATION_REQUESTED . "')\" onmouseout='UnTip()'></td>";
			elseif (trim($match[1])=="VALIDATED" && (trim($match[2])=="0")) $ret .= "<td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN<br>" . $responsecodeval . "')\" onmouseout='UnTip()'></td>";
			elseif (trim($match[1])=="VALIDATED" && (trim($match[2])=="1")) $ret .= "<td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'></td>";
			elseif (trim($match[1])=="VALIDATED")  $ret .= "<td><img src='./includes/images/punkt_grau.gif' onmouseover=\"Tip('Error')\" onmouseout='UnTip()'></td>";

			if (trim($match[1])=="REGSTATUS" && (strstr (trim($match[2]),"NOREGISTER"))) $ret .= "<td><img src='./includes/images/punkt_grau.gif' onmouseover=\"Tip('" . TOOLTIP_NOREGISTRATION_REQUESTED . "')\" onmouseout='UnTip()'></td>";
			elseif (trim($match[1])=="REGSTATUS" && (trim($match[2])=="REGISTERED")) $ret .= "<td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'></td>";
			elseif (trim($match[1])=="REGSTATUS") $ret .= "<td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN<br>" . $responsecode . "')\" onmouseout='UnTip()'></td>";

			if (preg_match('/^[-]$/',$value)===1) $ret .= "</tr>";
		}

		$ret .= "<tr><td colspan='5' class='text-center'>
		<button id='stateRestart' class='btn btn-default ajaxsubmit' value='reloadsip'>SIP " .BUTTON_RELOAD. "</button></tr></td></table>";
		$ret .= "<br/><br/>";

		return $ret;
	} //end sip_state_table

	function capi_state_table($isgw) {

		$beroCapi_result=$isgw->isgw_berocapistate();

		$rows = "";
		$rows = explode("\n", $beroCapi_result);

		if (count($rows)>=5){
		$ret .= "<br><br>";
		$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
		$ret .= "<th colspan='3' class='text-center'>".STATE_BEROCAPI_STATUS_DIS."</th>";
		$ret .= "<tr><td><b>".STATE_CAPI_INSTANCE_DIS."</b></td><td><b>".STATE_LICENSE_DIS."</b></td><td><b>".STATE_STATE_DIS."</b></td></tr>";

		foreach ($rows as $value){
			$pos=strpos($value,"VIA URL");
			if($pos !== false){
				$ret .= "<tr>";
				$tmp = explode(":", $value);
				$ret .= "<td>" . $tmp[1] . "</td>";
			}//endif
			$pos=strpos($value,"LICENSE");
			if($pos !== false){
				$tmp = explode(":", $value);
				$license=explode("=",$tmp[1]);
				$ret .= "<td>" . $license[1] . "</td>";
				$ret .= "<td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'></td></tr>";
			}//endif
		}//endforeach

		$ret .= "</table><br/><br/>";
		}

		return $ret;
	} //end capi_state_table
	
	// returns HTML for beroCloud Status
    function cloud_state_table($bc) {         
       //TODI BC
        if ( ($bc->get('root', 'cloud_show_status') != 1) ) {

            if ($bc->get("root","cloud_enable")!="") {
                $ret .= "<br><br>";
                $ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
                $ret .= "<th colspan='3' class='text-center'>".STATE_CLOUD_DIS."</th>";
                $ret .= "<tr><td><b>".STATE_ALIVE_DIS."</b></td>";
                
                if ($bc->get("root","cloud_enable") == 1) {
                    $ret .= "<td ><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'></td></tr>";
                    
                } elseif ($bc->get("root","cloud_enable")==0) {
                    $ret .= "<td onmouseover='Tip(\"DOWN\")' onmouseout='UnTip()'><img src='./includes/images/punkt_rot.gif'></td></tr>";
								}
                $ret .= "</table><br/><br/>";
            }
        } //end beroCloud
        return $ret;
    } // end cloud_state_table

    //returns HTML for NIC Status
    function nic_state_table($bc) {

    	if ($bc->get("root","lan-ports") == 2) {

		$link_status_ret = explode(" ", Helper::exec($link_status_ret, '/sbin/mdio link_status|grep INFO'));
		
		$nic_state['LAN'] = $link_status_ret[array_search('LAN1', $link_status_ret)+1];
		$nic_state['WAN'] = $link_status_ret[array_search('LAN2', $link_status_ret)+1];

		$ret .= "<br/><br/>";
		$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
		$ret .= "<tr><th colspan='5' class='text-center'>".STATE_NIC_STATE_DIS."</th></tr>";
		$ret .= "<tr>";

		//LAN 1
		if ($nic_state['LAN'] == 'UP,') {
			$ret .= "<td>LAN Link</td> <td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'></td>";   
		} else {
			$ret .= "<td>LAN Link</td> <td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN')\" onmouseout='UnTip()'></td>";
		}

		//LAN2 
		if ($nic_state['WAN'] == 'UP') {
			$ret .= "<td>WAN Link</td> <td><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'></td>";   
		} else {
			$ret .= "<td>WAN Link</td> <td><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN')\" onmouseout='UnTip()'></td>";
		}

	        $ret .= "</tr></table><br/><br/>";
	}

        return $ret;

    } //end nic_state_table

    // returns HTML for PCM Status
	function pcm_state_table($ba,$isgw) {

		$pcm_result=$isgw->isgw_pcmstate();
		$pcm_server = $ba->get("pcm_server");
		if ($pcm_server!="0"  && $pcm_server!=""){


			$ret .= "<br/><br/>";
			$ret .= "<table class='table table-striped table-bordered' style='width:95% !important; margin:auto;'>";
			if ($pcm_server=="1")
				$ret .= "<tr><th>".STATE_PCM_SERVER_STATUS_DIS.":</th>";
			else
				$ret .= "<tr><th>".STATE_PCM_CLIENT_STATUS_DIS.":</th>";

			$rows = explode("\n", $pcm_result);
			$status=false;
                        $ip = exec('/sbin/ifconfig eth0 | sed -ne "s/.*inet addr:\(.*\) Bcast.*/\1/p"');
                        define ("ip_address", $ip);
			$ip="";
			for ($j=0;$j < count($rows)-2;$j++){
				$v = explode("\t", $rows[$j]);
				for ($i=0;$i < count($v);$i++){
					if ($i==1 && $j!=0 && $v[$i]!=ip_address){
						$status=true;
						$ip=$v[$i];
					}
				}
			}
			if ($status){
				$ret.="<th><img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'></th></tr>";
				if ($pcm_server=="1")
					$ret .= "<tr><td>".STATE_PCM_CLIENT_IP_DIS.":</td><td>$ip</td></tr>";
				else
					$ret .= "<tr><td>".STATE_PCM_SERVER_IP_DIS.":</td><td>$ip</td></tr>";
			}else
				$ret.="<th><img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN')\" onmouseout='UnTip()'></th></tr>";
			$ret .= "</table>";
		}

		return $ret;
	} //end pcm_state_table

	/**
	 * Generates the HTML page
	 * @return string
	 */
	function display() {

		require_once "./includes/isgwtelnet.php";
        	$name="STATE_TITLE_DIS";
		include('./includes/header.php');

		$destination = base64_encode("/app/berogui/index.php?m={$this->_m}"); 
		$ret .= '
			<script type="text/javascript">

				window.ajax_loading = false;

				$(document).on("click", ".ajaxsubmit", function(event) {

					if (window.ajax_loading == true) { return false; }
					window.ajax_loading = true; //set var, so no other ajax request is possible to send

					var stateRestart = $(this).attr("value");
					var reloadsip = false;
					var reloadisdn = false;
					var reloadgsm = false;

					if (stateRestart == "reloadsip") {
						var reloadsip=true;
					} else if (stateRestart == "reloadisdn") {
						var reloadisdn=true;
						var port_isdn=$(this).attr("value2");
					} else if (stateRestart == "reloadgsm") {
						var reloadgsm=true;
						var lif_gsm=$(this).attr("value2");
						var port_gsm1=$(this).attr("value3");
						var port_gsm2=$(this).attr("value4");
						var port_gsm=new Array(port_gsm1,port_gsm2);
					}

					$("#state_tables :button").prop("disabled", true); 
					document.getElementById("reloadWait").style.display="block";
					document.getElementById("submitResponse").style.display="none";

					$.ajax({
						type:"post",
						url:"./modules/State/state_submit.php",
						data: {  
							"reloadsip" :reloadsip,
							"reloadisdn" :reloadisdn,
							"reloadgsm" :reloadgsm,
							"port_isdn" :port_isdn,
							"lif_gsm" :lif_gsm,
							"port_gsm" :port_gsm
						},
						cache:false,
						success: function (data) {
							window.ajax_loading = false;
							$("#submitResponse").html(data);
							document.getElementById("submitResponse").style.display="block";
							document.getElementById("reloadWait").style.display="none";
							$("#state_tables :button").prop("disabled", false); 

							refresh_state();
						},
						error: function (res, errorThrown) {
							if (res.status == 408) {
								window.location.href = "./includes/login.php?reason=sess_expd&destination='.$destination.'";
								return;
							}
							window.ajax_loading = false;
							document.getElementById("submitResponse").style.display="block";
							document.getElementById("reloadWait").style.display="none";
							$("#state_tables :button").prop("disabled", false); 
						}, timeout: 300000
					});
					return false;
				});

				function refresh_state() {
					if (window.ajax_loading == true) { return false; }
					console.info("State Page refreshed");
					$.ajax({
						type: "POST",
						url: "./modules/State/state_submit.php", 
						data: {
							"refresh_state": true
						},
						success: function (data) {
							$("#state_tables").html(data);
						},
						error: function (res, errorThrown) {
							if (res.status == 408) {
								window.location.href = "./includes/login.php?reason=sess_expd&destination='.$destination.'";
							}
						}, timeout: 9000
					});  
				}

    				$(function() {
    					window.setInterval("refresh_state()", 10000);
        			});

			</script>
		';
		
		$ret .= "<br/><div id='submitResponse' class='text-center'></div>";
		$ret .= "<div id='reloadWait' class='text-center' style='display: none'>
				<br/><img src='./includes/images/waitlogo1.gif'>
				<div class='text-center'>". STATE_WAIT ."</div></br>
			</div>";

		if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$bc = new beroConf('root');
		$ba = new beroAri();
		$isgw = new isgwtelnet();
		$result=$isgw->isgw_login();
		

		//TODO: quick check, if we got isgw welcome string, $isgw->isgw_login function returns successful, even when connecting to a non-responding/stuck telnet console
		if (strncmp ($result, "wretsberoNet VoIP Gateway", 25) !== 0) {
			$ret .= ($bc->get('root', 'is-sbc-vm') == 1 ? $this->sbcvmProcessTable($bc, $bc->get('root', 'is-vpn-running') == 1, false) : $this->nic_state_table($bc)); 
			return $ret;
		}
		
		//return content and tables
		$sbcvm_table = '';
		$hardware_tables = '';
		if ($ba->get('is_sbc_vm') == 1) {
			// CLOUD SBC
			$sbcvm_table .= $this->sbcvmProcessTable($bc, $bc->get('root', 'is-vpn-running') == 1, true);
		}
		else {
			// Standard SBC

			// TODO: replace by an associative array with only the plugged modules
			//
			//		$list_plugged_modules = ['analog']; -> must be generated, stored and use by all scripts
			//
			//		$list_tables = ['analog' => 'analog_state_table'];
			//
			//		foreach ($list_modules as $module) {
			//			$function = $list_tables[$module];
			//			$hardware_tables .= $this->$function($bc, $ba, $isgw)
			//		}
			//	

			$hardware_tables = 	  $this->isdn_state_table($isgw)
						. $this->analog_state_table($isgw)
						. $this->cas_state_table($isgw)
						. $this->gsm_state_table($ba, $isgw)
						. $this->pcm_state_table($ba, $isgw)
						. $this->nic_state_table($bc);
		}

  		$ret .=	  "<div id='state_tables'>\n"
			. $hardware_tables
			. $this->sip_state_table($ba, $isgw)
			. $sbcvm_table
			. $this->capi_state_table($isgw)
			. $this->cloud_state_table($bc)
			. "</div>\n";

		//Die Datei sytem.log
		if (is_file("/var/log/system.log")){
			$fileContent=file_get_contents("/var/log/system.log");
			$ret .= "<br><br>";
			$ret .= '<script type="text/javascript">
					window.setInterval("rel()", 10000);
					function rel(){
						$.ajax({ url: \'misc/fileContent.php?filename=/var/log/system.log\', timeout: 2000, success:
							function(data) {
								var test=false;
								var bottom = $("#systemLog").attr("scrollHeight");
								//alert(bottom);
								//alert($(\'#systemLog\').scrollTop());
								if(($(\'#systemLog\').scrollTop()+200) == parseInt(bottom)){ test=true;}
								$(\'#systemLog\').html(data);
								if (test){
									var bottom = $("#systemLog").attr("scrollHeight");
									$(\'#systemLog\').scrollTop(bottom);
								}
							}
						});
					}
					</script>';

			$ret .= "<div style=' width:90%; font-size: 11pt; font-weight: bold; margin:auto;'>System log</div>
					<div id='systemLog' style='overflow:auto; padding-left:10px; background-color: #F0F0F0; border: 1px solid #CCCCCC;height:200px; width:90%; margin:auto;' >".str_replace("\n","<br/>",$fileContent)."</div>";
			$ret .= '<script type="text/javascript">
						var bottom = $("#systemLog").attr("scrollHeight");
						$(\'#systemLog\').scrollTop(bottom);
					</script>';
		}

		return $ret;
	}

		public function sbcvmProcessTable($bc, $is_vpn_running = false, $is_isgw_running = true) {
			$processes = array(
				'node' => array('action' => null, 'name' => 'beroNode', 'state' => '_sbcvmGetBeronodeState'),
			);
			if ($is_vpn_running) {
				$processes['openvpn'] = array('action' => null, 'name' => 'OpenVPN', 'state' => '_sbcvmGetOpenVpnState');
			}
			$lines[] = array('<b>'. STATE_SBCVMPROCESS_NAME_DIS .'</b>', '<b>'. STATE_SBCVMPROCESS_STATUS_DIS .'</b>', '<b>'. STATE_SBCVMPROCESS_ACTION_DIS .'</b>');
			foreach ($processes as $key => $values) {
				$get = $values['state'];
				$get = $this->$get($bc, $loaded);
				$lines[] = array($values['name'], $this->_sbcvmSetState($get), $this->_sbcvmSetAction($get['state'], $values['action']));
			}
			return HelperHtml::table(STATE_SBCVMPROCESS_TITLE_DIS, $lines, array(
				'class'		=> 'table table-striped table-bordered',
				'class-th'=> 'text-center',
				'colspan' => count($lines[0]),
				'style'		=> 'width:95%;!important;margin:auto;margin-top:'. ($is_isgw_running ? '15' : '30') .'px;',
			), "\t\t\t\t\t");
		}

		public function _sbcvmGetBeronodeState($bc, &$loaded = null) {
			require_once('/usr/local/php/include/beronode/ServerApi.php');
			$server_api = new ServerApi($loaded);
			return $server_api->state();
		}

		public function _sbcvmGetOpenVpnState($bc, &$loaded = null) {
			require_once('/usr/local/php/include/beronode/VpnApi.php');
			$vpn_api = new VpnApi($loaded);
			return $vpn_api->serverState(0, $bc->get('root', 'lan-ipaddr'));
		}

		public function _sbcvmSetAction($state, $action = null) {
			if ($state == 'RUNING' || is_null($action)) {
				return '';
			}
			return '';
		}

		public function _sbcvmSetState($res) {
			switch ($res['state']) {
			case 'ERROR':
				return "<img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('{$res['error']}')\" onmouseout='UnTip()'>";
			case 'RUNNING':
				return "<img src='./includes/images/punkt_gruen.gif' onmouseover=\"Tip('UP')\" onmouseout='UnTip()'>";
			default:
				return "<img src='./includes/images/punkt_rot.gif' onmouseover=\"Tip('DOWN')\" onmouseout='UnTip()'>";
			}
		}
}
?>
