#!/bin/bash
#
#VERSION=3
#CHANGES="Unset Variables before sourcing VERSION-File"

# global variables #
export PATH="/bin:/sbin:/usr/bin:/usr/sbin:/usr/fallback"
BEROCONF=/usr/fallback/beroconf

[ -f /usr/fallback/helper ] && source /usr/fallback/helper

# functions #
function log {
	if type -t permlog 2>&1 >/dev/null; then
		permlog "pkginst-rootfs-${2}" "[pkginst_rootfs]" "${1}" ${3}
	else
		echo "[pkginst_rootfs] $(date): ${1}" | tee -a /usr/conf/permlog/pkginst-rootfs-${2}.log 
	fi
}

function cleanPKG {
	if [ -d ${1}/conf/rootfs/pkg/${2} ]; then
		mount -oremount,rw /home/admin
		rm -r ${1}/conf/rootfs/pkg/${2}
		rm -r ${1}/conf/rootfs/pre-install/${2}
		rm -r ${1}/conf/rootfs/post-install/${2}
		mount -oremount,ro /home/admin
	fi
}

# main #
if [ "${1}" != "ON_BOOT" ] && [ "${1}" != "ON_UPDATE" ]; then
	echo "Usage: ${0} {ON_BOOT|ON_UPDATE}" >&2
	exit 1
fi

INIT_INITD=
if [ "${1}" = "ON_BOOT" ]; then
	INIT_INITD=$(ls /etc/init.d)
fi

CREATE_REBOOT_FILE=0

for i in $(/bin/ls /usr/local/conf/rootfs/VERSION.*); do

	unset PKG_NAME
	unset PKG_VERSION
	unset PKG_PATH
	unset PKG_PATH_UNSLASHED
	unset INSTALL_MODE
	unset REMV_LIST
	unset SYML_LIST

	. ${i}

	[ -z ${PKG_PATH} ] && PKG_PATH=/usr/local
	PKG_PATH_UNSLASHED=$(echo "${PKG_PATH}" | sed 's:/:\\/:g')

	# get old version of package
	if [ -f /pkginfo/VERSION.${PKG_NAME} ]; then
		PKG_VERSION_OLD="$(expr match "$(cat /pkginfo/VERSION.${PKG_NAME})" ".*PKG_VERSION=\([0-9]*\)")"
	else
		PKG_VERSION_OLD=0
	fi

	# check if this is a ON_UPDATE or ON_BOOT-package.
	if [ "${1}" = "ON_UPDATE" ] && [ "${INSTALL_MODE}" = "ON_BOOT" ]; then
		CREATE_REBOOT_FILE=1
		continue
	elif [ "${1}" = "ON_BOOT" ] && [ "${INSTALL_MODE}" = "ON_UPDATE" ]; then
		continue
	fi

	# check if ca-certs are missing
	if [[ "${PKG_NAME}" = "ca-certs" ]] && [[ ! "$(${BEROCONF} get root openssl-ca-missing | /bin/grep -v failed)" = "" ]]; then
		## continue. aka, reinstall ca-certs
		echo "continue process installation"
	# check the VERSIONs. remove only same. continue process if different
	elif [ ${PKG_VERSION} -le ${PKG_VERSION_OLD} ]; then
		if [ -d ${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME} ]; then
			cleanPKG "${PKG_PATH}" "${PKG_NAME}"
		fi
		continue
	fi

	## need installation. removing old /pkginfo/VERSION. file
	mount -o remount,rw /
	rm -f /pkginfo/VERSION.${PKG_NAME}

	## check if package exists before to install it (aka, avoid to remove old files)
	[ ! -d ${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME} ] && continue

	## check if md5sum.list present. if not, continue installing scripts
	if [ ! -f ${PKG_PATH}/conf/rootfs/md5sum.list ]; then
		touch /tmp/rootfs.issue
		continue
	fi

	# remove previous installation-logfile
	rm -f /usr/conf/permlog/pkginst-rootfs-${PKG_NAME}.log

	log "Installing Package '${PKG_NAME}' Version ${PKG_VERSION}." ${PKG_NAME} 1

	### PLEASE: no remount on mtdblock5, mtdblock6, mtdblock7 between the pre-install and post-install
	###         remounting mtdblocks are managed by the pre/post-install scripts

	# run pre-install-script
	if [ -x ${PKG_PATH}/conf/rootfs/pre-install/${PKG_NAME} ]; then
		log "Running pre-install-script for package '${PKG_NAME}'." ${PKG_NAME}
		${PKG_PATH}/conf/rootfs/pre-install/${PKG_NAME} ${PKG_VERSION} ${PKG_VERSION_OLD}

		if [ ! -d ${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME} ]; then
			log "ERROR: issue from pre-install script. Package can not be installed: '${PKG_NAME}'"
			touch /tmp/rootfs.issue
			continue
		fi
	fi

	# remove obsolete files
	for j in ${REMV_LIST}; do
		if [ -d "${j}" ]; then
			log "Removing Directory '${j}'." ${PKG_NAME}
			rm -rf ${j}
		else
			log "Removing File '${j}'." ${PKG_NAME}
			rm -rf ${j}
		fi
	done

	# install new or changed files
	file_list=$(find ${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME}/)
	file_list=${file_list//${PKG_PATH_UNSLASHED}\/conf\/rootfs\/pkg\/${PKG_NAME}/}
	for j in ${file_list}; do

		if [ -d ${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME}/${j} ] && [ ! -d ${j} ]; then
			log "Creating Directory '${j}'." ${PKG_NAME}
			mkdir -p ${j}
		fi

		if [ -f  ${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME}/${j} ]; then
			## doing md5sum check
			MD5=$(md5sum "${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME}/${j}" | awk '{ print $1; }')
			if [ "$(grep ${MD5} ${PKG_PATH}/conf/rootfs/md5sum.list)" = "" ]; then
				touch /tmp/rootfs.issue
				break
			fi
			log "Installing File '${j}'." ${PKG_NAME}
			if ! cp ${PKG_PATH}/conf/rootfs/pkg/${PKG_NAME}/${j} ${j} ; then
				touch /tmp/rootfs.issue
				break
			fi
		fi
	done

	if [ -f /tmp/rootfs.issue ]; then
		## block the failed package but continue other ones
		cleanPKG "${PKG_PATH}" "${PKG_NAME}"
		continue
	fi	

	# create symlinks
	for j in ${SYML_LIST}; do
		SYM_SRC=$(expr match "${j}" "\(.*\)=>")
		SYM_TGT=$(expr match "${j}" ".*=>\(.*\)")

		if [ -e ${SYM_TGT} ]; then
			rm -f ${SYM_TGT}
		fi
		log "Creating Symlink '${SYM_TGT}' to '${SYM_SRC}'." ${PKG_NAME}
		ln -s ${SYM_SRC} ${SYM_TGT}
	done

	# run post-install-script
	if [ -x ${PKG_PATH}/conf/rootfs/post-install/${PKG_NAME} ]; then
		log "Running post-install-script for package '${PKG_NAME}'." ${PKG_NAME}
		${PKG_PATH}/conf/rootfs/post-install/${PKG_NAME} ${PKG_VERSION} ${PKG_VERSION_OLD}
	fi

	sync; sleep 1; sync
	mount -oremount,rw /

	if [ ! -d /pkginfo ]; then
		mkdir -p /pkginfo
	fi
	cp ${i} /pkginfo

	log "Package '${PKG_NAME}' installed." ${PKG_NAME}
	sync; sleep 1; sync
	mount -oremount,ro /

	log "Removing '${PKG_NAME}'-installer from ${PKG_PATH}" ${PKG_NAME}
	sync; sleep 1; sync
	cleanPKG "${PKG_PATH}" "${PKG_NAME}"
	sync; sleep 1; sync
done

## and installation packaged failed
#### ON_UPDATE: block the reboot to be reinstalled
#### ON_BOOT: if init.d updated, block its resetting and display gui message
if [ -f /tmp/rootfs.issue ]; then
	## no need to add variable to beroConf because a warning message is displayed
	## if VERSION.{rootfs,lighttpd,recoverygui} is missing under /pkginfo
	## And it will happen if rootfs/lighttpd/recoverygui update fails
	exit 1
elif [ "${CREATE_REBOOT_FILE}" = "1" ]; then
	echo "1" > /tmp/reboot_after_update
fi

## check if /etc/init.d folder has been changed (aka, added / reorganized scripts)
if [ ! "${INIT_INITD}" = "" ]; then
	ETOTAL=0
	for init in ${INIT_INITD}; do
		for end in $(/bin/ls /etc/init.d); do
			if [ "${init}" = "${end}" ]; then
				ETOTAL=$(( ${ETOTAL} + 1 ))
			fi
		done
	done
	if [ ! "${ETOTAL}" = "$(/bin/ls /etc/init.d | /usr/bin/wc -l |	/usr/bin/tr -d ' ')" ]; then
		## files order or naming under /etc/init.d folder have been changed.
		## we start manually the other init scripts between S35pkginst and rcK/rcS (aka, do not add/reorganize init script before S35pkginst)
		for file in $(/bin/ls /etc/init.d/ | /usr/bin/tail -n +7 | /bin/egrep -v 'rcK|rcS'); do
			/etc/init.d/$file start
		done
		## other scripts started. we kill the /etc/init.d/rcS process
		kill -9 $(/bin/ps | /bin/grep '/etc/init.d/rcS' | /bin/grep -v grep | /usr/bin/awk '{ print $1; }')
	fi
fi
