<?php
require_once ("/usr/local/php/include/apiCall.class.php");
include_once("/usr/www/include/SQLite2ToSQLite3.php");
require_once('/usr/fallback/beroConf.php');
require_once('/usr/php/include/updateTool.php');

class FirmwareUpdate extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		$bc = new beroConf('root');
		if ($bc->get('root', 'boot_fwupdate') != 1) {
			$this->_execResultString = 'error:gateway_not_in_update_mode;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$upd = new updateTool();

		# everything's alright, upload file
		$ret = $upd->upload($this->_files);
		if ($ret['message'] != false) {
			$this->_execResultString = (($ret['error'] == true) ? 'failed:' : 'warning:') . ' ' . $ret['message'] . ';';
			$this->_execResult = false;
			$this->_execResponseCode = 415;
			return($this->_execResult);
		}

		if (($ret['filename'] != false) && ($ret['error'] == false)) {
			if ($upd->install($ret['filename'], false) == false) {
				$this->_execResultString = 'error:install_failed;';
				$this->_execResult = false;
				$this->_execResponseCode = 500;
				return($this->_execResult);
			}
		}

		exec('/sbin/reboot > /dev/null 2>&1 &');
		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}
	
}?>