<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/www/berogui/includes/isgwtelnet.php');
include_once("/usr/local/www/berogui/misc/database.php");
include_once("/usr/local/www/berogui/includes/Helper/Helper.php");

class GatewayLogging extends apiCall {

	function __construct ($get = null, $post = null, $files = null) {
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {
		//sanitisation
		$this->_allowedParameters += array(
			'LogServer'      => 'hostname',
			'LogPort'        => 'int-range',
			'LogLevel_Debug' => 'int-range',
			'LogLevel'       => 'int-range',
			'Enable'         => 'bool',
			'Enable_Debug'   => 'bool',
		);
		$this->_sanitizeOptions = array( 	
			'LogPort'			=> array('min' => 0 	, 'max' => 65535 ),
			'LogLevel_Debug'	=> array('min' => 0 	, 'max' => 9     ),
			'LogLevel'			=> array('min' => 0 	, 'max' => 2     ),
		);
		if($this->sanitizeInputs()==false) return $this->_execResult;

		//check if only port or server has been set 
		if((isset($this->_parameters['LogServer']) &&!isset($this->_parameters['LogPort']) )|| (isset($this->_parameters['LogPort']) &&!isset($this->_parameters['LogServer']))) {
			$this->_execResultString = 'error. missing logserver or port';
			$this->_execResult = false;
			$this->_execResponseCode = 400;
			return($this->_execResult);
		}

		$isgw = new isgwtelnet();
		$ba = new beroAri();

		$isgw->isgw_login();
		usleep(500);

		if(isset($this->_parameters['LogServer']) && isset($this->_parameters['LogPort'])){
			$isgw->logserver($this->_parameters['LogServer'], $this->_parameters['LogPort']);
			$ba->set("logserver", sqlite_escape_string($this->_parameters['LogServer'] . ":" . $this->_parameters['LogPort']));
			usleep(500);
		}

		if(isset($this->_parameters['LogLevel'])){
			$isgw->loglevel_message($this->_parameters['LogLevel']);
			$ba->set("loglevel_message", sqlite_escape_string($this->_parameters['LogLevel']));
			usleep(500);
		}

		if(isset($this->_parameters['Enable'])){
			$isgw->logactive_message($this->_parameters['Enable']);
			$ba->set("logging_message", $this->_parameters['Enable']);
			usleep(500);
		}

		if(isset($this->_parameters['Enable_Debug'])){
			$isgw->Query("ld" . $this->_parameters['Enable_Debug']);
			$ba->set("logging_debug", $this->_parameters['Enable_Debug']);
			usleep(500);
		}

		if(isset($this->_parameters['LogLevel_Debug'])){
			$isgw->Query("v" . $this->_parameters['LogLevel_Debug']);
			$ba->set("loglevel_debug", sqlite_escape_string($this->_parameters['LogLevel_Debug']));
			usleep(500);
		}

		Helper::activate(1);

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>