<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/php/include/shortMessageService.Class.php');

class SmsGetSendReport extends apiCall {
	private $_sms;

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
		$this->_sms = new ShortMessageService();
	}

	function execute () {
		
		$format = "simple";
		$reset = 0;
		if (isset($this->_parameters['Format'])) {
			if (strcasecmp ($this->_parameters['Format'], "tab") == 0) {
				$format="tab";
			}
		}
		if (isset($this->_parameters['Reset'])) {
			$reset = 1;
		}
		
		if (($sendReport = $this->_sms->getSendReport($format, $reset)) === false) {
			$this->_execResultString = 'error:no_send_report_found;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}
		$this->_execResultString .= "\n\n" . $sendReport;

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>