<?php

/**
 * Einstellungen die unter keine andere Kategorie passen.
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Miscellaneous {

	private		$m_attr;

	private		$post_attr,
			$post_checked = 0;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array()) {
		$this->m_attr = $m;

		if ($post['action'] == 'save') {
			// clean post
			unset($post['m'], $post['a'], $post['action'], $post['submit']);

			// check post
			$list_post = array(
				'experimental_options' => 'config-option', 'international_code' => 'international-code', 'national_code' => 'int>=0',
				'reject_calls_under_load' => 'bool','ignore_hw_conf' => 'bool', 'emergency_numbers' => 'int-piped', 'device_name' => array('&&', 'alphanumeric', 'str-length'),
			);

			$options_post = array(
				'device_name' => array('min' => 0, 'max' => 15),
			);

			$this->post_checked = 1;
			$this->post_attr['data'] = Helper::sanitizePost($post['data'], $list_post, $this->post_checked, $this->reasonRejected, $options_post);
			$this->isRequestRejected = !$this->post_checked;
		}
	}

	/**
	 * @return string HTML code
	 */
	function _display_tabs($ba, $bc) {
		$html_str =	"<br/>\n<br/>\n"
							.	"<script>\n"
              .	"\t$(function() {\n" 
							.	"\t\t$( '#tabs' ).tabs({active:0})\n"
							.	"\t});\n"
							.	"</script>\n"
							. "<!-- BEGIN TABS //-->\n\n"
							. "<div id='tabs' class=''>\n"
							. "\t<ul>\n"
							.	"\t\t<li><a href='#tabs-1'>". MISCELLANEOUS_TABLE_HEADER_DIS ."</a></li>\n"
							. "\t</ul>\n"
							. $this->_display_tab1($ba, $bc)
							.	"\n<!-- END TABS //-->\n"
							. "</div>\n\n";

		return $html_str;
	}

	/**
	 * @return string HTML code
	 */
	function _display_tab1($ba, $bc) {
		$experimental_options = explode(',', $ba->get("experimental_options"));
		foreach (array('debug', 'verifyhost', 'verifypeer') as $key) {
			$val = $bc->get('root', "openssl_$key");
			if (strlen($val)) {
				$experimental_options[] = "openssl_$key=$val";
			}
		}
		if ($ba->get('gui_mode') == 'simple') $simple_class = 'simple';
		ob_start();
		?>
		<!-- BEGIN TAB1 //-->
		<div id="tabs-1">
			<form name='miscellaneous' id='misc-form' class = "form-horizontal" action='' style="margin-top: 15px;" method='POST'>
				<input type=hidden name=m value='<?php echo $this->m_attr ?>'>
				<input type=hidden name=a value='save'>
				<div class='form-group' data-toggle='tooltip' title='<?php echo MISCELLANEOUS_DEVICE_NAME_TOOLTIP; ?>'>
					<label for='for_device_name' class='col-sm-5 control-label'><?php echo MISCELLANEOUS_DEVICE_NAME_DIS ?></label>
					<div class='col-sm-4'>
						<input type='text' class='form-control' id='id_device_name' name='data[device_name]' value='<?php echo $ba->get("device_name"); ?>'>
					</div>
				</div>
				<div class='form-group <?php echo $simple_class ?>'>
					<label for='experimental_options' class='col-sm-5 control-label'><?php echo MISCELLANEOUS_EXPERIMENTAL_OPTIONS_DIS ?></label>
					<div class='col-sm-4'>
						<input type='text' class='form-control' id='experimental_options' name='data[experimental_options]' value='<?php echo implode(',', array_filter($experimental_options)); ?>'>
					</div>
				</div>
				<div class='form-group <?php echo $simple_class ?>'>
					<label for='reject_calls_under_load' class='col-sm-5 control-label'><?php echo MISCELLANEOUS_REJECT_CALLS_UNDER_LOAD_DIS ?></label>
					<div class='col-sm-4 form-checkbox'>
						<?php echo $this->reject_calls_under_load($ba) ?>
					</div>
				</div>
				<div class='form-group <?php echo $simple_class ?>' data-toggle='tooltip' title='<?php echo MISCELLANEOUS_IGNORE_HW_CONF_TT; ?>'>
					<label for='ignore_hw_conf' class='col-sm-5 control-label'><?php echo MISCELLANEOUS_IGNORE_HW_CONF ?></label>
					<div class='col-sm-4 form-checkbox'>
						<?php echo $this->ignore_hw_conf($bc) ?>
					</div>
				</div>
				<div class='form-group' data-toggle='tooltip' title='<?php echo ISDN_COUNTRY_CODE; ?>'>
					<label for='international_code' class='col-sm-5 control-label'><?php echo DIALPLAN_SIP_INTERNATIONAL_CODE_DIS ?></label>
					<div class='col-sm-4'>
						<input type='text' class='form-control' id='international_code' name='data[international_code]' value='<?php echo $ba->get("international_code") ?>'>
					</div>
				</div>
				<div class='form-group' data-toggle='tooltip' title='<?php echo ISDN_CITY_CODE; ?>'>
					<label for='national_code' class='col-sm-5 control-label'><?php echo DIALPLAN_SIP_NATIONAL_CODE_DIS ?></label>
					<div class='col-sm-4'>
						<input type='text' class='form-control' id='national_code' name='data[national_code]' value='<?php echo $ba->get("national_code") ?>'>
					</div>
				</div>
				<div class='form-group' data-toggle='tooltip' title='<?php echo MISCELLANEOUS_EMERGENCY_NUMBERS; ?>'>
					<label for='emergency_numbers' class='col-sm-5 control-label'><?php echo SIP_EMERGENCY_NUMBERS ?></label>
					<div class='col-sm-4'>
						<input type='text' class='form-control' id='emergency_numbers' name='data[emergency_numbers]' value='<?php echo $ba->get("emergency_numbers") ?>'>
					</div>
				</div>
				<div class='text-center'>
					<input type='hidden' name='action' value='save'>
					<input name='submit' class='btn btn-default'  type='submit' value='<?php echo BUTTON_SAVE ?>' >
				</div>
			</form>
		</div>
		<script type='text/javascript'>
			function show_tr_adminPass() {
				if ($('#userapp-enabled').is(':checked'))
					$('#admin-pass').css('display', '');
				else
					$('#admin-pass').css('display', 'none');
			}
			$('#userapp-enabled').change(function () {
				show_tr_adminPass();
			});
			$(document).ready(function () {
				show_tr_adminPass();

				$("#misc-form").validate({
					rules: {
						'data[emergency_numbers]': {
							checkIntPiped: true
						},
						'data[experimental_options]': {
							checkManual: true
						},
						'data[international_code]': {
							checkPhoneNumber: true
						},
						'data[national_code]': {
							digits: true
						},
						'data[device_name]': {
							alphanumeric:true,
								maxlength: 15,
						},
					},
					highlight: function (element) {
						$(element).closest('.form-group').addClass('has-error');
					},
					unhighlight: function (element) {
						$(element).closest('.form-group').removeClass('has-error');
					}
				});
			});
		</script>
		<?php
		return(ob_get_clean());
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML code
	 */
	function display() {#
		require_once('/usr/fallback/beroConf.php');
		$bc = new beroConf('root');

		$name = "MISCELLANEOUS_TITLE_DIS";
		include('./includes/header.php');
		require_once("./includes/lang.php");

		$ba = new beroAri();

		//Save changes
		if ($this->post_checked) {
			$option = 1;
			if ($this->post_attr['data']['emergency_numbers'] != $ba->get("emergency_numbers")) {
				$option = 2;
			}
			// openssl experimental options
			foreach (array('debug', 'verifypeer', 'verifyhost') as $what) {
				if (preg_match("/openssl_$what=(?<val>0|1)/", $this->post_attr['data']['experimental_options'], $matched)) {
					$bc->set('root', "openssl_$what", $matched['val']);
					$this->post_attr['data']['experimental_options'] = str_replace("openssl_{$what}={$matched['val']}", '', $this->post_attr['data']['experimental_options']);
				}
				else {
					$bc->delete('root', "openssl_$what");
				}
			}

			$this->post_attr['data']['experimental_options'] = implode(',', array_filter(explode(',', $this->post_attr['data']['experimental_options'])));
		 	if ($this->post_attr['data']['experimental_options'] != $ba->get("experimental_options")) {
				$option = 3;
			}


			if (isset($this->post_attr['data']['ignore_hw_conf'])) {
				if ($this->post_attr['data']['ignore_hw_conf'] != $bc->get('root','ignore_hw_conf')) {
					$bc->set('root', 'ignore_hw_conf', $this->post_attr['data']['ignore_hw_conf']);
				}
				unset($this->post_attr['data']['ignore_hw_conf']);
			}


			foreach($this->post_attr['data'] as $key => $value) {
				$ba->set($key, sqlite_escape_string($value));
			}

			$ret .= Helper::activate($option, true, $this->m_attr, ACTIVATE);
		}
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		//Return: Site content
		$ret .= $this->_display_tabs($ba, $bc);
		return $ret;
	}

	/**
	 * Generates the checkbox reject calls under load
	 * @return string
	 */
	function reject_calls_under_load($ba) {
		$option = $ba->get("reject_calls_under_load");
		if ($option == "1") {
			$checked = "checked";
		}
		ob_start();
		?>
		<input type='hidden' name='data[reject_calls_under_load]' value='0'>
		<input type='checkbox' name='data[reject_calls_under_load]' value='1' <?php echo $checked ?>>
		<?php
		return ob_get_clean();
	}

	// generate checkbox ignore_hw_conf (see /etc/init.d/S30core-modules)
	function ignore_hw_conf($bc) {
		$option = $bc->get("root", "ignore_hw_conf");
		if ($option == "1") {
			$checked = "checked";
		}
		ob_start();
		?>
		<input type='hidden' name='data[ignore_hw_conf]' value='0'>
		<input type='checkbox' name='data[ignore_hw_conf]' value='1' <?php echo $checked ?>>
		<?php
		return ob_get_clean();
	}
}
?>
