<?php
require_once ("/usr/local/php/include/apiCall.class.php");

class ApiUserEnable extends apiCall {
	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}
	
	function execute () {

		//sanitize
		$this->_allowedParameters +=array('Set'=>'match');
		$this->_sanitizeOptions = array('Set'=> "^enabled$|^disabled$");

		if ($this->sanitizeInputs()==false) return $this->_execResult;
		

		$fileName = '/usr/conf/apiusers.conf';
		$apiUsers = file_get_contents($fileName);

		if (strstr($apiUsers, '# provisioning:')) {		// user is disabled
			if ($this->_parameters['Set'] == 'enabled') {
				$this->_execResult = (file_put_contents($fileName, str_replace('# provisioning', 'provisioning', $apiUsers)) === false) ? false : true;
				$this->_execResponseCode = ($this->_execResult == true) ? 200 : 500;
			}

			return($this->_execResult);
		} else if (strstr($apiUsers, 'provisioning:')) {	// user is enabled
			if ($this->_parameters['Set'] == 'disabled') {
				$this->_execResult = (file_put_contents($fileName, str_replace('provisioning', '# provisioning', $apiUsers)) === false) ? false : true;
				$this->_execResponseCode = ($this->_execResult == true) ? 200 : 500;
			}

			return($this->_execResult);
		}

		// user does not exist
		$apiUsers .= "\n" . (($this->_parameters['Set'] == 'enabled') ? '' : '# ') . 'provisioning:YWG41BPzVAkN6';
		$this->_execResult = (file_put_contents('/usr/conf/apiusers.conf', $apiUsers) === false) ? false : true;
		$this->_execResponseCode = ($this->_execResult == true) ? 200 : 500;

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . ($this->_execResult ? 'success' : 'error'));
	}

}
?>
