<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/www/berogui/includes/isgwtelnet.php');

class TelephonyGetInfo extends apiCall {

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
	}

	function execute () {

		if (!isset($this->_parameters['Action']) || empty($this->_parameters['Action'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$isgw = new isgwtelnet();
		if (!($result = $isgw->isgw_login())) {
			$this->_execResultString = 'error:login_failed;';
			$this->_execResult = false;
			$this->_execResponseCode = 500;
			return($this->_execResult);
		}

		$this->_execResultString .= "\n" . trim($isgw->isgw_transparent($this->_parameters['Action']));

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>