#!/bin/bash

export PATH=$PATH:/usr/local/sbin

TCPDUMP=$(/usr/bin/which tcpdump)

## wrapper script for logrotating tcpdump, first parameter is outfile name, second limit in MegaBytes,
## then the real tcpdump parameters
outfile=$1
shift
limit=$1
shift

while true; do
	#echo "$TCPDUMP -C $limit -w $outfile $@"
	$TCPDUMP -C $limit -w $outfile $@ &> /dev/null

	if [ $? = 0 ]; then
		newoutfile=`echo $outfile|sed 's/.pcap$/.1.pcap/'`
	fi
	[ -f $outfile ] && \mv "$outfile" "$newoutfile"
done



