<?php

/**
 * Implementiert die Einstellung der Logging Parameter
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Logging {

	private	$m_attr;

	private	$isIsgwLoginFailed = 0;

	private	$isRequestRejected = 0,
			$reasonRejected = array();
                
	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		// set main GET variable
		$this->m_attr = $m;

		// isgw failed to start on submit page
		if(isset($get['isgwerror'])) {
			$this->isIsgwLoginFailed = 1;
			unset($get['isgwerror']);
		}
		// get error from submit
		else if (isset($get['error'])) {
			$this->isRequestRejected = 1;
			$this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
			unset($get['error'], $get['request'], $get['checkor'], $get['key']);
		}
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML code
	 */

	function display() {
		require_once ('./includes/isgwtelnet.php');

		$name = "LOGGING_TITLE_DIS";
		include('./includes/header.php');

		$general_table = $this->dynamic_table();
		// build page content
		$ret .= $general_table;
		return $ret;
	}

	/**
	 *@return string Die Adresse von dem Loging Server
	 */

	function address($ba) {
		$logserver = $ba->get("logserver");
		$ret = explode(":", $logserver);
		return $ret[0];
	}

	/**
	 * @return string Syslog dropdown
	 */

	function syslog($ba) {
		$option = $ba->get("syslog_facility");
		$sel = "<select name='syslog_facility' class='form-control input-sm'>";
		$j = 0;
		for ($i = 16; $i <= 23; $i++) {
			if ($option == $i)
				$sel .= '<option value=\'' . $i . '\' selected>' . $i . ' - local ' . $j++ . '</option>';
			else
				$sel .= '<option value=\'' . $i . '\'>' . $i . ' - local ' . $j++ . '</option>';
		}
		$sel .= "</select>";
		return $sel;
	}

	/**
	 * @param string $log Name für dropdown
	 * @return string Loglevel Dropdown
	 */

	function loglevel($ba, $log) {
		$loglevel = $ba->get($log);
		$ret .= "<select name='$log' class='form-control input-sm'>";
		($log == "loglevel_message") ? $j = 2 : $j = 9;
		for ($i = 0; $i <= $j; $i++) {
			($i == $loglevel) ? $selected = "selected" : $selected = "";
			$ret .= "<option value='$i' $selected>$i</option>";
		}
		$ret .= "</select>";
		return $ret;
	}

	/**
	 * @return string Das Port von dem Logserver
	 */

	function port($ba) {
		$logserver = $ba->get("logserver");
		$ret = explode(":", $logserver);
		return $ret[1];
	}

	function logdebug_max_filesize($ba) {
		$max_filesize = (int) $ba->get("logsizelimit");
		if ($max_filesize == 0) {
			return 1000000;
		}
		return $max_filesize ;
	}

	function lognmessage_max_filesize($ba) {
		$max_filesize = (int) $ba->get("nlogsizelimit");
		if ($max_filesize == 0) {
			return 500000;
		}
		return $max_filesize ;
	}
	
	/**
	 * @param beroAri Name für checkbox
	 * @return string Checkbox zum log aktivieren
	 */

	function active($ba, $log) {
		$active = $ba->get($log);
		$checked = ($active == "1") ?  "checked" : "";
		return "<input type='checkbox' name='$log' value='1' $checked>";
	}

	/**
	 * @param beroConf $bc
	 * @return string Checkbox enable system log
	 */

	function systemLog($bc) {
		$sysLog = $bc->get("root", "system-check-enabled");
		if ($sysLog == "1") {
			return "<input type='hidden' name='system-check-enabled' value='0'>"
			. "<input type='checkbox' name='system-check-enabled' value='1' checked>";
		} else {
			return "<input type='hidden' name='system-check-enabled' value='0'>"
			. "<input type='checkbox' name='system-check-enabled' value='1'>";
		}
	}

	/**
	 * Generiert das Formular für die Logging Einstellungen
	 * @return string HTML Code
	 */

	function dynamic_table() {
		require_once('/usr/fallback/beroConf.php');
		require_once("./includes/lang.php");
		$ba = new beroAri();
		$bc = new beroConf('root');
		//Logging Änderungen speichern

		// get isgw login from submit
		if ($this->isIsgwLoginFailed) {
			$table .= "<br><div class='text-center' style='color:red; margin-top:5px;'>".WARNING_MESSAGE_ISGW_SAVE."</div>";
		}
		// error from submit
		else if ($this->isRequestRejected) {
			$table .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		ob_start();
		?>
		<form name='logging_form' id='logging-form' class="form-horizontal" action='modules/Logging/logging_submit.php' method='POST'>
			<input type=hidden name=m value='<?php echo $m ?>'>
			<input type=hidden name=a value='save'>
			<br>
			<p class="text-center lead">
				<?php echo LOGGING_TABLE_HEADER_DIS ?>
			</p>
			<div class='form-group' data-toggle='tooltip' title='<?php echo GENERAL_ADDRESS; ?>'>
				<label for='address' class='col-sm-5 control-label'><?php echo LOGGING_SERVER_DIS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control input-sm' name='address' value='<?php echo $this->address($ba) ?>'>
				</div>
			</div>
			<div class='form-group' data-toggle='tooltip' title='<?php echo GENERAL_PORT; ?>'>
				<label for='port' class='col-sm-5 control-label'><?php echo LOGGING_SERVER_PORT_DIS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control input-sm' id='port' name='port' value='<?php echo $this->port($ba) ?>'>
				</div>
			</div>
			
			<div class='form-group'>
				<label for='syslog_facility' class='col-sm-5 control-label'><?php echo LOGGING_SYSLOG_DIS ?></label>
				<div class='col-sm-4'>
					<?php echo $this->syslog($ba) ?>
				</div>
			</div>
			<p class="text-center lead">
				<?php echo LOGGING_LOGLEVEL_HEADER_DIS ?>
			</p>
			<div class='form-group' data-toggle='tooltip' title='<?php echo LOGGING_MESSAGE_ACTIVE; ?>'>
				<label for='logging_message' class='col-sm-5 control-label'><?php echo LOGGING_MESSAGE_ACTIVE_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->active($ba, 'logging_message') ?>
				</div>
			</div>
			<div class='form-group' data-toggle='tooltip' title='<?php echo LOGGING_MESSAGE_LOGLEVEL; ?>'>
				<label for='loglevel_message' class='col-sm-5 control-label'><?php echo LOGGING_MESSAGE_LEVEL_DIS ?></label>
				<div class='col-sm-4'>
					<?php echo $this->loglevel($ba, 'loglevel_message') ?>
				</div>
			</div>

			<div class='form-group' data-toggle='tooltip' title='<?php echo LOGGING_DEBUG_ACTIVE; ?>'>
				<label for='logging_debug' class='col-sm-5 control-label'><?php echo LOGGING_DEBUG_ACTIVE_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->active($ba, 'logging_debug') ?>
				</div>
			</div>
			<div class='form-group' data-toggle='tooltip' title='<?php echo LOGGING_DEBUG_LOGLEVEL; ?>'>
				<label for='loglevel_debug' class='col-sm-5 control-label'><?php echo LOGGING_DEBUG_LEVEL_DIS ?></label>
				<div class='col-sm-4'>
					<?php echo $this->loglevel($ba, 'loglevel_debug') ?>
				</div>
			</div>
			
			<p class="text-center lead">
				<?php echo LOGGING_LOGLEVEL_OTHER_DIS ?>
			</p>
			
			<div class='form-group' data-toggle='tooltip' title='<?php echo LOGGING_DEBUG_LOG_MAX_FILESIZE; ?>'>
				<label for='loglevel_debug' class='col-sm-5 control-label'><?php echo LOGGING_DEBUG_LOG_MAX_FILESIZE_DIS ?></label>
				<div class='col-sm-4'>
				<input type='text' class='form-control input-sm' name='logsizelimit' value='<?php echo $this->logdebug_max_filesize($ba) ?>'>
					
				</div>
			</div>
			
			<div class='form-group' data-toggle='tooltip' title='<?php echo LOGGING_NMESSAGE_ACTIVE; ?>'>
				<label for='logging_nmessage' class='col-sm-5 control-label'><?php echo LOGGING_NMESSAGE_ACTIVE_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->active($ba, 'logging_nmessage') ?>
				</div>
			</div>
			<div class='form-group' data-toggle='tooltip' title='<?php echo LOGGING_NMESSAGE_LOG_MAX_FILESIZE; ?>'>
				<label for='loglevel_debug' class='col-sm-5 control-label'><?php echo LOGGING_NMESSAGE_MAX_FILESIZE_DIS ?></label>
				<div class='col-sm-4'>
					<input type='text' class='form-control input-sm' name='nlogsizelimit' value='<?php echo $this->lognmessage_max_filesize($ba) ?>'>
				</div>
			</div>
			
			<div class='form-group'>
				<label for='system-check-enabled' class='col-sm-5 control-label'><?php echo LOGGING_SYSTEM_LOG_DIS ?></label>
				<div class='col-sm-4 form-checkbox'>
					<?php echo $this->systemLog($bc) ?>
				</div>
			</div>

			<br>
			<div class='text-center'>
				<input name='submit' type='submit' class='btn btn-default' value='<?php echo BUTTON_SAVE ?>'>
			</div>
			<br>
		</form>
		<script type='text/javascript'>
			$("#logging-form").validate({
				rules: {
			             	address: {
				              checkHostname: true,
			             	},
					port: {
						range: [0, 65535],
					},
					logsizelimit: {
						range: [100000, 2000000],
					},
					nlogsizelimit: {
						range: [100000, 2000000],
					},
               			}
                        });
		</script>
		<?php
		$table .= ob_get_clean();

		//Rückgabe: Erzeugte Tabelle mit den änderbaren Feldern von den Einstellungen von isgw.conf
		return $table;
	}

}
