<?php

class NetworkWizard
{

	// Network Mode
	private $lanmode	= array('id' => 'lan-mode', 'name' => 'lan_mode', 'postCheck' => 'select', 'options' => array('single', 'lan-wan'));

	// LAN
	var $lanstatic  = array('id' => 'lan-static'	, 'name' => 'lan_static', 'title' => NETWORK_STATIC_DIS , 'tooltip' => '', 'type' => 'radio');
	var $landhcp    = array('id' => 'lan-dhcp'	, 'name' => 'lan_dhcp'	, 'title' => 'DHCP'		, 'tooltip' => '', 'type' => 'radio', 'postCheck' => 'bool', 'options' => array());

	var $lanip 	= array('id' => 'lan-ipaddr'	, 'name' => 'lan_ipaddr' , 'title' => NETWORK_IP_ADDRESS_DIS, 'tooltip' => NET_CONF_IP_ADDRESS, 'type' => 'text', 'postCheck' => 'ip4', 'options' => array());
	var $lannetmask = array('id' => 'lan-netmask'	, 'name' => 'lan_netmask', 'title' => NETWORK_NETMASK_DIS   , 'tooltip' => NET_CONF_NETMASK   , 'type' => 'text', 'postCheck' => 'ip4', 'options' => array());
	var $langateway	= array('id' => 'lan-gateway'	, 'name' => 'lan_gateway', 'title' => NETWORK_GATEWAY_DIS   , 'tooltip' => NET_CONF_GATEWAY   , 'type' => 'text', 'postCheck' => 'ip4', 'options' => array());
 
	// WAN
	var $wanstatic  = array('id' => 'wan-static'	, 'name' => 'wan_static', 'title' => NETWORK_STATIC_DIS , 'tooltip' => '', 'type' => 'radio');
	var $wandhcp    = array('id' => 'wan-dhcp'  	, 'name' => 'wan_dhcp'	, 'title' => 'DHCP'		, 'tooltip' => '', 'type' => 'radio', 'postCheck' => 'bool', 'options' => array());

	var $wanip	= array('id' => 'wan-ipaddr' 	, 'name' => 'wan_ipaddr' , 'title' => NETWORK_IP_ADDRESS_DIS, 'tooltip' => NET_CONF_IP_ADDRESS, 'type' => 'text', 'postCheck' => 'ip4', 'options' => array());
	var $wannetmask	= array('id' => 'wan-netmask'	, 'name' => 'wan_netmask', 'title' => NETWORK_NETMASK_DIS   , 'tooltip' => NET_CONF_NETMASK   , 'type' => 'text', 'postCheck' => 'ip4', 'options' => array());
	var $wangateway	= array('id' => 'wan-gateway'	, 'name' => 'wan_gateway', 'title' => NETWORK_GATEWAY_DIS   , 'tooltip' => NET_CONF_GATEWAY   , 'type' => 'text', 'postCheck' => 'ip4', 'options' => array());

	// DNS
	var $dnsnameserver	= array('id' => 'lan-nameserver' , 'name' => 'lan_nameserver' , 'title' => NETWORK_PRIMARY_NAME_SERVER_DIS  , 'tooltip' => NET_CONF_NAMESERVER		, 'type' => 'text', 'postCheck' => 'ip4'	, 'options' => array());
	var $dnsnameserver2	= array('id' => 'lan-nameserver2', 'name' => 'lan_nameserver2', 'title' => NETWORK_SECONDARY_NAME_SERVER_DIS, 'tooltip' => NET_CONF_SECONDARY_NAMESERVER, 'type' => 'text', 'postCheck' => 'ip4'	, 'options' => array());
	var $dnshostname 	= array('id' => 'hostname'	 , 'name' => 'hostname'	      , 'title' => NETWORK_HOSTNAME_DIS		    , 'tooltip' => ''				, 'type' => 'text', 'postCheck' => 'hostname'	, 'options' => array());

	function __construct ()
	{
	}

	// Private Functions

// function used by recreate.php script to get all the paramaters to delete
	function _get_post_list()
	{
		return	array(	$this->lanmode	, $this->landhcp	, $this->lanip		, $this->lannetmask	, $this->langateway	, $this->wandhcp	, 
				$this->wanip	, $this->wannetmask	, $this->wangateway	, $this->dnsnameserver	, $this->dnsnameserver2	, $this->dnshostname	);
	}

	function _only_id_and_name ($variable)
	{
		return array('id' => $variable['id'], 'name' => $variable['name']);
	}

	function _get_parameter_value ($bc, $network_cfg, $parameter, $type = 'dns', &$dhcp_checked = '', &$static_checked = '')
	{
		$value = '';
		if (!(isset($network_cfg[$parameter['name']])))
		{
			$bool_nameserver  = (strcmp($parameter['id'], $this -> dnsnameserver['id']) == 0);
			$bool_nameserver2 = (strcmp($parameter['id'], $this -> dnsnameserver2['id']) == 0);

			if ($bool_nameserver || $bool_nameserver2)
			{
	        		$nameserver = $bc -> get('root', $this -> dnsnameserver['id']);
	        		$dns = explode(';', $nameserver);

	        		$dhcp = in_array($bc -> get('root', $this -> landhcp['id']), array('yes', '1'));
	        		if ($dhcp)
	        		{
	        		        $dns[0]         = '8.8.8.8';
	        		        $dns[1]         = '8.8.4.4';
	               			$dhcp_checked   = 'checked';
	               			$static_checkd  = '';
	       	 		}

				$value = ($bool_nameserver ? $dns[0] : $dns[1]);
			}
			else 
			{
				$value = $bc -> get('root', $parameter['id']);
			}
		}

	        return (isset($network_cfg[$parameter['name']]) ? $network_cfg[$parameter['name']] : $value );
	}

	function _display_simple_field ($type, $input_field, $value = '', $javascript = '', $tab = "\t\t\t")
	{
	        $class = "class='form-control input-sm $type'";
	        if (strcmp($type, 'checkbox') == 0)
	        {
	                $class = "class='$type'";
	        }

	        return    $tab. "<div class='form-group' id='{$input_field['id']}-tr'>\n"
	           	. $tab. "\t<label for='{$input_field['name']}' class='col-sm-3 control-label'>{$input_field['title']}</label>\n"
	          	. $tab. "\t<div class='col-sm-8'>\n"
	          	. $tab. "\t\t<input type='{$input_field['type']}' $class data-toggle='tooltip' name='{$input_field['name']}' id='{$input_field['id']}' title='{$input_field['tooltip']}' value='$value' $javascript/>\n"
	          	. $tab. "\t</div>\n"
	          	. $tab. "</div>\n";
	}

	function _display_network_mode ($bc, $network_cfg)
	{
	        $lan_selected    = 'selected';
	        $lanwan_selected = '';

        	if (isset($network_cfg['Mode']))
        	{
        	        if (strcmp($network_cfg['Mode'], 'lan-wan') == 0)
        	        {
        	                $lan_selected    = '';
        	                $lanwan_selected = 'selected';
        	        }
        	}
        	else
        	{
           	     if (strcmp($bc -> get('root', $this -> id_lanmode), 'lan-wan') == 0)
           	     {
           	             $lan_selected    = '';
           	             $lanwan_selected = 'selected';
           	     }
        	}

        	ob_start();
?>
			<div class='form-group' style='margin-top: 15px;'>
				<label for='bonding-mode' class='col-sm-5 control-label'><?php echo NETWORK_LAN_MODE_DIS; ?></label>
				<div class='col-sm-4'>
					<select class="form-control input-sm" name="<?php echo $this -> lanmode['name']; ?>" id="<?php echo $this -> lanmode['id']; ?>">
						<option value="single" <?php echo $lan_selected; ?>> Single mode</option>
						<option value="lan-wan" <?php echo $lanwan_selected; ?>> LAN-WAN</option>
					</select>
				</div>
			</div>
<?php
        	return ob_get_clean();
	}

	function _display_lan_settings ($bc, $network_cfg, &$dhcp_checked, &$static_checked, $type = 'lan')
	{
		$lan_ipaddr 	 = $this -> _get_parameter_value($bc, $network_cfg, $this -> lanip	, $type, $dhcp_checked, $static_checked);
		$lan_netmask 	 = $this -> _get_parameter_value($bc, $network_cfg, $this -> lannetmask , $type, $dhcp_checked, $static_checked);
		$lan_gateway 	 = $this -> _get_parameter_value($bc, $network_cfg, $this -> langateway , $type, $dhcp_checked, $static_checked);

        	$html_str = '';
        	ob_start();
?>
			<p class="text-center h5" id="header-lan"><?php echo NETWORK_LAN_SETTING_DIS; ?></p>
			<div class="form-group" id="<?php echo $this -> id_landhcp; ?>-tr">
				<div class="text-center">
					<input type="radio" name="<?php echo $this -> landhcp['name']; ?>" id="<?php echo $this -> landhcp['id']; ?>" onclick="hide_netconfig(document.getElementById('<?php echo $this -> lanstatic['id']; ?>').checked);"
														data-toggle="tooltip" title="<?php echo NET_CONF_DHCP; ?>" value="1" <?php echo $dhcp_checked; ?>/> DHCP
					<input type="radio" name="<?php echo $this -> landhcp['name']; ?>" id="<?php echo $this -> lanstatic['id']; ?>" onclick="hide_netconfig(document.getElementById('<?php echo $this -> lanstatic['id']; ?>').checked);"
															data-toggle="tooltip" title="<?php echo NET_CONF_STATIC;?>" value="0" <?php echo $static_checked;?>/><?php echo NETWORK_STATIC_DIS; ?>
				</div>
			</div>
<?php
		$javascript_netmask = 'onclick="if (document.getElementById(\''. $this -> lannetmask['id'] .'\').value == \'\') netmask.value = makeNetMask(document.getElementById(\''. $this -> lanip['id'] .'\').value);"';

        	$html_str .=      ob_get_clean()
                	        . $this -> _display_simple_field($type, $this -> lanip		, $lan_ipaddr )
                	        . $this -> _display_simple_field($type, $this -> lannetmask	, $lan_netmask, $javascript_netmask  )
                        	. $this -> _display_simple_field($type, $this -> langateway	, $lan_gateway);

        	return $html_str . ob_get_clean();
	}

	function _display_wan_settings ($bc, $network_cfg, &$dhcp_checked, &$static_checked, $type = 'wan')
	{
		$wan_ipaddr 	= $this -> _get_parameter_value($bc, $network_cfg, $this -> wanip     , $type, $dhcp_checked, $static_checked);
		$wan_netmask	= $this -> _get_parameter_value($bc, $network_cfg, $this -> wannetmask, $type, $dhcp_checked, $static_checked);
		$wan_gateway	= $this -> _get_parameter_value($bc, $network_cfg, $this -> wangateway, $type, $dhcp_checked, $static_checked);

	        $html_str = '';

		$wan_onclick = "onclick=\"hide_wan($('#". $this -> wanstatic['id'] ."').prop('checked'));\"";

	        ob_start();
?>
			<div id="wan">
				<p class="text-center h5"><?php echo NETWORK_WAN_SETTING_DIS; ?></p>
				<div class='form-group'>
					<div class='text-center'>
						<input type="<?php echo $this -> wandhcp['type']; ?>" name="<?php echo $this -> wandhcp['name']; ?>" id="<?php echo $this -> wandhcp['id']; ?>" <?php echo $wan_onclick; ?> value="1" <?php echo $dhcp_checked; ?>>
						&nbsp; <?php echo $this -> wandhcp['title']; ?>
						<input type="<?php echo $this -> wanstatic['type']; ?>" name="<?php echo $this -> wandhcp['name']; ?>" id="<?php echo $this -> wanstatic['id']; ?>" <?php echo $wan_onclick; ?> value="0" <?php echo $static_checked; ?>>
						&nbsp; <?php echo $this -> wanstatic['title']; ?>
					</div>
				</div>
<?php
        	$html_str .=      ob_get_clean()
        	                . $this -> _display_simple_field($type, $this -> wanip		, $wan_ipaddr )
        	                . $this -> _display_simple_field($type, $this -> wannetmask	, $wan_netmask)
        	                . $this -> _display_simple_field($type, $this -> wangateway	, $wan_gateway);

        	ob_start();
?>
			</div>
<?php
       		return $html_str . ob_get_clean();
	}

	function _display_dns_settings ($bc, $network_cfg, $type = 'dns', $tab = "\t\t\t")
	{
		$dns_nameserver  = $this -> _get_parameter_value($bc, $network_cfg, $this -> dnsnameserver );
		$dns_nameserver2 = $this -> _get_parameter_value($bc, $network_cfg, $this -> dnsnameserver2);
		$dns_hostname 	 = $this -> _get_parameter_value($bc, $network_cfg, $this -> dnshostname   );
				

		return 	  $tab. "<p class='text-center h5'>". NETWORK_DNS_SETTING_DIS ."</p>\n"
			. $this -> _display_simple_field($type, $this -> dnsnameserver	, $dns_nameserver )
                        . $this -> _display_simple_field($type, $this -> dnsnameserver2	, $dns_nameserver2)
                        . $this -> _display_simple_field($type, $this -> dnshostname 	, $dns_hostname	  );
	}

	function _lan_wan_summary_settings($ipdhcp, $network_names, $network_settings, &$title_prmtr, &$value_prmtr, &$colspan)
	{
		$i = 0;
		if ($network_settings[$ipdhcp])
		{
			$title_prmtr = "<td>". WIZARD_NETWORK_MODE_DIS ."</td>";
			$value_prmtr = "<td>DHCP</td>";
		}
		else
		{	
			foreach ($network_names as $parameter => $title)
			{
				if (isset($network_settings[$parameter]))
				{
					$i++;
					$title_prmtr .= "<td>$title</td>";
					$value_prmtr .= "<td>{$network_settings[$parameter]}</td>";
				}
			}

			$colspan = " colspan=\"$i\"";

		}	
	}

	function _dns_summary_settings($network_names, $network_settings, &$title_prmtr, &$value_prmtr, &$colspan, $remove_str = "DNS-Server")
	{
		$i = 0;
		foreach ($network_names as $parameter => $title)
		{
			if (isset($network_settings[$parameter]))
			{
				$i++;
				$title_prmtr .= "<td>". str_replace($remove_str, "", $title) . "</td>";
				$value_prmtr .= "<td>{$network_settings[$parameter]}</td>";
			}
		}

		if ($i > 1)
		{
			$colspan = " colspan=\"$i\"";
		}
	}

	// Public Functions
	function get_content_modal ($bc, $network_cfg)
	{
	        $dhcp_checked   = '';
	        $static_checked = 'checked';

       		return	  $this -> _display_network_mode($bc, $network_cfg)
            		. $this -> _display_lan_settings($bc, $network_cfg, $dhcp_static, $static_checked)
                      	. $this -> _display_wan_settings($bc, $network_cfg, $dhcp_static, $static_checked)
                      	. $this -> _display_dns_settings($bc, $network_cfg);
	} 

	function get_general_javascript_code ()
	{
        	ob_start();
?>
<script type="text/javascript">
	function hide_netconfig(ch) 
	{
    		if (!ch) 
		{
        		$("#<?php echo $this -> lanip['id'] ."-tr"; ?>").hide();
        		$("#<?php echo $this -> lannetmask['id'] ."-tr"; ?>").hide();
        		$("#<?php echo $this -> langateway['id'] ."-tr"; ?>").hide();
    		} 
		else 
		{
        		$("#<?php echo $this -> lanip['id'] ."-tr"; ?>").show();
        		$("#<?php echo $this -> lannetmask['id'] ."-tr"; ?>").show();
        		$("#<?php echo $this -> langateway['id'] ."-tr"; ?>").show();
    		}
	}

	function hide_wan(ch) 
	{
    		if (!ch) 
		{
        		$("#<?php echo $this -> wanip['id'] ."-tr"; ?>").hide();
        		$("#<?php echo $this -> wannetmask['id'] ."-tr"; ?>").hide();
        		$("#<?php echo $this -> wangateway['id'] ."-tr"; ?>").hide();
    		}
		else 
		{
        		$("#<?php echo $this -> wanip['id'] ."-tr"; ?>").show();
        		$("#<?php echo $this -> wannetmask['id'] ."-tr"; ?>").show();
        		$("#<?php echo $this -> wangateway['id'] ."-tr"; ?>").show();
    		}	
	}

	function mode() 
	{
    		hide_netconfig($("#<?php echo $this -> lanstatic['id']; ?>").prop("checked"));
    		hide_wan($("#<?php echo $this -> wanstatic['id']; ?>").prop("checked"));

    		switch ($("select[name='<?php echo $this -> lanmode['name']; ?>'] option:selected").val()) 
		{
        		case 'single':
            			$("#wan").hide();
            			$("#<?php echo $this -> landhcp['id']; ?>-tr").show();
            			$("input[name='<?php echo $this -> landhcp['name']; ?>']").prop("disabled", false);
            			break;
        		case 'lan-wan':
            			$("#wan").show();
            			$("#<?php echo $this -> lanip['id']; ?>-tr").show();
            			$("#<?php echo $this -> lannetmask['id']; ?>-tr").show();

            			$("input[name='<?php echo $this -> landhcp['name']; ?>']").prop("disabled", true);
            			$("#<?php echo $this -> landhcp['id']; ?>-tr").hide();
            			$("#<?php echo $this -> langateway['id']; ?>-tr").hide();
            			break;
        		default :
           			$("#wan").hide();
            			$("#<?php echo $this -> landhcp['id']; ?>-tr").show();
            			$("input[name='<?php echo $this -> landhcp['name']; ?>']").prop("disabled",false);
            			break;
   		}
	}

	$(document).ready(function () {
    		mode();

    		$("select[name='<?php echo $this -> lanmode['name']; ?>']").change(function () {
       			mode();
    		});

		$("#Networkform").validate({
       			rules: {
       				<?php echo $this -> lanip['name']; ?>: {
               				verifyIP: true,
              				required: true
       				},
				<?php echo $this -> dnshostname['name']; ?>: {
					checkHostname: true
				},
       				<?php echo $this -> dnsnameserver2['name']; ?>: {
              				verifyIP: true,
       					required: {
               					depends: function (element) {
                      					return $("#<?php echo $this -> dnsnameserver['id']; ?>").is(":filled");
               					}
              				}
       				},
       				<?php echo $this -> dnsnameserver['name']; ?>: {
              				verifyIP: true,
       				},
      				<?php echo $this -> langateway['name']; ?>: {
              				verifyIP: true,
              				required: true
      				},
       				<?php echo $this -> lannetmask['name']; ?>: {
              				verifyIP: true,
              				required: true
       				},
       				'<?php echo $this -> wanip['name']; ?>': {
              				verifyIP: true,
              				required: true
       				},
      				'<?php echo $this -> wannetmask['name']; ?>': {
              				verifyIP: true,
              				required: true
       				},
       				'<?php echo $this -> wangateway['name']; ?>': {
              				verifyIP: true,
              				required: true
      				},
     			}
		});
    	});
</script>
<?php
        	return ob_get_clean();
	}

	function get_unique_form_javascript_code ()
	{	
		ob_start();
?>
			if (document.getElementById('<?php echo $this -> landhcp['id']; ?>').checked)
			{
				$('.lan').prop('value', '');
				$('.form-control.input-sm.lan').prop('value', '');
			}

			if (document.getElementById('<?php echo $this -> wandhcp['id']; ?>').checked || document.getElementById('<?php echo $this -> lanmode['id']; ?>').value == 'single')
			{
				$('.wan').prop('value', '');
				$('.form-control.input-sm.wan').prop('value', '');
			}	
<?php
		return ob_get_clean();
	}



	function get_summary_settings ($network_settings)
	{
		$title 	 = "\t\t\t<p class='text-center h4'>". WIZARD_NETWORK_SETTINGS_DIS ."</p>\n";

		// LAN settings
		$lan_prmtr_title = '';
		$lan_prmtr_value = '';
		$lan_colspan	 = '';
		$network_names 	 = array( $this -> lanip['name']      => $this -> lanip['title']     ,	
					  $this -> lannetmask['name'] => $this -> lannetmask['title'],
					  $this -> langateway['name'] => $this -> langateway['title']);

		$this -> _lan_wan_summary_settings($this -> landhcp['name'], $network_names, $network_settings, $lan_prmtr_title, $lan_prmtr_value, $lan_colspan);

		$lan_title  = "<th$lan_colspan style='text-align: center'>LAN</th>";
		
		// WAN settings
		$wan_title 	 = '';
		$wan_prmtr_title = '';
		$wan_prmtr_value = '';
		$wan_colspan 	 = '';
		if (strcmp($network_settings[$this -> lanmode['name']], 'single') != 0)
		{		
			$network_names = array(	$this -> wanip['name']	    => $this -> wanip['title']	   ,
						$this -> wannetmask['name'] => $this -> wannetmask['title'],
						$this -> wangateway['name'] => $this -> wangateway['title']);

			$this -> _lan_wan_summary_settings($this -> wandhcp['name'], $network_names, $network_settings, $wan_prmtr_title, $wan_prmtr_value, $wan_colspan);

			$wan_title = "<th$wan_colspan style='text-align: center'>WAN</th>";
		}

		// DNS settings
		$dns_title 	 = '';
		$dns_prmtr_title = '';
		$dns_prmtr_value = '';
		$dns_colspan	 = '';
		$network_names = array(	$this -> dnsnameserver['name']  => $this -> dnsnameserver['title'] ,
					$this -> dnsnameserver2['name'] => $this -> dnsnameserver2['title'],
					$this -> dnshostname['name']	=> $this -> dnshostname['title']   );
		
		$this -> _dns_summary_settings($network_names, $network_settings, $dns_prmtr_title, $dns_prmtr_value, $dns_colspan);

		if (strlen($dns_prmtr_title) > 0)
		{
			$dns_title = "<th$dns_colspan style='text-align: center'>DNS</th>";
		}

		$table_network =  "\t\t\t<table class='table table-striped table-bordered'>\n"
				. "\t\t\t\t<tr>" 	. $lan_title 		. $wan_title  		. $dns_title		. "</tr>\n"
				. "\t\t\t\t<tr>"	. $lan_prmtr_title	. $wan_prmtr_title	. $dns_prmtr_title	. "</tr>\n"
				. "\t\t\t\t<tr>"	. $lan_prmtr_value	. $wan_prmtr_value	. $dns_prmtr_value	. "</tr>\n"
				. "\t\t\t</table>\n";
			
		return $title . $table_network . $div_out;
	}

	function get_network_settings ()
	{
		return array (	'mode' => $this -> lanmode,
				'lan'  => array('0' => $this->_only_id_and_name($this -> landhcp), '1' => $this->_only_id_and_name($this -> lanip), '2' => $this->_only_id_and_name($this -> lannetmask), '3' => $this->_only_id_and_name($this -> langateway)),
				'wan'  => array('0' => $this->_only_id_and_name($this -> wandhcp), '1' => $this->_only_id_and_name($this -> wanip), '2' => $this->_only_id_and_name($this -> wannetmask), '3' => $this->_only_id_and_name($this -> wangateway)),
				'dns'  => array('0' => $this->_only_id_and_name($this -> dnsnameserver), '1' => $this->_only_id_and_name($this -> dnsnameserver2), '2' => $this->_only_id_and_name($this -> dnshostname)) );
	} 

	function get_post_conditions_list() 
	{
		$conditions = array('post' => array(), 'options' => array());
		foreach ($this -> _get_post_list() as $post_input) 
		{
			$conditions['post'][$post_input['name']] = $post_input['postCheck'];		
			$conditions['options'][$post_input['name']] = $post_input['options'];		
		}

		return $conditions;
	}
}
?>
