#!/usr/bin/php -q
<?php
require_once('/usr/fallback/beroConf.php');
require_once('/usr/php/include/rootHelper.class.php');

function redirect_log($m) {
	$logfile = "/var/log/redirect.log";
	file_put_contents($logfile, rootHelper::getDate()." ".$m.PHP_EOL, FILE_APPEND);
}

function cloudRegister($data, $key, $url = null) {
	redirect_log("cloud-register");
	return(array_merge($data, array(
		'cloud_key' => $key,
		'cloud_enable' => '1',
		'cloudAddress' => $url,
		'cloud_show_status' => '1',
	)));
}

function provisioningUrl($data, $url) {
	redirect_log("set provisioning url and enable provisioning");
	return(array_merge($data, array(
		'provisioning_url' => $url,
		'provisioning_mode' => 'always',
		'provisioning_manual' => '1',
	)));
}

$data = array();
$bc = new beroConf('root');

try {
	$redirect_server = $bc->get('root','redirect_server');
	if (!strlen($redirect_server)) $redirect_server = 'https://berocloud.beronet.com/api/redirect';

	$hasCertificates = rootHelper::tlsHasCertificate(true);

	redirect_log("using '$redirect_server'");	
	require_once('/usr/php/include/SbcApi.php');
	$cloud = new SbcApi($bc);
	$res = $cloud->send('redirect', array(
		'lifs' => implode('_', rootHelper::getLif()),
		'mac' => rootHelper::getNetworkMacAddr(rootHelper::getNetworkIfaceByName('lan', $bc)),
		'task' => "provisioning-url",
		'hasTls' => $hasCertificates,
		'hasUrl' => strlen($bc->get('root', 'provisioning_url')) > 0,
	), array('redirect_server' => $redirect_server));

	redirect_log("result: $res");
	$r = unserialize($res);
	if (!is_array($r)) {
		redirect_log('do nothing');
		exit(0);
	}
	redirect_log("unserialized: ". print_r($r, true));
	extract($r['task']);
	
	switch($type) {
	case 'cloud-register':
		$data = cloudRegister($data, $key, $url);
		break;
	case 'cmd':
		if (strpos($r['task']['cmd'], 'firmware')) {
			file_put_contents('/tmp/firmware.upgrade', '1');
		}
		redirect_log("start a cmd:'".$r['task']['cmd']."'");
		system($r['task']['cmd'], $out);
		redirect_log("cmd-output:'".$out."'");
		exit(0);
	case 'provisioning-tls':
		$data = cloudRegister($data, $key, $url);
		$data = provisioningUrl($data, $provisioningUrl);
		if (!$hasCertificates) {
			if (!file_exists('/usr/conf/tls')) {
				mkdir('/usr/conf/tls', '0644');
			}
			foreach (rootHelper::tlsGetCertificate() as $key => $path) {
				file_put_contents($path, $$key);
			}
		}
		$bc->set('root', 'redirect-provisioning-tls', '1');
		break;
	case 'provisioning-url':
		$data = provisioningUrl($data, $url);
		break;
	default:
		redirect_log("do nothing");
		exit(0);
	}
}
catch(Exception $e) {
	file_put_contents('/var/log/redirect-error.log' , $e->getMessage(). ' ' .$e->getFile(). ' ' .$e->getLine() . "\n" , FILE_APPEND);
	exit(1);
}

// Update database and config files
foreach ($data as $key => $value) {
	$bc->set('root', $key, $value);
}
rootHelper::doActivate(array(
	'misc.conf' => array('general' => $data),
));
exit(0);
?>
