<?php

/**
 * Functions for PSTN groups
 *
 * @author Miguel Palmer <mp@beronet.com>
 */
class HelperPstn {
	function __construct() {
	}

	/**
	 * Get the countries list
	 */
	static function getCountriesList() {
		return 	array(  
				"FCC", "TBR21", "1TR110_DE", "ARGENTINA", "AUSTRALIA", "AUSTRIA", "BAHRAIN",
				"BELGIUM", "BRAZIL", "BULGARIA", "CANADA", "CHILE", "CHINA", "COLOMBIA", "CROATIA",
				"CYPRUS", "CZECH", "DENMARK", "ECUADOR", "EGYPT", "ELSALVADOR", "FINLAND", "FRANCE",
				"GERMANY", "GREECE", "GUAM", "HONGKONG", "HUNGARY", "ICELAND", "INDIA", "INDONESIA",
				"IRELAND", "ISRAEL", "ITALY", "JAPAN", "JORDAN", "KAZAKHSTAN", "KUWAIT", "LATVIA",
				"LEBANON", "LUXEMBOURG", "MACAO", "MALAYSIA", "MALTA", "MEXICO", "MOROCCO", "NETHERLANDS",
				"NEWZEALAND", "NIGERIA", "NORWAY", "OMAN", "PAKISTAN", "PERU", "PHILIPPINES", "POLAND",
				"PORTUGAL", "ROMANIA", "RUSSIA", "SAUDIARABIA", "SINGAPORE", "SLOVAKIA", "SLOVENIA",
				"SOUTHAFRICA", "SOUTHKOREA", "SPAIN", "SWEDEN", "SWITZERLAND", "SYRIA", "TAIWAN", "THAILAND",
				"UAE", "UK", "USA", "YEMEN", "USER"
		);
	}

	/**
	 * Set the POST arguments during submit
	 */
	static function getPostParameters($type_to_get, $options_loaded = array()) {
		// init
		$options = array();
		$arguments = array(); 

		// options
		$wait_oad_list = array('wait', 'dontwait');

		// General arguments
		if ($type_to_get === 'general') {
			$arguments = array(	
						'group' 	  => 'group-name', 'gr_upd' 	     => 'group-name', 'ports' 	=> 'int>0', 'tones' => 'tones'	  , 'chansel' 	 => 'select', 'chansel_dir'   => 'select'	, 
						'overlap_dialing' => 'bool'	 , 'dialtone_digits' => 'int>=0'    , 'ec' 	=> 'bool' , 'ectl'  => 'int-range','clir_on_oad' => 'int>=0', 'addit_options' => 'config-option',
						'monitored_sip_peer' => 'special-char', 'monitored_sip_peer_offtime' => 'int-range'
					  );

			$options = array(
                                		'chansel'      => array('standard', 'random', 'roundrobin'),
                                		'chansel_dir'  => array('ascending', 'descending')         ,
                                		'ectl'         => array('min' => 0, 'max' => 15)           ,
                                		'monitored_sip_peer_offtime'         => array('min' => 0, 'max' => 86400),
					);
		}
		// ISDN arguments
		else if ($type_to_get === 'isdn') {
			$arguments = array(
						'portpullup' 	=> 'int-range'	, 'odt'  => 'int>=0'	, 'country_code' => 'international-code', 'city_code'        		=> 'int>=0'  	, 'local_area_code'		=> 'int>=0',
						'pcmlaw'    	=> 'select'	, 'qsig' => 'bool'	, 'dton' 	 => 'int-range'		, 'oton' 	     		=> 'int-range'	, 'bearer_cap'			=> 'select',
						'screen' 	=> 'bool'	, 'cd'   => 'bool'	, 'pres' 	 => 'bool'		, 'restart_after_link_loss' 	=> 'bool'	, 'from_pstn_src_setting_isdn'	=> 'select',

						'odt_empty_dad' => 'int>=0',

						'isdn_dad_setting' 		=> 'select', 'isdn_dad_setting_manual' 	 	=> 'alphanumeric' ,
						'isdn_oad_setting' 		=> 'select', 'isdn_oad_setting_manual' 		=> 'config-option', 
						'isdn_oad2_setting'		=> 'select', 'isdn_oad2_setting_manual' 	=> 'config-option',
						'isdn_qsigname_setting'	 	=> 'select', 'isdn_qsigname_setting_manual' 	=> 'config-option',
						'isdn_redirected_nr_setting' 	=> 'select', 'isdn_redirected_nr_setting_manual'=> 'config-option'
					  );

			$options = array(
						'bearer_cap'                    => array('SPEECH', 'AUDIO_3_1K', 'AUDIO_7K', 'VIDEO', 'DIGITAL_UNRESTRICTED', 'DIGITAL_RESTRICTED', 'DIGITAL_UNRESTRICTED_TONES'),
                                		'chansel'                       => array('standard', 'random', 'roundrobin')	,
                                		'chansel_dir'                   => array('ascending', 'descending')		,
                                		'dton'                          => array('min' => 0, 'max' => 6)		,
                                		'from_pstn_src_setting_isdn'    => $options_loaded['from_pstn_src_setting_isdn'],
                                		'isdn_dad_setting'              => $options_loaded['callee_id_pstn']		,
                                		'isdn_oad_setting'              => $options_loaded['caller_id_pstn']		,
                                		'isdn_oad2_setting'             => $options_loaded['caller_id_pstn']		,
                                		'isdn_qsigname_setting'         => $options_loaded['caller_id_pstn']		,
                                		'isdn_redirected_nr_setting'    => $options_loaded['caller_id_pstn']		,
                                		'oton'                          => array('min' => 0, 'max' => 6)		,
                                		'pcmlaw'                        => array('default', 'alaw', 'ulaw')		,
                                		'portpullup'                    => array('min' => 0, 'max' => 2)		
					);
		}
		// Analog arguments
		else if ($type_to_get === 'analog') {

			$arguments = array(
						'fxo_connect' => 'select', 'fxo_wait_for_oad' => 'select',  'fxo_call_ending_signal' => 'select', 'fxo_cid_detection_mode' => 'select', 'clip' => 'int>=0', 'cnip' => 'alphanumeric',

						'overlap_dial_timeout_empty_dad' => 'int>0' , 'overlap_dial_timeout'     =>  'int>0' 	, 'message_waiting_method' => 'select',
                        			'from_pstn_src_setting_analog' 	 => 'select', 'fxo_dialtone_passthrough' => 'bool'	,

						'analog_oad_setting' 	 => 'select', 'analog_oad_setting_manual' 	=> 'config-option',
						'analog_display_setting' => 'select', 'analog_display_setting_manual' 	=> 'config-option',
						'fxo_verify_ringing' => 'bool', 'fxs_wink_offset' => 'int-range', 'fxs_wink_duration' => 'int-range'
					);

			$options = array(
                                		'analog_oad_setting'            => $options_loaded['caller_id_pstn']		 ,
                                		'analog_display_setting'        => $options_loaded['caller_id_pstn']		 ,
                                		'from_pstn_src_setting_analog'  => array('clip', 'cnip')                         ,
                                		'fxo_connect'                   => array('instant', 'polarity')                  ,
                                		'fxo_wait_for_oad'              => $wait_oad_list 	                         ,
                                		'fxo_call_ending_signal'        => array('unobtainable', 'busy')                 ,
                                		'fxo_cid_detection_mode'        => array('Bellcore', 'ETSI-DTMF', 'ETSI-DTMF-AR'),
                                		'message_waiting_method'        => array('stutter', 'fsk', 'off')                ,
                                		'fxs_wink_offset'               => array('min' => 0, 'max' => 5000)              ,
                                		'fxs_wink_duration'             => array('min' => 0, 'max' => 2000)                
					);
		}
		// GSM / LTE arguments
		else if ($type_to_get === 'gsm' || $type_to_get === 'lte') {
			$arguments = array(
				'sms_extension'	=> 'phone-char',
				'extension'	=> 'phone-char',
				'sms_webhook'	=> 'url',
				'sms_webhook_user'	=> 'special-char',
				'sms_webhook_secret'	=> 'password',
				'sms_webhook_type'	=> 'alphanumeric',
				'sms_webhook_id'	=> 'special-char',
				'gsm_clir' => 'int-range',
				'wait_for_cid_timeout' => 'int-range',
				'lte_init_hook' => 'password',
		  );

			$options = array(
				'gsm_clir' => array('min' => 0, 'max' => 2),
				'wait_for_cid_timeout' => array('min' => 1, 'max' => 10),
			);
		}
		// CAS arguments
		else if ($type_to_get === 'cas') {
			$arguments = array(
						'channels'     => 'int>0' , 't1sigtype' => 'select', 'e1sigtype' => 'select', 'interdigit_timeout_initial' => 'int>=0', 'interdigit_timeout' => 'int>=0', 'fxo_callerid_detection_timeout' => 'int>=0',
						'wait_for_oad' => 'select');

			$options = array( 
						'e1sigtype' 	=> array('mfcr2')		,
						't1sigtype' 	=> array('fxo_ks', 'fxs_ks')	, 			
						'wait_for_oad' 	=> $wait_oad_list
					);

		}

		return array('post' => $arguments, 'options' => $options);
	}

	/**
	 * Speichert den Clock-Parameter (Syncronization port) in der Dabenbank
	 * @param beroAri $database
	 * @param string $table Name der Datenbanktabelle
	 */
	public function clock($database, $table, $post) {
		$query_new = $database->update("UPDATE $table SET clock=0");
		for ($i = 0; $i < Helper::getLifCount(); $i++) {
			if (isset($post['sync_li' . $i])) {
				$clock = preg_replace("/$table-/", "", $_POST['sync_li' . $i]);
				$database->update("UPDATE $table SET clock=1 WHERE port='" . $clock . "'");
			}
			if ($post['sync_li' . $i] == 'crystal') {
				$database->set("sync_port_li" . $i, '1');
			}
			else {
				$database->set("sync_port_li" . $i, '0');
			}
			if ($post['sync_li' . $i] == 'auto') {
				$database->set("sync_port_auto" . $i, '1');
			}
			else {
				$database->set("sync_port_auto" . $i, '0');
			}
		}
	}

	public function regroupIsdn($database, $entry = null) {
		if (!is_null($entry)) {
			$where = " where lif>" . $entry['lif'];
		}
		$query_isdn = $database->select("select * from isdn" . $where);
		$database->delete("delete from isdn" . $where);
		if (!is_null($entry)) {
			$database->insert_('INSERT INTO isdn (type, lif, port_type,ccs) ' .
				'VALUES (\'' . $entry['type'] . '\',\'' . $entry['lif'] . '\',\'PRI\',1);');
		}
		while ($entry = $database->fetch_array($query_isdn)) {
			$database->insert_('INSERT INTO isdn (type, lif, port_type, clock) ' .
				'VALUES (\'' . $entry['type'] . '\',\'' . $entry['lif'] . '\',\'' . $entry['port_type'] . '\',\'' . $entry['clock'] . '\');');
		}
	}

	/*
	 * Function to change the hardware configuration depending the $_POST input
	 *
	 */
	public function saveHardwareConfiguration($ba, $post_array) {
		// pcm server
		if ($post_array['master'] == "pcm") {
			$ba->set('pcm_server', sqlite_escape_string($post_array['pcm_ip']));
		}
		else {
			$ba->set('pcm_server', isset($post_array['pcm_server']) ? '1' : '0');
		}
		$ba->set('pcm_server_port', sqlite_escape_string($post_array['pcm_server_port']));

		//Country Settings
		$ba->set('country', isset($post_array['country']) ? sqlite_escape_string($post_array['country']) : '');

		if (isset($post_array['ohs'])) {
			$ohs = explode("|", $post_array['ohs']);
			$ohs1 = explode("=", $ohs[0]);
			$ohs2 = explode("=", $ohs[1]);
			$ba->set('ohs', sqlite_escape_string($ohs1[1]));
			$ba->set('ohs2', sqlite_escape_string($ohs2[1]));
		} 
		else {
			$ba->set('ohs', '0');
			$ba->set('ohs2', '0');
		}

		if (isset($post_array['rt'])) {
			$rt = explode("|", $post_array['rt']);
			$rt1 = explode("=", $rt[0]);
			$rt2 = explode("=", $rt[1]);
			$ba->set('rt', sqlite_escape_string($rt1[1]));
			$ba->set('rt2', sqlite_escape_string($rt2[1]));
		}
		else {
			$ba->set('rt', '0');
			$ba->set('rt2', '0');
		}

		(isset($post_array['rz'])) ? $ba->set('rz', sqlite_escape_string($post_array['rz'])) : $ba->set('rz', '0');
		(isset($post_array['dcv'])) ? $ba->set('dcv', sqlite_escape_string($post_array['dcv'])) : $ba->set('dcv', '0x0');
		(isset($post_array['mini'])) ? $ba->set('mini', sqlite_escape_string($post_array['mini'])) : $ba->set('mini', '0x0');
		(isset($post_array['acim'])) ? $ba->set('acim', sqlite_escape_string($post_array['acim'])) : $ba->set('acim', '0x0');
		(isset($post_array['ilim'])) ? $ba->set('ilim', sqlite_escape_string($post_array['ilim'])) : $ba->set('ilim', '0');
		(isset($post_array['wait4idle'])) ? $ba->set('wait4idle', sqlite_escape_string($post_array['wait4idle'])) : $ba->set('wait4idle', '1000');
		(isset($post_array['ring_oscillator_on'])) ? $ba->set('ring_oscillator_on', sqlite_escape_string($post_array['ring_oscillator_on'])) : $ba->set('ring_oscillator_on', '1000');
		(isset($post_array['ring_oscillator_off'])) ? $ba->set('ring_oscillator_off', sqlite_escape_string($post_array['ring_oscillator_off'])) : $ba->set('ring_oscillator_off', '4000');

		//END Country settings
		if (isset($post_array['boostringer'])) {
			$ba->set('boostringer', sqlite_escape_string($post_array['boostringer']));
		}
		else {
			$ba->set('boostringer', '0');
		}

		//ISDN clock
		$this->clock($ba, "isdn", $post_array);

		//CAS clock
		$this->clock($ba, "cas", $post_array);

		$revision = Helper::getRevision();
		if (isset($post_array['portswitch']) && $revision != "1.80" && $revision != "1.8" && Helper::getType() < 30) {
			$ba->set('portswitch', '1');
		}
		else if (!isset($post_array['portswitch']) && $revision != "1.80" && $revision != "1.8" && Helper::getType() < 30) {
			$ba->set('portswitch', '0');
		}

		$id = $post_array['id_upd'];
		$type_array = $post_array['type'];
		$update_cas_channels = false;
		for ($i = 0; $i < count($id); $i++) {
			$id_upd = $id[$i];
			$type = $type_array[$i];
			//ISDN spezifieche Einstellungen speichern
			if ($type == "isdn") {
				$mode = "mode" . $id_upd;
				$mode_id = $post_array[$mode];
				$ptp = "ptp" . $id_upd;
				$ptp_id = $post_array[$ptp];
				$lt = "lt" . $id_upd;
				$lt_id = $post_array[$lt];
				$crystal_clock = "crystal_clock" . $id_upd;
				$crystal_clock_id = $post_array[$crystal_clock];
				$permanentl1 = "permanentl1" . $id_upd;
				$permanentl1_id = $post_array[$permanentl1];
				$crc = "crc" . $id_upd;
				$crc_id = $post_array[$crc];
				if ($ptp_id == "") {
					$ptp_id = "1";
				}
				if ($permanentl1_id == "") {
					$permanentl1_id = "0";
				}
				if ($lt_id == "") {
					$lt_id = "0";
				}
				if ($crc_id == "") {
					$crc_id = "0";
				}

				$query = $ba->select("select port_type from isdn where port = " . $id_upd);
				$isdn_port_type= sqlite_fetch_single($query);
				
				$crlen = "crlen" . $id_upd;
				$crlen_id = $post_array[$crlen];
				$cidlen = "cidlen" . $id_upd;
				$cidlen_id = $post_array[$cidlen];
					
				if ($isdn_port_type == "BRI") {
					if ($crlen_id == "") {
						$crlen_id= "1";
					}
					if ($cidlen_id== "") {
						$cidlen_id= "1";
					}
				}
				
				$query_upd = $ba->update("UPDATE isdn SET ntteHW='" . sqlite_escape_string($mode_id) . "',"
							. " ntteSW='" . sqlite_escape_string($mode_id) . "',"
							. " ptp='" . sqlite_escape_string($ptp_id) . "',"
							. " lt='" . sqlite_escape_string($lt_id) . "',"
							. " crc='" . sqlite_escape_string($crc_id) . "',"
							. " crystal_clock='" . sqlite_escape_string($crystal_clock_id) . "',"
							. " permanentl1='" . sqlite_escape_string($permanentl1_id) . "',"
							. " crlen='" . sqlite_escape_string($crlen_id) . "',"
							. " cidlen='" . sqlite_escape_string($cidlen_id) . "'"
							. " WHERE port='" . sqlite_escape_string($id_upd) . "'"
				);
			}

			//CAS speichern
			if ($type == "cas") {
				$termination = $post_array["casmode" . $id_upd];
				if ($termination == "") {
					$termination = "te";
				}
				$coding = $post_array["coding" . $id_upd];
				$query_upd = $ba->update("UPDATE cas SET termination='" . sqlite_escape_string($termination) . "', coding='" . sqlite_escape_string($coding) . "' WHERE port='" . sqlite_escape_string($id_upd) . "'");
			}
			
			//LTE speichern
			if ($type == "lte") {
				$pin = $post_array["pinlte" . $id_upd];
				$smsc = $post_array["smsclte" . $id_upd];
				//disabled codec for lte
				$codec = $post_array["codeclte" . $id_upd];
				$provider_mode = $post_array["provider_mode" . $id_upd];
				$provider_id = $post_array["provider_ids" . $id_upd];

				if ($provider_mode == 0) {
					$provider_id = "";
				}
				else if ($provider_id == "Scanning Now" || $provider_id == "No Scan Results" || $provider_id == "No ISGW" || $provider_id == "--------") {
					$provider_mode = 0;
					$provider_id = "";
				}
				
				$provider = $provider_mode . ":" . $provider_id;

				$codec_id = null;
				if (is_array($codec)) {
					foreach ($codec as $value) {
						$codec_id .=($codec_id == "") ? "" : "|";
						$codec_id.=$value;
					}
				}
				$query_upd = $ba->update("UPDATE lte SET pin='" . sqlite_escape_string($pin) . "', "
					. "smsc='" . sqlite_escape_string($smsc) . "', codec='" . sqlite_escape_string($codec_id)  . "', provider='" . sqlite_escape_string($provider) . "'  WHERE port='" . sqlite_escape_string($id_upd) . "'");
			}
			
			//GSM speichern
			if ($type == "gsm") {
				$pin = $post_array["pingsm" . $id_upd];
				$smsc = $post_array["smscgsm" . $id_upd];
				$codec = $post_array["codecgsm" . $id_upd];
				$codec_id = null;
				if (is_array($codec)) {
					foreach ($codec as $value) {
						$codec_id .=($codec_id == "") ? "" : "|";
						$codec_id.=$value;
					}
				}
				$query_upd = $ba->update("UPDATE gsm SET pin='" . sqlite_escape_string($pin) . "', "
					. "smsc='" . sqlite_escape_string($smsc) . "', codec='" . sqlite_escape_string($codec_id) . "'  WHERE port='" . sqlite_escape_string($id_upd) . "'");
			}

			//CAS Hardware modus Änderungen
			if ($type == "cashw") {
				$t1e1 = $post_array["t1e1" . $id_upd];
				if ($t1e1 == 1) {
					$protocol = "t1";
				}
				else {
					$protocol = "e1";
				}
				$interface_type = $post_array["interface_type" . $id_upd];

				$query = $ba->select("select port_type from cas where port='" . sqlite_escape_string($id_upd) . "'");
				$old_interface_type = sqlite_fetch_single($query);
				if ($old_interface_type != $interface_type) {
					$update_isdn = true;
				}
				$query = $ba->select("select protocol from cas where port='" . sqlite_escape_string($id_upd) . "'");
				$old_protocol = sqlite_fetch_single($query);
				if ($old_protocol != $protocol) {
					$update_cas_channels = true;
				}
				$query_upd = $ba->update("UPDATE cas SET protocol='" . sqlite_escape_string($protocol) . "', port_type='" . sqlite_escape_string($interface_type) . "' WHERE port='" . sqlite_escape_string($id_upd) . "'");
				$ba->set('set_hw', 1);
			}
		}

		//Wenn das cas protokoll (t1 oder e1) sich geändert hat, werden alle
		//channels gelöscht und neu angeordnet
		if ($update_cas_channels == true || $update_isdn == true) {

			$query_del = $ba->delete("delete from isdn where ccs=1");
			$query_del = $ba->delete("delete from cas_channels");

			//Gespeicherte ISDN Ports in lif0 zurücksetzen
			$query = $ba->select("select port, type, port_type, protocol, lif from cas order by port");
			while ($entry = $ba->fetch_array($query)) {
				//CAS channels speichern
				if ($entry['protocol'] == 't1' && $entry['port_type'] == 'cas') {
					for ($j = 0; $j < 24; $j++) {
						$ba->insert_("INSERT INTO cas_channels (port) VALUES('" . $entry['port'] . "');");
					}
				}
				if ($entry['protocol'] == 'e1' && $entry['port_type'] == 'cas') {
					for ($j = 0; $j < 31; $j++) {
						$ba->insert_("INSERT INTO cas_channels (port) VALUES('" . $entry['port'] . "');");
						if ($j == 15) {
							$channel = $ba->rowid();
						}
					}
					//Sigchan weglassen
					$ba->delete("delete from cas_channels where channel='" . $channel . "';");
				}
				//Channels (HDLC) in der ISDN Tabelle speichern
				if ($entry['port_type'] == 'hdlc') {
					$this->regroupIsdn($ba, $entry);
				}
			}
			$this->regroupIsdn($ba);
		}

		//Master-Slave option speichern
		isset($post_array['master']) ? $ba->set('master', sqlite_escape_string($post_array['master'])) : $ba->set('master', 'all');
	}	

	/**
	 * Port section title (PSTN popups)
	 */
	static function title($ba, $gr, $lif) {
		$query = $ba->select("select distinct type from isdn where lif='" . sqlite_escape_string($lif) . "' union "
			. "select distinct type from gsm where lif='" . sqlite_escape_string($lif) . "' union "
			. "select distinct type from lte where lif='" . sqlite_escape_string($lif) . "' union "
			. "select distinct type from analog where lif='" . sqlite_escape_string($lif) . "' union "
			. "select distinct type from cas where lif='" . sqlite_escape_string($lif) . "'");
		$title = "<b>Li" . $lif . "()</b>";
		while ($entry = $ba->fetch_array($query)) {		
			$title = "<b>Li" . $lif . "(" . $entry['type'] . ")</b>";
		}
		return $title;
	}

	/**
	 * Ports of the port section (PSTN popups)
	 */
	static function ports($ba, $gr, $lif, $table, &$count_ports = null) {
		$where = "";
		if ($table == "isdn" || $table == "analog") {
			$where = " and port_type='" . sqlite_escape_string($_GET['opt']) . "'";
		}
		$query = $ba->select("select * from " . sqlite_escape_string($table) . " where lif='" . sqlite_escape_string($lif) . "' " . $where);
		while ($entry = $ba->fetch_array($query)) {
			$type = explode("-", $entry['type']);
			if (html_entity_decode($entry['gr']) == $gr) {
				$tab .= "<div>Port " . $entry['port'] . " <input type='checkbox' class='aport' name='ports[]' checked value='" . $entry['port'] . "'></div>";
			} elseif ($entry['gr'] == 'NULL') {
				$tab .= "<div>Port " . $entry['port'] . " <input type='checkbox' class='aport' name='ports[]' value='" . $entry['port'] . "'></div>";
			} else {
				$tab .= "<div>Port " . $entry['port'] . " <input type='checkbox' name='ports[]' checked disabled='true' value='" . $entry['port'] . "'></div>";
			}
			$count_ports++;
		}
		return $tab;
	}

	/**
	 * Build tones dropdown
	 */
	function tones($ba, $gr, $table, $options = null, &$credentials_str = '', &$tones_custom_created = null) {
		// TODO: must be reworked using HelperHtml::fieldSelect
		// this code is very ugly
		$tones = "de";
		$selected['de'] = ' selected';
		$id = isset($options['id']) ? " id='{$options['id']}'" : '';
		// get tones from database
		$query = $ba->select("SELECT tones FROM ". sqlite_escape_string($table) ." WHERE gr='". sqlite_escape_string($gr) ."'");
		while ($entry = $ba->fetch_array($query)) {
			if (preg_match("/^\[([-a-z0-9]+)\]$/", $entry['tones'], $matched)) {
				$tones = $matched[1];
			}
		}
		// load tones
		$tones_loaded = parse_ini_file('/usr/conf/isgw.tones', true);
		if (isset($options['is_fxo']) && $options['is_fxo']) {
			$count = 0;
			$tones_custom = self::getTonesCustom($ba, null, $count);
			$tones_custom_created = array();
			foreach (array_keys($tones_custom) as $key) {
				$tones_custom_created[] = "[$key]";
			}
			// push a new empty custom entry
			for ($i=1; $i<=$count+1; $i++) { 
				if (!isset($tones_custom["custom$i"])) {
					$tones_custom["custom$i"] = array();
					break;
				}
			}
			$tones_loaded = array_merge($tones_loaded, $tones_custom);
		}
		unset($tones_loaded['general']);
		// set selected tones
		if (in_array($tones, array_keys($tones_loaded))) {
			unset($selected['de']);
			$selected[$tones] = ' selected';
		}
		// build select field
		$ret = "<select class='form-control' name='tones'$id>\n";
		foreach (array_keys($tones_loaded) as $value) {
			$ret .= "\t<option value='[$value]'{$selected[$value]}>[$value]</option>\n";
		}
		$ret .= "</select>\n";
		if (isset($options['is_fxo']) && $options['is_fxo']) {
			$credentials_str .= self::tonesCredentials($tones_loaded[$tones], !preg_match('/^custom[0-9]+$/', $tones));
		}
		return $ret;
	}

	public function getTonesCustom($ba, $name = null, &$count = 0) {
		$tones_custom = array();
		$query = $ba->select("SELECT * FROM tones_custom". (is_null($name) ? '' : " WHERE name='$name'"));
		while ($entry = $ba->fetch_array($query, SQLITE_ASSOC)) {
			$name = $entry['name'];
			unset($entry['name']);
			$tones_custom[$name] = $entry;
			$count++;
		}
		return $tones_custom;
	}

	public function getTonesCredentials() {
		// set table in showing order
		$class = array(
			'input-div'	=> 'col-sm-8',
			'label'			=> 'col-sm-3 control-label',
		);
		$toshow = array(
			'description' => array(
				'class'			=> $class,
				'disabled'	=> true,
				'function' 	=> 'fieldText',
				'title'			=> 'TONES_CREDENTIALS_DESCRIPTION_DIS',
				'tooltip'		=> 'TONES_CREDENTIALS_DESCRIPTION_TT',
				'validator'	=> 'config-option',
			),
			'dial' => array(
				'class'			=> $class, 
				'disabled'	=> true,
				'function'	=> 'fieldText',
				'title'			=> 'TONES_CREDENTIALS_DIAL_DIS',
				'tooltip'		=> 'TONES_CREDENTIALS_DIAL_TT',
				'validator'	=> 'config-option',
			),
			'busy' =>array(
				'class'			=> $class,
				'disabled'	=> true,
				'function' 	=> 'fieldText',
				'title'			=> 'TONES_CREDENTIALS_BUSY_DIS',
				'tooltip'		=> 'TONES_CREDENTIALS_BUSY_TT',
				'validator'	=> 'config-option',
			),
			'ring' => array(
				'class'			=> $class,
				'disabled'	=> true,
				'function' 	=> 'fieldText',
				'title'			=> 'TONES_CREDENTIALS_RING_DIS',
				'tooltip'		=> 'TONES_CREDENTIALS_RING_TT',
				'validator'	=> 'config-option',
			),
			'congestion' => array(
				'class'			=> $class,
				'disabled' 	=> true,
				'function' 	=> 'fieldText',
				'title'			=> 'TONES_CREDENTIALS_CONGESTION_DIS',
				'tooltip'		=> 'TONES_CREDENTIALS_CONGESTION_TT',
				'validator'	=> 'config-option',
			),
			'acp_detect' => array(
				'class'			=> $class,
				'disabled'	=> true,
				'function' 	=> 'fieldText',
				'title'			=> 'TONES_CREDENTIALS_ACPDETECT_DIS',
				'tooltip'		=> 'TONES_CREDENTIALS_ACPDETECT_TT',
				'validator'	=> 'config-option',
			),
			'acp_event' => array(
				'class'			=> $class,
				'disabled'	=> true,
				'function' 	=> 'fieldText',
				'title'			=> 'TONES_CREDENTIALS_ACPEVENT_DIS',
				'tooltip'		=> 'TONES_CREDENTIALS_ACPEVENT_TT',
				'validator'	=> 'config-option',
			),
		);
		return $toshow;
	}

	public function tonesCredentials($credentials, $disabled) {
		$toshow = self::getTonesCredentials();
		require_once('/usr/local/www/berogui/includes/Helper/HelperHtml.php');
		// build html
		$html = '';
		foreach ($toshow as $key => $param) {
			$param['disabled'] = $disabled;
			$function = $param['function'];
			$html .= HelperHtml::$function($key, $credentials[$key], $param);
		}
		$html .= HelperHtml::buttons('btndelete', TONES_CREDENTIALS_DELETE_CUSTOM_BTN, array(
			'name' 	=> 'btndelete',
			'style' => 'margin-bottom:10px;',
			'type' 	=> 'button',
		));
		return $html;
	}

	/**
	 * Return generic text field
	 */
	static function textfield($ba, $gr, $col, $table, $default = "") {
		if ($gr != "") {
			$query = $ba->select("select " . sqlite_escape_string($col) . " from " . sqlite_escape_string($table) . " where gr='" . sqlite_escape_string($gr) . "'");
			$value = "";
			while ($entry = $ba->fetch_array($query)) {
				$value = $entry[$col];
			}

			$ret = "<input class='form-control' name='" . $col . "' id='" . $col . "' value='" . $value . "'>";
			return $ret;
		} else {
			$ret = "<input class='form-control' name='" . $col . "' id='" . $col . "' value='" . $default . "'>";
			return $ret;
		}
	}
	
	static function textarea($ba, $gr, $col, $table, $default = "") {
			
		$safeCol = htmlspecialchars($col, ENT_QUOTES, 'UTF-8');
		
		if ($gr != "") {
			$cmd = "select " . sqlite_escape_string($col) . " from " . sqlite_escape_string($table) . " where gr='" . sqlite_escape_string($gr) . "'";
			
			$query = $ba->select("select " . sqlite_escape_string($safeCol) . " from " . sqlite_escape_string($table) . " where gr='" . sqlite_escape_string($gr) . "'");
			$value = "";
			
			while ($entry = $ba->fetch_array($query)) {
				$value = $entry[$safeCol];
			}
			
			if (substr($value, 0, 1) === '"' && substr($value, -1) === '"') {
				$value = substr($value, 1, -1);
			}
			else {
				$value="";
			}
			
			$safeValue = htmlspecialchars ($value, ENT_QUOTES, 'UTF-8');
			$safeValue = str_replace("\t", "\n", $safeValue);
			
			$ret = "<textarea class='form-control' name='{$safeCol}' id='{$safeCol}' rows='5'>".$safeValue."</textarea>";
			return $ret;
		} else {
			$ret = "<textarea class='form-control' name='{$safeCol}' id='{$safeCol}' rows='5'></textarea>";
			return $ret;
		}
	}

	
	static function pstnPasswordField($ba, $gr, $col, $table, $default = "") {
		if ($gr != "") {
			$query = $ba->select("select " . sqlite_escape_string($col) . " from " . sqlite_escape_string($table) . " where gr='" . sqlite_escape_string($gr) . "'");
			$value = "";
			while ($entry = $ba->fetch_array($query)) {
				$value = $entry[$col];
			}

			$ret = "<input class='form-control' name='" . $col . "' id='" . $col . "' type='password' autocomplete='new-password' value='" . $value . "'>";
			return $ret;
		} else {
			$ret = "<input class='form-control' name='" . $col . "' id='" . $col . "' type='password' autocomplete='new-password' value='" . $default . "'>";
			return $ret;
		}
	}
	
	/**
	 * Return a generic dropdown field
	 */
	static function dropdown($ba, $gr, $col, $table, $options, $default = "") {
		$query = $ba->select("select distinct " . sqlite_escape_string($col) . " from " . sqlite_escape_string($table) . " where gr='" . sqlite_escape_string($gr) . "'");
		$sel .= "<select class='form-control' name='" . $col . "'>";
		while ($entry = $ba->fetch_array($query)) {
			$default = $entry[$col];
		}
		foreach ($options as $name => $value) {
			($name == $default) ? $sel .= "<option value='" . $name . "' selected>" . $value . "</option>" : $sel .= "<option value='" . $name . "'>" . $value . "</option>";
		}
		$sel .= "</select>";
		return $sel;
	}

	static function sip_peer_dropdown($ba, $gr, $col, $default = "") {
	
		$query = $ba->select("SELECT monitored_sip_peer from isdn where gr='" . sqlite_escape_string($gr) . "'");
		while ($entry = $ba->fetch_array($query)) {
			$default = $entry[$col];
		}
		$query = $ba->select("SELECT name from sip");
		$sel .= "<select class='form-control' name='" . $col . "'>";
		
		($default == "") ? $selected = "selected" : $selected = "";
		$sel .= "<option value='' $selected>" . "</option>";
		
		while ($entry = $ba->fetch_array($query)) {
			($default == $entry['name']) ? $selected = "selected" : $selected = "";
			$sel .= "<option value='" . $entry['name'] . "' " . $selected . ">" . $entry['name'] . "</option>";
		}
		$sel .= "</select>";
		return $sel;
	}

	/**
	 * Return a generic checkbox
	 */
	static function checkbox($ba, $gr, $col, $table, $htmlOptions = '', $default = "") {
		$query = $ba->select("select " . sqlite_escape_string($col) . " from " . sqlite_escape_string($table) . " where gr='" . sqlite_escape_string($gr) . "'");
		while ($entry = $ba->fetch_array($query)) {
			if ($entry[$col] == 1)
				$default = "checked";
			else
				$default = "";
		}

		$ret = "<input type='hidden' name='$col' value='0'>"
			. "<input type='checkbox' name='$col' id='$col'  value='1' $default $htmlOptions>";
		return $ret;
	}

	/**
	 * Additional config string bei einem Update
	 */
	function showdefmc($config_values, $letter, $table) {
		require_once '/usr/local/www/berogui/includes/Helper/Helper.php';
		$zeilen = Helper::getConfigFromIsgw();
		foreach ($zeilen as $zeile) {
			if (stripos($zeile, '[') === 0) {
				preg_match("/\[(?<bez>.+)\]\[(?<name>.+)\][\s]*(?<desc>.+)[\s]*\<(?<val>.*)\>[\s]*'(?<def>.*)'/", $zeile, $res);
				if (!in_array($res['name'], $config_values) && ($res['bez'] == $letter || $res['bez'] == "p" || $res['bez'] == "*"))
					echo "<script>
                            var extra_tooltip=document.getElementById('extra_tooltip');
                            extra_tooltip.innerHTML=extra_tooltip.innerHTML+'<p>" . DIALPLAN_OPTION_DIS . "<b>&nbsp;" . $res['name'] . "</b><br>" . DIALPLAN_VALUES_DIS . "<b>&nbsp;&lt;" . $res['val'] . "&gt;</b><br>Default:<b>&nbsp;" . $res['def'] . "</b><br><i>" . htmlspecialchars($res['desc'], ENT_QUOTES) . "</i></p><br>';
			</script>";
			}
		}
		$ba = new beroAri();
		$query = $ba->select("select config from " . sqlite_escape_string($table) . " where gr='" . sqlite_escape_string($_GET['gr']) . "' group by gr");
		while ($entry = $ba->fetch_array($query)) {
			$config = $entry['config'];
		}
		if ($config != "") {
			$configs = explode(',', $config);
			foreach ($configs as $value) {
				$key = explode('=', $value, 2);
				if ($key[0] != "" && $key[1] != "" && !in_array($key[0], $config_values)) {
					echo "<script>var addit_options=document.getElementById('addit_options');
                            	if (addit_options.innerHTML=='')
                                    addit_options.innerHTML='" . $key[0] . "=" . $key[1] . "';
				else
                                    addit_options.innerHTML=addit_options.innerHTML+'\\n" . $key[0] . "=" . $key[1] . "';</script>";
				} elseif ($key[0] != "" && $key[1] == "" && !in_array($key[0], $config_values)) {
					echo "<script>var addit_options=document.getElementById('addit_options');
                                    if (addit_options.innerHTML=='')
                                        addit_options.innerHTML='" . $key[0] . "=';
                                    else
                                        addit_options.innerHTML=addit_options.innerHTML+'\\n" . $key[0] . "=';</script>";
				}
			}
		}
	}

	/**
	 * Additional config string beim Hinzufügen einer Portgruppe
	 */
	function show_confadd($config_values, $letter) {
		require_once '/usr/local/www/berogui/includes/Helper/Helper.php';
		$zeilen = Helper::getConfigFromIsgw();
		foreach ($zeilen as $zeile) {
			if (stripos($zeile, '[') === 0) {
				preg_match("/\[(?<bez>.+)\]\[(?<name>.+)\][\s]*(?<desc>.+)[\s]*\<(?<val>.*)\>[\s]*'(?<def>.*)'/", $zeile, $res);
				if (!in_array($res['name'], $config_values) && ($res['bez'] == $letter || $res['bez'] == "p" || $res['bez'] == "*"))
					echo "<script>
			var extra_tooltip=document.getElementById('extra_tooltip');
			extra_tooltip.innerHTML=extra_tooltip.innerHTML+'<p>" . DIALPLAN_OPTION_DIS . "<b>&nbsp;" . $res['name'] . "</b><br>" . DIALPLAN_VALUES_DIS . "<b>&nbsp;&lt;" . $res['val'] . "&gt;</b><br>Default:<b>&nbsp;" . $res['def'] . "</b><br><i>" . htmlspecialchars($res['desc'], ENT_QUOTES) . "</i></p><br>';
		</script>";
			}
		}
	}

	public function hasAnalog($ba) {
		return (sqlite_num_rows($ba->select("SELECT * from analog where port_type='FXS'")) > 0 || sqlite_num_rows($ba->select("SELECT * from analog where port_type='FXO'")) > 0);
	}
}
