<?php
/**
 * @file
 * popup window for isdn and anolog groups
 */
require_once('/usr/local/www/berogui/includes/Helper/Helper.php');

$load_popup = 1;
$invalid = array();

/* [CHECKING GET VARIABLE] */
$list_get = array(	'start' => 'start'	, 
			'id'	=> 'id'		);

$_GET = Helper::sanitizeGet($_GET, $list_get, $load_popup, $invalid);

/* [CHECKING POST] */
unset($_POST);

/* [DISPLAYING POPUP] */
if (!$load_popup) {
	echo "<script>window.location='../../index.php?m=Acl&error=1&request={$invalid['request']}&checkor={$invalid['checkor']}&key={$invalid['key']}'</script>";
	exit(1);
}

chdir("../..");

include "./includes/variables.php";
include_once("/usr/www/include/SQLite2ToSQLite3.php");
include "./misc/database.php";
include("./misc/config_parameter.php");
$ba = new beroAri();
require_once ('./includes/lang.php');
require_once('/usr/local/www/berogui/includes/session.php');

$id = sqlite_escape_string($_GET['id']);
$start = $_GET['start'];

?>
<script type="text/javascript">
    $("#acll").validate({
                    
        rules: {
                        
            address: { 
                checkHostname : true, 
                required: true
            },
            netmask: {
                required:true,
                digits: true,
                range: [0,32],
                },
                manual_dest_port: {
                    required: {
                        depends: function (element) {
                            return $("#dest_port option:selected").val() == "manual";
                        }
                    },
                    digits: true,
                    range: [1, 65535],
                },
            }
        });

        $("#dest_port").change(function () {
            required();
        });

        function required() {
            if ($("#dest_port option:selected").val() == "manual") {
                addAsterisk("manual_dest_port");
            } else {
                deleteAsterisk("manual_dest_port");
            }
        }

        function hide_elements() {
            if ($('#dest_port').val() === "manual")
                $('#manual_dest_port').show();
            else
                $('#manual_dest_port').hide();
        }
	
	$( document ).ready(function() {
		hide_elements();
		required();
	});

</script>
<?php

function protocol($ba, $id){
    $allProtocol=array(""=>"All","udp"=>"UDP","tcp"=>"TCP");
    if ($id!="") $protocol=  getValue ($ba, $id, "protocol");
    $result="<select name='protocol' class='form-control'>";
    foreach ($allProtocol as $key=>$value){
        ($key===$protocol) ? $selected="selected='true'" : $selected="";
        $result.="<option value='$key' $selected>$value</option>";
    }
    $result.="</select>";
    return $result;
}



function action($ba, $id){
    $allAction=array("ACCEPT"=>"ACCEPT","DROP"=>"DROP");
    if ($id!="") $action=  getValue ($ba, $id, "action");
    $result="<select name='action' class='form-control'>";
    foreach ($allAction as $key=>$value){
        ($key===$action) ? $selected="selected='true'" : $selected="";
        $result.="<option value='$key' $selected>$value</option>";
    }
    $result.="</select>";
    return $result;
}


function stack($bc, $ba, $id) {
	$allStack = array (
			"" => "ANY",
			"LAN" => $ba->get('root', 'is-vpn-running') == 1 ? "LAN/VPN" : "LAN",
			"WAN" => "WAN"
	);
	
	if ($id != "") {
		$stack = getValue ($ba, $id, "stack" );
	}
	
	$result = "<select name='stack' class='form-control'>";
	foreach ( $allStack as $key => $value ) {
		($key === $stack) ? $selected = "selected='true'" : $selected = "";
		$result .= "<option value='$key' $selected>$value</option>";
	}
	$result .= "</select>";
	return $result;
}

function dest_port($ba, $id, &$manual_port = null){
    $port=array(-1=>"SIP",-2=>"SIP-TLS",80=>"HTTP",443=>"HTTPS",54322=>"Telnet",22=>"SSH",161=>"SNMP",162=>"SNMP-Trap",65001=>"bfdetect","all" => "All");
    if ($id!="") {
        $dest_port=  getValue ($ba, $id, "dest_port");
        if (!array_key_exists($dest_port, $port)){
            $manual="selected='true'";
            $manual_port=$dest_port;
        }
    }
    $result="<select name='dest_port' id='dest_port' onchange='hide_elements();' class='form-control'>";
    foreach ($port as $key=>$value){
        ($key==$dest_port) ? $selected="selected='true'" : $selected="";
        $result.="<option value='$key' $selected >$value</option>";
    }
    $result.="<option value='manual' $manual>Manual</option>"; 
		$result.="</select>";

    return $result;
}

function acl_rule($ba, $id){
    $address= getValue ($ba, $id, "address");
    $netmask= getValue ($ba, $id, "netmask");
    $action = getValue ($ba, $id, "action");
    $result="<div class='col-sm-7' style='padding-left:0px'><input type='text' name='address' value='$address' size='15' class='form-control input-sm' /></div>"
	    . "<div class='col-sm-1' style='padding-top: 5px;'>/</div>"
	    . "<div class='col-sm-4'><input type='text' name='netmask' class='form-control input-sm' value='$netmask'size='2' /></div>\n";
    return $result;
}

function getValue($ba, $id,$colname){
    $query=$ba->select("select $colname from acl where id='$id'");
    return sqlite_fetch_single($query);
}


function show_stack_field_on_lanwan($bc) {
	if ($bc->get ( 'root', 'lan-mode' ) == 'lan-wan') {
		return 1;
	}
	else {
		return 0;
	}
}

$manual_port = '';
?>
<form class='form-horizontal' name='acll' id='acll' action='modules/Acl/acl_submit.php' method='POST'>
        <input type=hidden name='start' value='<?php echo $start; ?>'>
	<div class='form-group'>
	    <label for='protocol' class='col-sm-4 control-label'><?php echo ACL_PROTOCOL_DIS; ?></label>
	    <div class='col-sm-6'>
		<?php echo protocol($ba, $id); ?>
	    </div>
	</div>
	<div class='form-group'>
	    <label for='action' class='col-sm-4 control-label'><?php echo ACL_ACTION_DIS; ?></label>
	    <div class='col-sm-6'>
		<?php echo action($ba, $id); ?>
	    </div>
	</div>
<?php
$bc = new beroConf ( 'root' );
if (show_stack_field_on_lanwan($bc)) {
?>
	<div class='form-group'>
	    <label for='stack' class='col-sm-4 control-label'><?php echo "Stack"; ?></label>
	    <div class='col-sm-6'>
		<?php echo stack($bc, $ba, $id); ?>
	    </div>
	</div>
	
<?php }
?>
	
	<div class='form-group'>
	    <label for='manual_dest_port' class='col-sm-4 control-label'><?php echo ACL_DEST_PORT_DIS; ?></label>
	    <div class='col-sm-6'>
		<?php echo dest_port($ba, $id, $manual_port); ?>
	    </div>
	</div>
	<div class='form-group' id='manual_dest_port' style='display:none;'>
	    <label for='set_manual_dest_port' class='col-sm-4 control-label'></label>
			<div class='col-sm-6'>
				<input name='manual_dest_port' class='form-control input-sm' value='<?php echo $manual_port; ?>'>
			</div>
	</div>
	<div class='form-group'>
	    <label for='address' class='col-sm-4 control-label'><?php echo ACL_ACL_RULE_DIS; ?></label>
	    <div class='col-sm-6'>
		<?php echo acl_rule($ba, $id); ?>
	    </div>
	</div>
	<div class='text-center'><i><?php echo REQUIRED_FIELDS; ?></i></div>
	<br/>
	<input type='hidden' name='id_upd' value='<?php echo $id; ?>'>
	<div class='text-center'>
		<button type='submit' class='btn btn-default'><?php echo BUTTON_SAVE; ?></button>
	</div>
</form>
