<?php

/**
 * Implementiert die CRUD Operationen für CAS Portgruppen
 * 
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class Cas {

	private		$m_attr;

	private		$isRequestRejected = 0,
			$reasonRejected = array();

	/**
	 * Constructor
	 */
	function __construct($m = '', $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;

                // get error from modal or submit execution
                if (isset($get['error'])) {
			$this->isRequestRejected = true;
                        $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
                	unset($get['error'], $get['request'], $get['checkor'], $get['key']);
                }
	}

	/**
	 * Funktion display erzeugt den Inhalt von der HTML-Seite
	 * @return string HTML Inahalt
	 */
	function display() {

		$m = $this->m_attr;

		$name = "CAS_TITLE_DIS";
		include('./includes/header.php');
	
		if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		$cas_table = $this->dynamic_table();

		$opt = explode("-", $m);
		// build page content
		$ret .= "
			<script>
			function del(table,option,opt){
				conf = confirm('" . PSTN_DELETE_MESS1_DIS . " '+option+'? " . PSTN_DELETE_MESS2_DIS . "');
				if (conf==false)
					return false;
				else
					window.location='./misc/delete.php?m=" . $m . "&gr='+option+'&table='+table+'&opt='+opt;
			}
			</script>
			<div class='modal fade bs-example-modal-lg' id='cas-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
				  <div class='modal-dialog modal-lg'>
				    <div class='modal-content'>
				      <div class='modal-header'>
					<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
					<h4 class='modal-title' id='myModalLabel'>CAS</h4>
				      </div>
				      <div class='modal-body'>
				      </div>
				    </div>
				  </div>
				</div>
			<br>
			" . $cas_table . "
			<br>
			<div class='text-center'>
			<a href='modules/Cas/cas_popup.php' role='button' data-remote='false' data-toggle='modal' data-target='#cas-popup' class='btn btn-default'>
				" . BUTTON_ADD . "
			</a>
		</div>
			<script>
			$('#cas-popup').on('show.bs.modal', function(e) {
				var link = $(e.relatedTarget);
				$('.modal-body').load(link.attr('href'));
			});
			$('#cas-popup').on('hidden.bs.modal', function(e) {
				$('.modal-body').empty();
			});
		</script>
			</form>";

		return $ret;
	}

	/**
	 * Erstellt die HTML Tabelle für die CAS Portgruppen
	 * @return string HTML Tabelle
	 */

	function dynamic_table() {
		//ein neues Datenbankobjekt wird erzeugt.
		$ba = new beroAri();
		require_once("./includes/lang.php");

		$cols .= "<th>" . PSTN_GROUP_DIS . "</th>";
		$cols .= "<th>" . PSTN_CHANNELS_DIS . "</th>";
		$opt = explode("-", $this->m_attr);
		$query = $ba->select('SELECT DISTINCT gr FROM cas_channels WHERE gr!="NULL"');
		$rows = '';
		while ($entry = $ba->fetch_array($query)) {
			$query_channel = $ba->select('SELECT channel FROM cas_channels WHERE gr=\'' . $entry['gr'] . '\' ORDER BY channel asc');
			$channels = array();
			while ($entrych = $ba->fetch_array($query_channel)) {
				array_push($channels, $entrych['channel']);
			}
			//Channel Range erzeugen
			$minus = false;
			for ($i = 0; $i < count($channels); $i++) {
				//Der erste Channel
				if ($i == 0)
					$value = $channels[$i];
				//Minus hinzufügen wenn das aktuelle Element Nachfolger
				//des vorherigen ist
				elseif ($channels[$i] == $channels[$i - 1] + 1 && !$minus) {
					$minus = true;
					$value .= "-";
					//Wenn ein Minus bereits hinzugefügt wurde aber das aktuelle
					//Elemente kein Nachfolger des Vorherigen ist, Range schließen 
					//und aktueller Element hinzufügen
				} elseif ($channels[$i] != $channels[$i - 1] + 1 && $minus) {
					$value .= $channels[$i - 1] . "," . $channels[$i];
					$minus = FALSE;
					//Wenn kein Range vorhanden ist einfach das aktuelle Element durch
					//Komma separiert hinzufügen
				} elseif (!$minus) {
					$value .= "," . $channels[$i];
				}
				//Falls das letzte Channel zu einem Range gehört, Reihe beenden
				if ($minus && $i == count($channels) - 1)
					$value .= $channels[$i];
			}
			$rows .= "<tr><td>" . $entry['gr'] . "</td><td>" . $value . "</td>";
			$rows .= "<td class='buttons'>
					<a href='modules/Cas/cas_popup.php?gr=" . $entry['gr'] . "' data-remote='false' data-toggle='modal' data-target='#cas-popup' class='popup_download'>
					<img src='./includes/images/modify.png' onmouseover=\"Tip('" . MOD_CAS_MODIFY . "')\" onmouseout='UnTip()'>
				</a>&nbsp;
				<a class='popup_download' onclick=\"del('cas','" . $entry['gr'] . "','" . $this->m_attr . "');\">
            	    <img src='./includes/images/delete.png' onmouseover=\"Tip('" .
				MOD_CAS_DELETE . "')\" onmouseout='UnTip()'>
				</a>
			</td></tr>";
		}



		$table = "<table class='table table-striped table-bordered' id='table'><tr>" . $cols . "<th></th></tr>" . $rows . "</table>";
		//Rückgabe: Erzeugte Tabelle mit den Einträgen der Tabelle cas der Datenbank
		return $table;
	}

}

?>
