<?php

/**
 * Implementiert die Einstellung  der zeitrelevante Parameter
 * @author Miguel Palmer <mp@beronet.com>
 */

include_once('/usr/www/include/SQLite2ToSQLite3.php');

class TimeConf {

	private	$m_attr,
			$_timezone_list = array(),
			$_swtime_auto_list = array(),
			$_default_timezone = 'GMT+0100';

	private $isIsgwLoginFailed = 0;

	private	$isRequestRejected = 0,
			$reasonRejected = array();

	private	$default = array();

	private	$showDate = 0;
	/**
	 * Constructor
	 */
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this->m_attr = $m;
		$this->showDate = (isset($get['showDate']) && $get['showDate'] == 1) ? 1 : 0;
		unset($get['showDate']);		

		// isgw failed to start
		if (isset($get['isgwerror'])) {
			$this->isIsgwLoginFailed = 1;
			unset($get['isgwerror']);
		}
        // get error from modal or submit execution
        else if (isset($get['error'])) {
            $this->isRequestRejected = 1;
            $this->reasonRejected = array('request' => $get['request'], 'checkor' => $get['checkor'], 'key' => $get['key']);
            unset($get['error'], $get['request'], $get['checkor'], $get['key']);
        }

		$this->_timezone_list = Helper::getTimezoneList();
	}

	/**
	 * Generates the HTML page
	 * @return string
	 */
	function display() {

		include '/usr/fallback/beroConf.php';
		$bc = new beroConf('root');
		$ba = new beroAri();

		$name = "TIME_TITLE_DIS";
		include('./includes/header.php');
		require_once("./includes/lang.php");

		// args
		$m = $this->m_attr;
		if (!$bc->valid()) {
			$ret .= '<h3>Error:</h3><b>Failed to connect to config database!</b><br>';
			exit(0);
		}
		
		if ($this->showDate) {
			$ret .= "<br/><div class='text-center'>" . Helper::getDate() . "</div><br/>";
		}

		// show warning if ISGW isn't started 
		if ($this->isIsgwLoginFailed) {
			$ret .= "<br><div class='text-center' style='margin-top:5px; color:red;'>".WARNING_MESSAGE_ISGW_SAVE."</div>";
		}
		// check request
		else if ($this->isRequestRejected) {
			$ret .= Helper::displayErrorMessage($this->reasonRejected['request'], $this->reasonRejected['checkor'], $this->reasonRejected['key']);
		}

		// TODO: a such check should be occur only one times and used everywhere
		$is_isdn_plugged = !$bc->get('root', 'is_sbc_vm') && 
					(sqlite_num_rows($db->select("SELECT * from isdn where port_type='PRI'"))>0 || sqlite_num_rows($db->select("SELECT * from isdn where port_type='BRI'"))>0);

		$ntp_hover = "";
		$gui_ntp_host = $bc->get("root", "gui-ntphost");
		if (!strlen ($gui_ntp_host)) {
			$ntp_host = $bc->get("root", "ntphost");
			if (strlen ($ntp_host)) {
				$ntp_hover = "onmouseover='Tip(\"" . "Using default NTP: " . $ntp_host . "\"" . ")' onmouseout='UnTip()'";
			}
		}

		$time_mode = $bc->get('root', 'time_mode');
		if ($time_mode == '') {
			$time_mode = $bc->get('root', 'time_from_isdn');
			if ($time_mode == 0 || $time_mode == 'no') {
				$time_mode = 'timezone';
			}
		}

		$timezone = $this->_setTimezone($bc->get('root', 'timezone'));
		$tz_mode = $bc->get('root', 'timezone_mode');

		ob_start();
		?>
		<form  name="timeform" id="timeform" class="form-horizontal" method="POST" action="modules/TimeConf/timeconf_submit.php">
			<input type="hidden" name="action" value="save">
			<div class='form-group' style='margin-top: 35px;'>
				<label for='for_time_mode' class='col-sm-5 control-label'><?php echo TIME_MODE_DIS ?></label>
				<div class='col-sm-4'>
					<select class="form-control input-sm" id='id_time_mode' name='time_mode'> 
						<?php echo $this->_timeModeOptions($time_mode, $is_isdn_plugged ? $ba : null); ?>
					</select>
				</div>
			</div>
			<div class='form-group' id="ntphost">
				<label  <?php echo $ntp_hover ?> for='ntphost' class='col-sm-5 control-label'><?php echo TIME_NTP_HOST_DIS ?></label>
				<div class='col-sm-4'>
					<input name="ntphost" <?php echo $ntp_hover ?> class="form-control input-sm" type="text" size="15" id="id_ntphost" value="<?php echo $gui_ntp_host ?>">
				</div>
			</div>
			<div class='form-group' id="tz">
				<label for='timezone' class='col-sm-5 control-label'><?php echo TIME_TIMEZONE_DIS ?></label>
				<div class='col-sm-4'>
					<select name="timezone" class="form-control input-sm" id="id_timezone">
						<?php echo $this->_timeZoneOptions($timezone); ?>
					</select>
				</div>
			</div>
			<div class='form-group' id="tzmode">
				<label for='timezonemode' class='col-sm-5 control-label'><?php echo TIME_TIMEZONE_MODE_DIS ?></label>
				<div class='col-sm-4'>
					<select name='timezone_mode' class='form-control input-sm' id='id_timezone_mode'>
						<?php echo $this->_timeZoneModeOptions($timezone, $tz_mode); ?>
					</select>
				</div>
			</div>
			<div class='form-group' id='display_manual'>
				<label for='manual' class='col-sm-5 control-label' onmouseover='Tip("<?php echo TIME_MANUAL_TOOLTIP_DIS; ?>")' onmouseout='UnTip()'><?php echo TIME_MANUAL_FIELD_DIS ?></label>
				<div class='col-sm-4'>
					<input class="form-control input-sm" type="text" size="15" name='time_manual' id='id_time_manual'
						value="<?php echo (substr($timezone, 0, 3) == 'GMT' ? $timezone : ''); ?>">
				</div>
			</div>
			<div class="text-center" style='margin-top: 30px;'>
				<input type="submit" class="btn btn-default" name="Apply" value="<?php echo BUTTON_SAVE ?>">
			</div>
		</form>
		<script>
			function displayTimeFields(value) {
				if (value == 'none' || (!isNaN(value) && (function(x) { return (x | 0) === x; })(parseFloat(value)))) {
					document.getElementById('tz').style.display = 'none';
					document.getElementById('tzmode').style.display = 'none';
					document.getElementById('ntphost').style.display = 'none';
					document.getElementById('display_manual').style.display = 'none';
				}
				else if (value == 'manual') {
					document.getElementById('tz').style.display = 'none';
					document.getElementById('tzmode').style.display = 'none';
					document.getElementById('ntphost').style.display = '';
					document.getElementById('display_manual').style.display = '';
				}
				else {
					document.getElementById('tz').style.display = '';
					document.getElementById('tzmode').style.display = '';
					document.getElementById('ntphost').style.display = '';
					document.getElementById('display_manual').style.display = 'none';
				}
			}
			function updateTimezoneOptions(timezone) {
				var options;
				var list_summerwinter_auto = ["<?php echo implode('","', $this->_swtime_auto_list); ?>"];
				if (list_summerwinter_auto.includes(timezone)) {
					options = {
						'auto' : '<?php echo TIME_TIMEZONE_MODE_AUTO_OPTION; ?>',
						'summer' : '<?php echo TIME_TIMEZONE_MODE_SUMMER_OPTION; ?>',
						'winter' : '<?php echo TIME_TIMEZONE_MODE_WINTER_OPTION; ?>',
					};
				}
				else {
					options = {
						'summer' : '<?php echo TIME_TIMEZONE_MODE_SUMMER_OPTION; ?>',
						'winter' : '<?php echo TIME_TIMEZONE_MODE_WINTER_OPTION; ?>',
					};
				}

				$("#id_timezone_mode").empty();
				$.each(options, function(key, val) {
					$('#id_timezone_mode').append($("<option></option>").attr("value", key).text(val));
				});
			}
			$('#id_time_mode').change(function() {
				displayTimeFields(this.value);
			});
			$('#id_timezone').change(function() {
				updateTimezoneOptions(this.value);
			});
			$(document).ready(function() {
				displayTimeFields($("#id_time_mode").val());
				$("#timeform").validate({
		        		rules: {
						time_manual: {
                    					required: "#id_time_manual:visible", 
							checkGmt: "#id_time_manual:visible",
						},
		            			ntphost: {
                    					required: "#id_ntphost:visible", 
		                			checkHostname: "#id_ntphost:visible",
		            			},
		        		}
		    		});
			});
		</script>
		<?php
		$ret .= ob_get_clean();

		return $ret;
	}

	/* [PRIVATE METHODS] */
	private function _setTimezone($timezone) {
		if (!in_array($timezone, array_keys($this->_timezone_list))) {
			if (preg_match('/^(\+|\-)([0-9]+)(:[0-9]+)?$/', $timezone, $match)) {
				$offset = $match[1] == '+' ? '-' : '+';
				$min = isset($match[3]) ? str_replace(':', '', $match[3]) : '00';
				if (strlen($match[2]) == 2) {
					$timezone = "GMT$offset{$match[2]}$min";
				}
				else if (strlen($match[2]) == 1) {
					$timezone = "GMT{$offset}0{$match[2]}$min";
				}
				if (in_array($timezone, array_keys($this->_timezone_list))) {
					return $timezone;
				}
			}
			return  $this->_default_timezone;
		}
		return $timezone;
	}

	private function _timeModeOptions($time_mode, $ba = null) {
		$selected[$time_mode] = ' selected';
		// set timezone option
		$options = "<option value='timezone'{$selected['timezone']}>". TIME_MODE_TIMEZONE_OPTION ."</option>\n";
		// set isdn time options
		if (!is_null($ba)) {
			$query = $ba->select("select port from isdn");
			while ($ports = $ba->fetch_array($query)) {
				$options .= "<option value='{$ports['port']}'{$selected[$ports['port']]}>ISDN Time - Port {$ports['port']}</option>\n";
			}
		}

		$options .= 	  "<option value='manual'{$selected['manual']}>". TIME_MODE_MANUAL_OPTION ."</option>\n"
				. "<option value='none'{$selected['none']}>". TIME_MODE_NONE_OPTION ."</option>\n";

		return $options;
	}

	private function _timeZoneModeOptions($timezone, $timezone_mode) {
		$options = '';
		$selected[$timezone_mode] = ' selected';
		if (in_array(strlen($timezone) ? $timezone : $this->_default_timezone, $this->_swtime_auto_list)) {
			$options .= "<option value='auto'{$selected['auto']}>". TIME_TIMEZONE_MODE_AUTO_OPTION ."</option>\n";
		}
		$options .=	  "<option value='winter'{$selected['winter']}>". TIME_TIMEZONE_MODE_WINTER_OPTION ."</option>\n"
				. "<option value='summer'{$selected['summer']}>". TIME_TIMEZONE_MODE_SUMMER_OPTION ."</option>\n";
		return $options;
	}

	private function _timeZoneOptions($tz_selected) {
		## since the _swtime_auto_list is generated here, this function must be called 
		## before to write the javascript code in the display function
		$options = '';
		if (in_array($tz_selected, array_keys($this->_timezone_list))) {
			$selected[strlen($tz_selected) ? $tz_selected : $this->_default_timezone] = ' selected';
		}
		else {
			$selected[$this->_default_timezone] = ' selected';
		}
		foreach ($this->_timezone_list as $tz => $tz_params) {
			$options .= "<option value='$tz'{$selected[$tz]}>{$tz_params['tz']}</option>\n";
			if ($tz_params['summer-winter']) {
				$this->_swtime_auto_list[] = $tz;
			}
		}
		return $options;
	}
}
?>
