<?PHP

if (defined('PHP_VERSION_ID')) {
	function sqlite_changes($db) {
		return $db->changes();
	}

	function sqlite_close($db) {
		return $db->close();
	}

	function sqlite_error_string($string) {
		return $string;
	}

	function sqlite_escape_string($string) {
		return SQLite3::escapeString($string);
	}

	function sqlite_exec($db, $sql) {
		return $db->exec($sql);
	}

	function sqlite_fetch_all($sql_result) {
		$rows = array();
		if ($sql_result) {
			while ($row = $sql_result->fetchArray()) {
				$rows[] = $row;
			}
		}
		return $rows;
	}

	function sqlite_fetch_array(&$sql_result, $type_array = null) {
		// type_array is used in old script (using sqlite2). Since the type_array variables change with 
		// sqlite3, we do not use them
		if ($sql_result) {
			$row = $sql_result->fetchArray();
			return $row;
		}
		return false;
	}

	function sqlite_fetch_column_types($sql_table, $db) {
		$column_types = array();
		if ($sql_result = $db->query("SELECT * FROM $sql_table")) {
			$sql_result->fetchArray(SQLITE3_NUM);
			for ($column = 0; $column < $sql_result->numColumns(); $column++) {
				$column_types[$sql_result->columnName($column)] = $sql_result->columnType($column);
			}
		}
		return $column_types;
	}

	function sqlite_fetch_single(&$sql_result) {
		// TODO: TOTEST
		if ($sql_result) {
			$row = $sql_result->fetchArray();
			return isset($row[0]) ? $row[0] : '';
		}
		return false;
	}

	function sqlite_has_more($sql_result) {
		return $sql_result->numColumns() && $sql_result->columnType(0);
	}

	function sqlite_last_error($db) {
		return $db->lastErrorMsg() . " code (". $db->lastErrorCode() .")";
	}

	function sqlite_last_insert_rowid($db) {
		return $db->lastInsertRowID();
	}

	function sqlite_num_fields($entry) {
		$div = 1;
		if (isset($entry[0]) && isset($entry['id']) && $entry[0] == $entry['id']) {
			$div = 2; // divide by 2 since we have two entries for a same field
		}
		return count($entry) / $div; 
	}

	function sqlite_num_rows($sql_result) {
		$nb_row = 0;
		if ($sql_result) {
			while ($row = $sql_result->fetchArray()) {
				$nb_row += 1;
			}
		}
		return $nb_row;
	}

	function sqlite_open($db_file, $permission = null, $key_encryption = null) {
		$db = null;
		if (is_null($permission)) {
			$db = new SQLite3($db_file);
		}
		else {
			$db = new SQLite3($db_file, SQLITE3_OPEN_READWRITE | SQLITE3_OPEN_CREATE);
		}
		return $db;
	}

	function sqlite_query($db, $sql) {
		// check INSERT INTO sql command
		if (preg_match('/^(INSERT INTO|insert into) ([-_A-Za-z9-9]+) \(([-_A-Za-z9-9 ,]+)\) VALUES/', $sql, $sql_matched)) {
			// TODO: maybe setup a migrate scenario during update as Yii2
			$table = $sql_matched[2];

			// fetch columns from sql command
			$sql_columns = explode(',', str_replace(' ', '', $sql_matched[3]));

			// fetch columns database
			$table_columns = array_keys(sqlite_fetch_column_types($table, $db));

			// if new column, add it to the database
			$list_new_columns = array();
			foreach ($sql_columns as $column) {
				if (!in_array($column, $table_columns)) {
					$list_new_columns[] = $column;
				}
			}
			if (!empty($list_new_columns)) {
				foreach ($list_new_columns as $column) {
					$column_type = _importColumnType($table, $column); 
					$alter_table = "ALTER TABLE $table ADD $column $column_type";
					$db->query($alter_table);
				}
			}
		}
		return $db->query($sql);
	}

	function sqlite_rewind(&$sql_result) {
		// TODO: must find a practice test
	}


	/* [private functions] */
	function _importColumnType($table, $new_column, $db_init_file = '/usr/local/conf/db/database_init.sql') {
		$db_init = file_get_contents($db_init_file);
		if (preg_match("/CREATE TABLE $table ([0-9a-zA-Z \',_\(\)-\[\]]+);/", $db_init, $table_matched)) {
			// remove first ( and last ) and explode the string
			$list_columns = explode(',', substr(substr($table_matched[1], 1, strlen($table_matched[1]) - 1), 0, -1));
			foreach ($list_columns as $column) {
				if (preg_match("/$new_column ([0-9a-zA-Z \'_\(\)-\[\]]+)/", $column, $column_matched)) {
					return $column_matched[1];
				}
			}
		}
		// return default
		return "VARCHAR(255)";
	}	
}
?>
