#!/usr/bin/php -q
<?php
require('/usr/php/include/configExportImportTool.class.php');
$_BACKUP = '/tmp/beroNetVoIPGateway_recoverymode.config.xml';

switch ($argv[1]) {
case 'create':
	$exp = new configExportImportTool();
	file_put_contents($_BACKUP, $exp->exportConfig());
	break;
case 'restore':
	if (!file_exists($_BACKUP)) {
		echo("Backup file does not exist ($_BACKUP)\n");
		exit(1);
	}
	else if (!file_exists('/usr/local/VERSION')) {
		echo("AppFs wiped out. Impossible to restore\n");
		exit(1);
	}
	$imp = new configExportImportTool($_BACKUP);
	if (($configFiles = $imp->getConfigFiles()) === false) {
		echo("Getting config files failed\n");
		exit(1);
	}

	// create backup-directory
	if (!is_dir('/usr/conf/backup')) {
		mkdir('/usr/conf/backup', '0777');
	}

	// go over configFiles
	foreach ($configFiles as $configFile) {
		// create backup of file
		@copy("/usr/conf/{$configFile['name']}", "/usr/conf/backup/{$configFile['name']}");
		unlink("/usr/conf/{$configFile['name']}");

		// write file
		if (($FP = fopen("/usr/conf/{$configFile['name']}", 'w')) == null) {
			@copy("/usr/conf/backup/{$configFile['name']}", "/usr/conf/backup/{$configFile['name']}");
			continue;
		}

		fwrite($FP, $configFile['data'], strlen($configFile['data']));
		fclose($FP);
		$FP = null;
	}

	// go over appConfigFiles
	if (($appConfigFiles = $imp->getAppConfigFiles()) !== false) {
		foreach ($appConfigFiles as $app) {
			mkdir("/usr/conf/userapp/{$app['name']}", '0777');

			if (empty($app['files'])) {
				continue;
			}

			foreach ($app['files'] as $appFile) {
				switch ($appFile['mode']) {
				case 'directory':
					system("/bin/mkdir -p /usr/conf/userapp/{$appFile['name']}");
					break;
				case 'binary':
					$fileData = base64_decode($appFile['content']);
					break;
				default:
					$fileData = $appFile['content'];
					break;
				}

				if ($appFile['mode'] != 'directory') {
					unlink("/usr/conf/userapp/{$appFile['name']}");
					$FP = fopen("/usr/conf/userapp/{$appFile['name']}", 'w');
					fwrite($FP, $fileData, strlen($fileData));
					fclose($FP);
					$FP = null;
					unset($fileData);
				}

				system("/bin/chown admin:admin /usr/conf/userapp/{$appFile['name']}");
			}
		}
	}

	require_once('/usr/local/php/include/restore.Class.php');
	$restore = new restoreConfig(0);
	$restore->restoreConfig();

	require_once('/usr/local/www/berogui/includes/fileManagement.php');
	$fm = new fileManagement();
	$fm->activate();
	break;
default:
	echo("Usage: {$argv[0]} [create|restore]\n\n");
	exit(1);
}

exit(0);
?>
