#!/usr/bin/php -q
<?php
if (!function_exists('curl_init')) {
	### curl could not be loaded (example: libcrypto is missing)
	### exit since the script does not work
	exit(0);
}

require('/usr/php/include/SbcApi.php');

## device updating firmware. blocking cloud request
if (file_exists('/var/run/install_daemon.pid')) {
	exit(0);
}

switch ($argv[1]) {
case 'api':
	try {
		$cloud = new SbcApi();
		proc_nice(15);
		$cloud->getTask();
		$cloud->sendStatus();
	}
	catch(Exception $e) {
		file_put_contents('/var/log/api-error.log' , $e->getMessage() .' '. $e->getFile() .' '. $e->getLine() ."\n", FILE_APPEND);
	}
	break;
case 'renew-ca':
	try {
		$cloud = new SbcApi();
		$cloud->renewCa();
	}
	catch(Exception $e) {
		file_put_contents('/var/log/api-error.log' , $e->getMessage() .' '. $e->getFile() .' '. $e->getLine() ."\n", FILE_APPEND);
	}
case 'update':
	try {
		$cloud = new SbcApi();
		$cloud->updateFW($cloud->send('firmwareDownload'));
	}
	catch(Exception $e) {
		file_put_contents('/var/log/api-error.log' , $e->getMessage() .' '. $e->getFile() .' '. $e->getLine() ."\n", FILE_APPEND);
	}
	break;
default:
	echo "Usage: {$argv[0]} [api|renew-ca|update]\n";
	break;
}

exit(0);
?>
