<?php
require_once ("/usr/local/php/include/apiCall.class.php");
require_once('/usr/local/php/include/cellBroadcastMessage.Class.php');

class CbmListMessages extends apiCall {

	private $_cbm;

	function __construct($get = null, $post = null, $files = null){
		parent::__construct($get,$post,$files);
		$this->_name = basename(dirname(__FILE__));
		$this->_cbm = new CellBroadcastMessageService();
	}
	
	function execute () {

		if (!isset($this->_parameters['CbmQueue'])) {
			$this->_execResultString = 'error:invalid_parameters;';
			$this->_execResult = false;
			$this->_execResponseCode = 405;
			return($this->_execResult);
		}

		$this->_execResultString .= ':' . $this->_parameters['CbmQueue'] . ':';

		$messages = $this->_cbm->listMessages($this->_parameters['CbmQueue']);
		if (($messages == null) || (count($messages) == 0)) {
			$this->_execResultString .= 'empty_queue;';
			return($this->_execResult);
		}


		foreach ($messages as $message) {
			$this->_execResultString .= $message . ';';
		}

		return($this->_execResult);
	}

	function display () {
		return($this->_name . ':' . $this->_execResultString);
	}

}?>
