<?php
/**
 * Description of HelperSipProfile
 *
 * @author Miguel Palmer <mp@beronet.com>
 */
class HelperSipProfile {

	/**
	 * Generiert die Liste der Kategorien der Sip Profile
	 * @return array
	 */
	static function getCategories() {
		$categories = array();
		$dh = @opendir("/usr/conf/profile");
		if (false === $dh) {
			return $categories;
		}
		while ($file = readdir($dh)) {
			if ("." == $file || ".." == $file)
				continue;
			array_push($categories, $file);
		}
		return $categories;
	}

	/**
	 * Gibt die Sip Profile einer bestimmte Kategorie zurück.
	 * @param string $category
	 * @return boolean|array
	 */
	static function getProfiles($category) {
		$profiles = array();
		$dh = @opendir("/usr/conf/profile/" . $category);
		if (false === $dh) {
			return false;
		}
		while ($file = readdir($dh)) {
			if ("." == $file || ".." == $file)
				continue;
			array_push($profiles, $file);
		}
		return $profiles;
	}
	
	static function uploadProfile($file){
		
	}

}
