<?php
/**
 * Erstellen und Herunterladen eines Backups.
 * Konfiguration anhand eines Backups wiederherstellen.
 * 
 * @author Miguel Palmer <mp@beronet.com>
 */
include('/usr/php/include/configExportImportTool.class.php');

class BackupRestore {

	private $_configFiles;
	private $_getImportConf;
	private $_otherGroups;
	private $_error = array();
	
	function __construct($m, $get = array(), $post = array(), $session = array()) {
		$this-> _getImportConf = new configExportImportTool;
		$this->_configFiles = $this->_getImportConf->getFileGroups();
		$this->_otherGroups =$this->_getImportConf->getSectionGroups();

		if (isset($get['error'])) {
			$this->_error = array('whichOne' => $get['error'], 'more' => isset($get['more']) ? $get['more'] : false);
		}
		unset($get, $post);
	}

	/**
	 * Erstellt die Backup and Restore Seite
	 * @return string HTML Inhalt
	 */
	function display() {

		$name = "BACKUP_RESTORE_TITLE_DIS";
		include('./includes/header.php');

		switch($this->_error['whichOne']) {
		case 1:
			$ret .= "<div id='error-bkuprste' class='text-center' style='margin-top:20px;color:red;'>". BACKUP_RESTORE_INVALID_XMLFILE ."</div>\n";
			break;
		case 2:
			$more = $this->_error['more'] ? ": {$this->_error['more']}" : '';
			$ret .= "<div id='error-bkuprste' class='text-center' style='margin-top:20px;color:red;'>". BACKUP_RESTORE_MISSING_CONFIGFILE ."$more</div>\n";
			break;
		case 3:
			$ret .= "<div id='error-bkuprste' class='text-center' style='margin-top:20px;color:red;'>". BACKUP_RESTORE_IMPORTING_FAILED ."</div>\n";
			break;
		case 4:
			$ret .= "<div id='error-bkuprste' class='text-center' style='margin-top:20px;color:red;'>". BACKUP_RESTORE_INVALID_TLSCERTIFICATE ."</div>\n";
			break;
		case 5:
			$ret .= "<div id='error-bkuprste' class='text-center' style='margin-top:20px;color:red;'>". BACKUP_RESTORE_RESTORING_FAILED ."</div>\n";
			break;
		default:
			break;
		}
		ob_start();
		?>
		<script>
		let answer;
			function checkUploadedFile (fileName) {
				if (fileName.length > 0) {
					// check if file has a .xml extension
					if (fileName.slice(-4) === '.xml') {
						selectFiles();
						return(false);
					}
					var baseName = fileName.replace(/.*\//, '');
					baseName = baseName.replace(/.*\\/, '');
					var allowedFiles = ['hardware.conf', 'isgw.analog', 'isgw.cas', 'isgw.causes', 'isgw.conf', 'isgw.cpt', 'isgw.dialplan','isgw.gsm', 'isgw.lte', 'isgw.isdn', 'isgw.sip', 'isgw.tdm', 'misc.conf', 'network.acl', 'isgw.tones'];
					for (i = 0; i < allowedFiles.length; i++) {
						if (baseName == allowedFiles[i]) {
							return(confirm('<?php echo BACKUP_RESTORE_CONFIRM_MESSAGE_DIS ?>'));
						}
					}
					alert('<?php echo BACKUP_RESTORE_ALERT_MESSAGE_CONFIG_FILE; ?>');
				}
				return(false);
			}
			//ajax request to get  list of files in config, then popup with files to select
			function selectFiles(){
				$('#modal-grid').empty();
				var formData = new FormData($('#importForm')[0]);
				answer = $.ajax({
					type: 'POST',
					url: 'modules/BackupRestore/BackupRestore_Popup.php?getFiles=true',
					data: formData,
					processData: false,
					mimeType: "multipart/form-data",
					contentType: false,
					success: function(){
						$('#modal-grid').append(answer.responseText);		
						$('#upload-popup').modal('toggle');
					},
				});
			}

			//select deselect button functions
			function deselect(group){
				$('[checkboxGroup="'+group+'"]').prop('checked',false);
			}
			function select(group){
				$('[checkboxGroup='+group+']').prop('checked',true);
			}
				
			addEventListener("click", (event) => {
				//normal page
				var group ='export';
				if( $('[checkboxGroup='+group+']input:checked').length> 0 && $('[checkboxGroup='+group+']input:checked').length < $('[checkboxGroup='+group+']').length){
					$('#buttonDeselect').show();
					$('#buttonSelect').show();
				}
				else if($('[checkboxGroup='+group+']input:checked').length==0){
					$('#buttonDeselect').hide();
					$('#buttonSelect').show();
				}
				else{
					$('#buttonSelect').hide();
					$('#buttonDeselect').show();
				}
				
				//popup
				group ='import';
				if( $('[checkboxGroup='+group+']input:checked').length> 0 && $('[checkboxGroup='+group+']input:checked').length < $('[checkboxGroup='+group+']').length){
					$('#buttonDeselectPopup').show();
					$('#buttonSelectPopup').show();
				}
				else if($('[checkboxGroup='+group+']input:checked').length==0){
					$('#buttonDeselectPopup').hide();
					$('#buttonSelectPopup').show();
				}
				else{
					$('#buttonSelectPopup').hide();
					$('#buttonDeselectPopup').show();
				}
			});
						
		</script>
		<br>
		<div class='modal fade bs-example-modal-lg' id='upload-popup' tabindex='-1' role='dialog' aria-labelledby='myModalLabel' aria-hidden='true'>
			<div class='modal-dialog modal-lg'>
				<div class='modal-content'>
					<div class='modal-header'>
						<button type='button' class='close' data-dismiss='modal' aria-label='Close'><span aria-hidden='true'>&times;</span></button>
						<h4><?php echo BACKUP_RESTORE_POPUP_TITLE?></h4>
					</div>
					<div id='modal-body' class='modal-body form-horizontal'>
						<div style='display: grid;
									grid-template-columns: 50% 50% ;
									justify-content:space-around;
									text-align:left;' id='modal-grid'>		
						</div>
						<div class="row text-center">
							<input type=hidden name='groups' value="true">
 							<input type="submit" name='nofiles' class="btn btn-default" data-toggle="tooltip" title="<?php echo BACK_RES_UPLOAD ?>"
								value="<?php echo BUTTON_UPLOAD ?>" onclick="if($('[checkboxGroup=import]input:checked').length >0)if(confirm('<?php echo BACKUP_RESTORE_CONFIRM_MESSAGE_DIS ?>') ==true)importForm.submit()">
								<button form="" class="btn btn-default" data-toggle="tooltip" style="display: none;" id="buttonSelectPopup" title="<?php echo BACK_RES_SELECT ?>" onclick="select('import')">
							<?php echo BACKUP_RESTORE_CHECKBOX_SELECT?>
							</button>
							<button form="" class="btn btn-default" data-toggle="tooltip" id="buttonDeselectPopup" title="<?php echo BACK_RES_DESELECT ?>" onclick="deselect('import')">
								<?php echo BACKUP_RESTORE_CHECKBOX_DESELECT?>
							</button>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="panel panel-default" style="max-width:600px; margin:auto;">
			<div class="panel-heading text-center lead">
				<?php echo BACKUP_RESTORE_DOWNLOAD_DIS ?>
			</div>
			<div class="panel-body text-center">
				<h4><?php echo BACKUP_RESTORE_DOWNLOAD_DESC;?></h4><br>
				<form name="download" action="misc/files_download.php" method="GET" class="form-horizontal">
				<input type=hidden name='groups' value="true" checked="true">
						<?php foreach($this->_configFiles as $key => $tooltip){
							if(preg_match('/(ANALOG|ISDN|GSM|CAS|LTE)/',$key) ==1) {
								$tooltip =constant($tooltip).'isgw.'.strtolower($key);
							}
							echo '<div class="form-group"style="margin-bottom: 8px;">'.
									'<div class="col-sm-7 control-label">'.
										'<label for="'.$key.'" data-toggle="tooltip" title ="'.((@constant($tooltip))?constant($tooltip): $tooltip).'">'.((@constant($key))?constant($key): $key).'</label>'.
									'</div>'.
									'<div class="col-sm-3 form-checkbox">
										<input type="checkbox" id="'.$key.'" checkboxGroup="export" name="configFiles['.$key.']" value="'.$key.'" checked="true"> 
									</div>'.
								"</div>";
						}
						foreach($this->_otherGroups as $group => $optionName){
							echo '<div class="form-group" style="margin-bottom: 8px;">'.
									'<div class="col-sm-7 control-label">'.
										'<label for="'.$group.'" data-toggle="tooltip" title ="'.((@constant($optionName[1]))?constant($optionName[1]): $optionName[1]).'">'.((@constant($group))?constant($group): $group).'</label>'.
									'</div>'.
									'<div class="col-sm-3 form-checkbox" data-toggle="tooltip">'.
										'<input id="'.$group.'" type="checkbox" checkboxGroup="export" name="importOptions['.$optionName[0].']" value="true" checked="true">'
									."</div>".
								"</div>";
						}?>
						<div style="margin-top: 30px;">
						<button type="submit" form="" class="btn btn-default" data-toggle="tooltip" name="selectFiles" value=true title="<?php echo BACK_RES_DOWNLOAD ?>" onclick="if($('[checkboxGroup=export]input:checked').length >0)download.submit()" >
							<?php echo BACKUP_RESTORE_DOWNLOAD_LINK_DIS?>
						</button>
						<button form="" class="btn btn-default" data-toggle="tooltip" style="display: none;" id="buttonSelect"title="<?php echo BACK_RES_SELECT ?>" onclick="select('export')">
							<?php echo BACKUP_RESTORE_CHECKBOX_SELECT?>
						</button>
						<button form="" class="btn btn-default" data-toggle="tooltip" id="buttonDeselect"title="<?php echo BACK_RES_DESELECT ?>" onclick="deselect('export')">
							<?php echo BACKUP_RESTORE_CHECKBOX_DESELECT?>
						</button>
						</div>
				</form>
			</div>
		</div>
		<br>
		<br>
		<div class="panel panel-default" style="max-width:600px; margin:auto;">
			<div class="panel-heading text-center lead">
				<?php echo BACKUP_RESTORE_RESTORE_DIS ?>
			</div>
			<div class="panel-body text-center">
				<form name="upload"  id='importForm' action="misc/upload.php" method="POST" ENCTYPE="multipart/form-data">
					<div class="row">
						<div class="col-lg-2 col-lg-offset-2">
							<input type="file" id="iduploadfile" name="uploadfile" data-toggle="tooltip" title="<?php echo BACK_RES_FILE ?>" >
						</div>
					</div>
					<br>
					<div class="row text-center">
						<input type="submit" class="btn btn-default" data-toggle="tooltip" title="<?php echo BACK_RES_UPLOAD ?>" value="<?php echo BUTTON_UPLOAD ?>"
								onclick="return checkUploadedFile($('#iduploadfile').val())">
						&nbsp;&nbsp;
						<input type="reset" class="btn btn-default" value="<?php echo BUTTON_RESET ?>" data-toggle="tooltip" title="<?php echo BACK_RES_RESET ?>">
					</div>
				</form>
			</div>
		</div>
		<?php
		$ret .= ob_get_clean();

		return $ret;
	}

}
?>
